#!/usr/bin/python26
###
### backmon.commands.cat
###

import sys
import os
import os.path
import glob
import re

from optparse import OptionParser

from ..lib import *

usage = 'usage: %prog -s server cat [filename]'

parser = OptionParser(usage=usage)

def run(args, kwargs):

    #
    # add kwargs to local namespace
    #
    for key in kwargs.keys():

        if re.compile('^[A-Z][A-Z_]+$').match(key):
            exec(key + ' = kwargs[\'' + key + '\']')

    (options, args) = parser.parse_args(args)

    if not OPTIONS.server:
        ERROR('Please specify a server to use the cat command.')
        sys.exit(1)
    elif( len(args) == 0 ):
        ERROR('No filename specified.')
        sys.exit(1)
    else:
        filename = args.pop(0)
        DEBUG('FILENAME=%s' % (filename))
        updates = Updates(LOGGER, SERVER_PATH)

        file = updates.open(filename)
        
        if file is not None:
            for line in file:
                sys.stdout.write(line)
            updates.close(filename)
        else:
            ERROR('Could not access file %s!' % (filename))

