#!/usr/bin/python26
###
### backmon.commands.mail.test
###

import sys
import os
import os.path
import glob
import re
import email
import StringIO
import io
import mimetypes
import socket

from optparse import OptionParser
from guppy import hpy

from email import encoders
from email.message import Message
from email.mime.audio import MIMEAudio
from email.mime.base import MIMEBase
from email.mime.image import MIMEImage
from email.mime.multipart import MIMEMultipart
from email.mime.text import MIMEText

from ....lib import *

from backup_monitoring.debug import *
from backup_monitoring.math import *

from backup_monitoring.parsing.parsers import bpstulist
from backup_monitoring.parsing.parsers import df
from backup_monitoring.parsing.parsers import dsu_ls_l
from backup_monitoring.parsing.parsers import nbstlutil
from backup_monitoring.parsing.parsers import nbdevquery
from backup_monitoring.parsing.parsers import bpdbjobs

usage = 'usage: %prog mail test'
parser = OptionParser(usage=usage)

def run(args, kwargs):

    #
    # add kwargs to local namespace
    #
    for key in kwargs.keys():

        if re.compile('^[A-Z][A-Z_]+$').match(key):
            exec(key + ' = kwargs[\'' + key + '\']')

    (options, args) = parser.parse_args(args)

    body = StringIO.StringIO()

    msg = MIMEMultipart('alternative')

    msg['To'] = TO
    msg['From'] = FROM
    msg['Subject'] = 'Test'

    text = 'This message requires an email client that understands HTML.'

    html = """
        <style type="text/css">

        h1
        {
            font-size:          12px;

        }

        table
        {
            table-layout:       auto;
            border:             1px solid #005AB0;
            font-family:        arial,sans-serif;
            font-size:          12px;
            font-weight:        normal;
        }


        </style>

        <html>
        <head></head>
        <body>
        <table width="480">
        <thead>
            <tr>
                <th colspan="3"><center><h1 align="center">Data Backup Central</h1></center></th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td>DABEX</td>
            </tr>
            <tr>
                <td>SQL-BU</td>
            </tr>
            <tr>
                <td>COSIBA</td>
            </tr>
        </tbody>
        <tfoot>
            <tr>
            </tr>
        </tfoot>
        </table>
        </body>
        </html>
    """

    msg.attach(MIMEText(text, 'plain'))
    msg.attach(MIMEText(html, 'html'))

    print msg
    
    msmtp = os.popen('/usr/bin/msmtp --read-envelope-from --read-recipients', 'w')
    msmtp.write(msg.as_string())
    msmtp.close()

