###
### IDCache - Cache for fast id lookups to an SQL table
###

from ...builtins import *
from ...parsing.autotype import *

class IDCache(object):

    def __init__(self, conn=None, cache=None, static=False, table=None, key_column=None, value_column=None, anchors=None, extras=None, initialize=True, init_append=None):

        self.conn = conn
        self.table = table
        self.key_column = key_column
        self.value_column = value_column
        self.anchors = anchors
        self.extras = extras

        if cache is None:
            self.cache = {}
        else:
            self.cache = cache

        self.static = static

        init_sql = "SELECT %s, %s FROM %s" % (key_column, value_column, table)
        anchor_sql = ""

        if anchors:

            i = 0

            for key, value in anchors.items():

                if i == 0:
                    init_sql = '%s WHERE ' % (init_sql)
                else:
                    init_sql = '%s AND ' % (init_sql)

                if type(value) in (int, float):
                    init_sql = "%s %s = %s" % (init_sql, key, value)
                    anchor_sql = "%s AND %s = %s" % (anchor_sql, key, value)
                else:
                    init_sql = "%s %s = '%s'" % (init_sql, key, value)
                    anchor_sql = "%s AND %s = '%s'" % (anchor_sql, key, value)

                i += 1

        if init_append:
            self.init_sql = '%s %s' % (init_sql, init_append)
        else:
            self.init_sql = '%s' % (init_sql)

        self.anchor_sql = anchor_sql

        if initialize:
            self.initialize()

    #
    # initilize the cache
    #
    def initialize(self):

        cache = self.cache
        key_column = self.key_column
        value_column = self.value_column
        table = self.table
        anchors = self.anchors
        curs = self.conn.cursor()

        sql = self.init_sql

        for row in curs.execute(sql):
            cache[row[key_column]] = row[value_column]

    #
    # flush the cache
    #
    def flush(self):
        self.cache = {}

    #
    # return a value
    #
    def __getitem__(self, key):

        cache = self.cache
        anchors = self.anchors
        anchor_sql = self.anchor_sql

        if key in cache.keys():
            return cache[key]
        elif not self.static:
            key_column = self.key_column
            value_column = self.value_column
            table = self.table
            curs = self.conn.cursor()
            sql = "SELECT %s FROM %s WHERE %s = '%s'%s" % (value_column, self.table, self.key_column, key, anchor_sql)
            curs.execute(sql)
            results = curs.fetchone()
            if results:
                value = results[0]
                cache[key] = value
                return value
            else:
                return None
        else:
            return None

    #
    # set a value
    #
    def __setitem__(self, key, value):

        cache = self.cache

        cache[key] = value

    #
    # delete a value
    #
    def __delitem__(self, key):

        cache = self.cache

        if cache.has_key(key):
            del cache[key]

    #
    #
    #
    def __contains__(self, item):

        cache = self.cache

        if cache.has_key(item):
            return True
        else:
            return False

    #
    #
    #
    def has_key(self, key):

        return key in self

    #
    #
    #
    def keys(self):

        cache = self.cache

        return cache.keys()

    #
    #
    #
    def __iter__(self):

        return iter(self.keys())

    #
    # actions to take when an IDCache is deleted
    #
    def __del__(self):

        cache = self.cache

        if hasattr(cache, 'close'):
            cache.close()

