import re

import time
import datetime
import pytz

from ....builtins import *

from ...exceptions import *
from ...expressions import *
from ...autotype import *
from ...streams import *

##
## bperror has records separated by blank lines
##
def stream(stream, format='bperror -L'):

    if format in ['bperror -L']:
        return BlankLineStream(stream, header=1)
    else:
        raise ParseError, 'Unknown format %s' % (format)


##
## Parse a bperror record
##
##     bperror -L
##
def parse(record, format='bperror -L', version=None, tz=None):

    re_line1 = re.compile('^(\d\d/\d\d/\d\d\d\d \d\d:\d\d:\d\d)\s+V(\S+)\s+S:(\S+)\s+C:(\S+)\s+J:(\S+)\s+\(U:(\S+),(\S+)\)$')
    re_line2 = re.compile('^  (\w+)\((\w+)\) (\w+)\((\w+)\) (\w+)$')

    strptime_format = '%m/%d/%Y %H:%M:%S'

    error = ExtendedDict()

    if format == 'bperror -L':

        try:

            line1 = record[0]

            match = re_line1.match(line1)

            Datetime            = datetime.datetime.strptime(match.group(1), strptime_format).replace(tzinfo=tz)
            nbu_version         = match.group(2)
            server              = match.group(3)
            client              = match.group(4)
            job_id              = int(match.group(5))
            job_group_id        = int(match.group(6))
            unused_field        = match.group(7)

            line2               = record[1]
            match               = re_line2.match(line2)
            severity_name       = match.group(1)
            severity_code       = int(match.group(2), 0)
            type_name           = match.group(3)
            type_code           = int(match.group(4), 0)
            who                 = match.group(5)

            error.datetime      = Datetime
            error.nbu_version   = nbu_version
            error.server        = server
            error.client        = client
            error.job_id        = job_id
            error.job_group_id  = job_group_id
            error.unused_field  = unused_field
            error.severity_name = severity_name
            error.severity_code = severity_code
            error.type_name     = type_name
            error.type_code     = type_code
            error.who           = who

            message = record[2][2:]

            for line in record[3:]:
                message = '%s%s' % (message, line[1:])

            error.message = message

            return error

        except Exception, e:

            for line in record:
                print line

            raise ParseError, e

    else:

        raise ParseError, 'Unknown format %s' % (format)
