#!/usr/bin/perl -w
# automatisches buildskript fuer smartclient
# liest die konfiguration aus der mit -b bergebenen Datei
# $Id: buildall.pl,v 1.16 2002/10/17 13:12:57 joergs Exp $
# Philipp Storz, SuSE Linux AG 
# pstorz@suse.de

use strict;
use Getopt::Std;
use File::stat;
use File::Basename;

my $wert1;
my $wert2;
my $wert3;

format TABELLE =
@<<<<<<<<<<<<<<<<<<<<<<<<<< @<<<<<<<<<<<<<<<<<< @<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
$wert1, $wert2, $wert3
.


# Programmoptionen: 
#	-b (buildlist) 
#	-x (buildlog im seperaten xtern

my $workdir=`pwd`;
chomp $workdir;

my $smartclient_root="../../";   # Pfad, zu dem die Pfade in buildlist stehen
my $build = "build.sh";
our ($opt_b, $opt_x);
my @ArrayofBuilds;
getopts('b:x');


if (!$opt_b)
{
$opt_b = "buildlist";
print "using default buildlist: buildlist\n\n";
print "other buildlist can be specified with -b buildlist\n\n";
};

(open(BUILDLIST,$opt_b)) || die "Die Buildlist $opt_b  konnte nicht gefunden werden";


while (<BUILDLIST>) #Buildlist parsen
  {
  	my $dir;
	my $arch;
	my $opt;
    next if (/^\#.*$/);
	# if (/([\w\/]+)\s*:([\/\w\-\+\.]+)\s+:((\s*\-\-\w*)*)$/)
    if (/(\S+)\s*:(\S+)\s*:(\S+)\s*$/)
      {
	($dir, $arch, $opt) = ($1, $2, $3);
	chomp ($arch);
	my @build=($dir, $arch, $opt);
	push @ArrayofBuilds, [@build];
      }
  }



print "What will be done:\n\n";
($wert1,$wert2,$wert3)= ("Path","Distribuition","Buildoptions");
$~="TABELLE";
write;
print "\n";
for my $i (0 .. $#ArrayofBuilds)
  {
    ($wert1,$wert2,$wert3)= ($ArrayofBuilds[$i][0],$ArrayofBuilds[$i][1],$ArrayofBuilds[$i][2]);
    $~="TABELLE";
    write;
  }

print 'Are all the srpms extracted and all options OK? (y/n)';

my $answer=<STDIN>;
chomp ($answer);
if ($answer ne "y") {die("canceled")};

my $mypath;
for my $i (0 .. $#ArrayofBuilds)
  {
  print("$ArrayofBuilds[$i][0]\t\t$ArrayofBuilds[$i][1]\t\t$ArrayofBuilds[$i][2]\n");
  $mypath = $smartclient_root.$ArrayofBuilds[$i][0];

  if ($ArrayofBuilds[$i][2])
    {
      $ENV{'BUILD_MODE'}=$ArrayofBuilds[$i][2];
    }
  else 
    {
      $ENV{'BUILD_MODE'}="--clean";
    }
  $ENV{'BUILD_DIST'}=$ArrayofBuilds[$i][1];

  
  $_=$ArrayofBuilds[$i][0];
  print "$_ \n";
  tr/\//\_/;
  my $logfilename = "$workdir/$mypath/$_.$ArrayofBuilds[$i][1].log";

  my $build_cmd="cd $mypath && $build";

  # open a xterm to display build output
  if ($opt_x)
  {
    system "xterm -T \"build log for PACKET: $mypath    ARCH:$ArrayofBuilds[$i][1] \" -e less +F $logfilename &";
    print "++++++++++++++++++++++++++++++++++++++++++\n";
  }

  # if mypath is not a directory, so it is a src.rpm (hopefully)
  if( ! -d $mypath ) {
    my $base 	= basename($mypath);
    my $dir  	= dirname($mypath);
	$build_cmd	= "cd $dir && $build $base-[0-9]*rpm";
  }

  print "++++++++++++++++++++++++++++++++++++++++++\n";
  print "BUILD_DIST ist $ENV{'BUILD_DIST'}\n";
  print "BUILD_MODE ist $ENV{'BUILD_MODE'}\n";
  print "executing build command:\n";
  print "$build_cmd\n";
  print "you can watch building with following command: \n";
  print "less +F $logfilename\n\n";

  open( LOG_FD, ">$logfilename" );
  open( PIPE, "$build_cmd 2>&1 |" );
  while( <PIPE> ) {
  	if( ! $opt_x ) {
  	  print;
	}
	print LOG_FD;
  }
  close PIPE; my $retval=$?;
  close LOG_FD;
  
  if ( $retval == 0 )
   {
     $ArrayofBuilds[$i][3]= "SUCCESS $ArrayofBuilds[$i][0]: OK";
     print"******                                                      ******\n";
     print"******   building of $ArrayofBuilds[$i][0]: OK                    \n" ;
     print"******                                                      ******\n";
   }
  else
   {
     $ArrayofBuilds[$i][3]="ERROR  $ArrayofBuilds[$i][0]: *FAILED*\n";
     print"******                                                      ******\n";
     print"\n\n\nERROR: building of $ArrayofBuilds[$i][0]: *FAILED*\n";
     print"******                                                      ******\n";
   }
}

print "Building results:\n";



($wert1,$wert2,$wert3)= ("Path","Distribuition","Result");
$~="TABELLE";
write;
print "\n";

for my $i (0 .. $#ArrayofBuilds)
  {
    ($wert1,$wert2,$wert3)= ($ArrayofBuilds[$i][0],$ArrayofBuilds[$i][1],$ArrayofBuilds[$i][3]);
    $~="TABELLE";
    write;
	# print("$ArrayofBuilds[$i][0]:Result: $ArrayofBuilds[$i][3]");
  }

print "buildall.pl terminated\n";
