#!/usr/bin/perl -w
# automatisches buildskript fuer smartclient
# liest die konfiguration aus der mit -b bergebenen Datei
# $Id: buildall.pl,v 1.10 2002/09/18 12:36:56 ahuck Exp $
# Philipp Storz, SuSE Linux AG 
# pstorz@suse.de
use Getopt::Std;


format TABELLE =
@<<<<<<<<<<<<<<<<<<<<<<<<<< @<<<<<<<<<<<<<<<<<< @<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
$wert1, $wert2, $wert3
.


# Programmoptionen: -b (buildlist) 

my $smartclient_root="../../";   # Pfad, zu dem die Pfade in buildlist stehen
my $build = "build.sh";
our ($opt_b);
my @ArrayofBuilds;
getopts('b:');


if (!$opt_b)
{
$opt_b = "buildlist";
print "using default buildlist: buildlist\n\n";
print "other buildlist can be specified with -b buildlist\n\n";
};

(open(BUILDLIST,$opt_b)) || die "Die Buildlist $opt_b  konnte nicht gefunden werden";


while (<BUILDLIST>) #Buildlist parsen
  {
    next if (/^\#.*$/);
#    if (/([\w\/]+)\s*:([\/\w\-\+\.]+)\s+:((\s*\-\-\w*)*)$/)
    if (/(\S+)\s*:(\S+)\s*:(\S+)\s*$/)
      {
	($dir, $arch, $opt) = ($1, $2, $3);
	chomp ($arch);
	@build=($dir, $arch, $opt);
	push @ArrayofBuilds, [@build];
      }
  }



print "What will be done:\n\n";
($wert1,$wert2,$wert3)= ("Path","Distribuition","Buildoptions");
$~="TABELLE";
write;
print "\n";
for $i (0 .. $#ArrayofBuilds)
  {
    ($wert1,$wert2,$wert3)= ($ArrayofBuilds[$i][0],$ArrayofBuilds[$i][1],$ArrayofBuilds[$i][2]);
    $~="TABELLE";
    write;
  }
print "\n\n\n ATTENTION: the srpms from the directory external/SuSE and external/cpan must have been extracted before!\n";
print "To build srpms execute the extract_srpms.sh script in either directory!\n\n\n";
print 'Are all the srpms extracted and all options OK? (y/n)';

$answer =<STDIN>;
chomp ($answer);
if ($answer ne "y") {die("canceled")};

for $i (0 .. $#ArrayofBuilds)
  {
  print("$ArrayofBuilds[$i][0]\t\t$ArrayofBuilds[$i][1]\t\t$ArrayofBuilds[$i][2]\n");
  $mypath = $smartclient_root.$ArrayofBuilds[$i][0];

  if ($ArrayofBuilds[$i][2])
    {
      $ENV{'BUILD_MODE'}=$ArrayofBuilds[$i][2];
    }
  else 
    {
      $ENV{'BUILD_MODE'}="--clean";
    }
  $ENV{'BUILD_DIST'}=$ArrayofBuilds[$i][1];

  
#  system "./test.sh";
  $_=$ArrayofBuilds[$i][0];
  print "$_ \n";
  tr/\//\_/;
  $logfilename = $_.".$ArrayofBuilds[$i][1].log";
  print "++++++++++++++++++++++++++++++++++++++++++\n";
  print "executing command: cd $mypath; $build 2>&1 > $logfilename\n";
  print "BUILD_DIST ist $ENV{'BUILD_DIST'}\n";
  print "BUILD_MODE ist $ENV{'BUILD_MODE'}\n";
  
  print "writing logfile to $logfilename \n\n\n";
  print "you can watch building with following command: \n";
  $workdir=`pwd`;
  chomp $workdir;
  print "less +F $workdir/$mypath/$logfilename\n";


if ($opt_x)
  {
  system "xterm -T \"build log for PACKET: $mypath    ARCH:$ArrayofBuilds[$i][1] \" -e less +F $workdir/$mypath/$logfilename &";
  print "++++++++++++++++++++++++++++++++++++++++++\n";
  $retval = system "cd $mypath; $build >$logfilename 2>&1;";
  }
  else
  {
    $retval = system "cd $mypath; $build |tee $logfilename";
  }



#  system "xterm -T \"build log for PACKET: $mypath    ARCH:$ArrayofBuilds[$i][1] \" -e less +F $workdir/$mypath/$logfilename &";
#  print "++++++++++++++++++++++++++++++++++++++++++\n";
#  $retval = system "cd $mypath; $build >$logfilename 2>&1;";
# $retval = system "./exit.sh 2>&1 > $logfilename;";


 if ($retval == 0)
   {
     $ArrayofBuilds[$i][3]= "SUCESS $ArrayofBuilds[$i][0]: OK";
     print"******                                                      ******\n";
     print"******   building of $ArrayofBuilds[$i][0]: OK                    \n" ;
     print"******                                                      ******\n";
   }
 else
   {
     $ArrayofBuilds[$i][3]="ERROR  $ArrayofBuilds[$i][0]: *FAILED*\n";
     print"******                                                      ******\n";
     print"\n\n\nERROR: building of $ArrayofBuilds[$i][0]: *FAILED*\n";
     print"******                                                      ******\n";
   }

}

print "Building results:\n";



($wert1,$wert2,$wert3)= ("Path","Distribuition","Result");
$~="TABELLE";
write;
print "\n";

for $i (0 .. $#ArrayofBuilds)
  {
    ($wert1,$wert2,$wert3)= ($ArrayofBuilds[$i][0],$ArrayofBuilds[$i][1],$ArrayofBuilds[$i][3]);
    $~="TABELLE";
    write;
#    print("$ArrayofBuilds[$i][0]:Result: $ArrayofBuilds[$i][3]");
  }




print "buildall.pl terminated\n";




