#!/bin/sh
# $Id: $
# dass IT GmbH
#
# This script reads some information out of rpm packages and generates Suse patch files, signs and
# checks signature of package and finally puts patch descriptions and rpms onto the you server
#
# Parameter: binary rpm file
# TODO: Make patches consisting of more than one rpm, proceed some more rpm attributes into patch file

## customize THIS:

YOUSERVER=lxcdtower
YOUPATH=/cds/linux/i386/update/lvermgeo

##

function out()
{
echo $1 >> $PATCHFILE
#echo -e "\n" >> $PATCHFILE
}

# Name of patch-description file
PATCHFILE="$DESCRDIR/patch-$PAKET-$SUFFIX"

DESCRDIR=/usr/src/packages/PATCH/

PAKET=`rpm --queryformat %{NAME} -qp $1`
SUFFIX=`rpm --queryformat %{VERSION}-%{RELEASE} -qp $1`
SUMMARY=`rpm --queryformat %{SUMMARY} -qp $1`
DESCRIPTION=`rpm --queryformat %{DESCRIPTION} -qp $1`
ARCH=`rpm --queryformat %{ARCH} -qp $1`
GROUP=`rpm --queryformat %{GROUP} -qp $1`
SIZE=`rpm --queryformat %{SIZE} -qp $1`

RELEASE=`date +%Y%m%d%H%M`

RPMFILEBASENAME=`basename $1`

if [ -e $PATCHFILE ]
then
	rm $PATCHFILE
fi
out "##"
out "## Patch Description for $PAKET"
out "##"
out
out "Kind: recommended" 
out "Shortdescription.english: $SUMMARY"
out "Longdescription.english:" 
out "$DESCRIPTION"
out " "
out "Hsilgne.noitpircsedgnol:"
out "UpdateOnlyInstalled: false"
out "Size: $SIZE"
out "MinYaST1Version:"
out "MinYaST2Version:"
out
out "Packages:"
out "##"
out "Filename: $PAKET.rpm"
out "Label: $PAKET"
out "Series: $ARCH"
out "DepAND:"
out "DepOR:"
out "DepExcl:"
out "Flag:"
out "Category:"
out "RpmGroup: $GROUP"
out "Copyright: see package"
out "AuthorAddress:"
out "Version: $SUFFIX"
out "StartCommand:"
out "Obsoletes:"
out "Segakcap:"


gpg --clearsign $PATCHFILE

mv $PATCHFILE.asc $PATCHFILE

if (rpm --checksig $1 | grep -q "gpg OK") 
then
  # publish
  echo "Kopiere Dateien ..."
  scp $PATCHFILE $YOUSERVER:$YOUPATH/patches
  ssh $YOUSERVER "cd $YOUPATH/patches; ls -1 -A > directory.3"
  scp $1 $YOUSERVER:$YOUPATH/rpm/$ARCH/
  ssh $YOUSERVER "cd $YOUPATH/rpm/$ARCH/; ln -sf $RPMFILEBASENAME $PAKET.rpm; ls -1 -A > directory.3"
else
  echo "rpm Signature _not_ Ok. stop"
  exit 1
fi	





