#!/usr/bin/perl -w
# automatisches buildskript fuer smartclient
# liest die konfiguration aus der mit -b bergebenen Datei
# $Id: buildall.pl,v 1.4 2002/09/04 14:43:59 pstorz Exp $
use Getopt::Std;

# Programmoptionen: -b (buildlist) 

my $smartclient_root="../../";   # Pfad, zu dem die Pfade in buildlist stehen
my $build = "build.sh";
our ($opt_b);
my @ArrayofBuilds;
getopts('b:');

if (!$opt_b)
{die "usage: buildall.pl -b buildlist\n";
};

(open(BUILDLIST,$opt_b)) || die "Die Buildlist $opt_b  konnte nicht gefunden werden";


while (<BUILDLIST>) #Buildlist parsen
  {
    next if (/^\#.*$/);
#    if (/([\w\/]+)\s*:([\/\w\-\+\.]+)\s+:((\s*\-\-\w*)*)$/)
    if (/(\S+)\s*:(\S+)\s*:(\S+)\s*$/)
      {
	($dir, $arch, $opt) = ($1, $2, $3);
	chomp ($arch);
	@build=($dir, $arch, $opt);
	push @ArrayofBuilds, [@build];
      }
  }



print "What will be done:\n";
print "Path\tDistribution\tBuildoptions\n";
for $i (0 .. $#ArrayofBuilds)
  {
    print("$ArrayofBuilds[$i][0]\t\t$ArrayofBuilds[$i][1]\t\t$ArrayofBuilds[$i][2]\n");
  }
print "\n\n\n ATTENTION: the srpms from the directory external/SuSE  must be built before!\n";
print "to build srpms, goto dir external/SuSE, execute build_srpms.sh script!\n\n\n";
print 'Are the srpms built and all options OK? (y/n)';

$answer =<STDIN>;
chomp ($answer);
if ($answer ne "y") {die("canceled")};

for $i (0 .. $#ArrayofBuilds)
  {
  print("$ArrayofBuilds[$i][0]\t\t$ArrayofBuilds[$i][1]\t\t$ArrayofBuilds[$i][2]\n");
  $mypath = $smartclient_root.$ArrayofBuilds[$i][0];

  if ($ArrayofBuilds[$i][2])
    {
      $ENV{'BUILD_MODE'}=$ArrayofBuilds[$i][2];
    }
  else 
    {
      $ENV{'BUILD_MODE'}="--clean";
    }
  $ENV{'BUILD_DIST'}=$ArrayofBuilds[$i][1];

  
#  system "./test.sh";
  $_=$ArrayofBuilds[$i][0];
  print "$_ \n";
  tr/\//\_/;
  $logfilename = $_.".$ArrayofBuilds[$i][1].log";
  print "++++++++++++++++++++++++++++++++++++++++++\n";
  print "executing command: cd $mypath; $build 2>&1 > $logfilename\n";
  print "BUILD_DIST ist $ENV{'BUILD_DIST'}\n";
  print "BUILD_MODE ist $ENV{'BUILD_MODE'}\n";
  
  print "writing logfile to $logfilename \n\n\n";
  print "you can watch building with following command: \n";
  $workdir=`pwd`;
  chomp $workdir;
  print "less +F $workdir/$mypath/$logfilename\n";
  system "xterm -T \"build log for PACKET: $mypath    ARCH:$ArrayofBuilds[$i][1] \" -e less +F $workdir/$mypath/$logfilename &";
  print "++++++++++++++++++++++++++++++++++++++++++\n";
  $retval = system "cd $mypath; $build >$logfilename 2>&1;";
# $retval = system "./exit.sh 2>&1 > $logfilename;";


 if ($retval == 0)
   {
     $ArrayofBuilds[$i][3]= "building of $ArrayofBuilds[$i][0] SUCCESSFULL:";
     print"******                                                      ******\n";
     print"******   building of $ArrayofBuilds[$i][0] SUCCESSFULL:     \n" ;
     print"******                                                      ******\n";
   }
 else
   {
     $ArrayofBuilds[$i][3]="ERROR: building of $ArrayofBuilds[$i][0] UNSUCCESSDULL:\n";
     print"******                                                      ******\n";
     print"\n\n\nERROR: building of $ArrayofBuilds[$i][0] UNSUCCESSFULL \n";
     print"******                                                      ******\n";
   }

}

print "Building results:\n";

for $i (0 .. $#ArrayofBuilds)
  {
    print("$ArrayofBuilds[$i][0]:Result: $ArrayofBuilds[$i][3]");
  }




print "buildall.pl terminated\n";



