/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.databinding.utils.writer;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.activation.DataHandler;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axis2.databinding.utils.writer.OMStreamNamespaceContext;

public class OMElementStreamWriter
implements XMLStreamWriter {
    private OMElement rootElement;
    private OMFactory omFactory = OMAbstractFactory.getOMFactory();
    private OMElement currentOMElement = null;
    private Stack omElementStack = new Stack();
    private Map namespaceOMNamesapceMap;
    private int prefixNum = 0;
    private OMStreamNamespaceContext omStreamNamespaceContext = new OMStreamNamespaceContext();

    public OMElementStreamWriter() {
        this.namespaceOMNamesapceMap = new HashMap();
    }

    public OMElement getOMElement() throws XMLStreamException {
        if (!this.omElementStack.isEmpty()) {
            throw new XMLStreamException("This is an invalid Xml ");
        }
        return this.rootElement;
    }

    private OMNamespace getOMNamespace(String namespace, String prefix) throws XMLStreamException {
        OMNamespace omNamespace = null;
        if (namespace != null) {
            if (this.namespaceOMNamesapceMap.containsKey(namespace)) {
                omNamespace = (OMNamespace)this.namespaceOMNamesapceMap.get(namespace);
            } else {
                if (prefix == null) {
                    prefix = "ns" + ++this.prefixNum;
                } else if (this.omStreamNamespaceContext.getNamespaceURI(prefix) != null) {
                    throw new XMLStreamException("the prefix ==> " + prefix + " Already exists for namespace ==> " + namespace);
                }
                omNamespace = this.omFactory.createOMNamespace(namespace, prefix);
                this.omStreamNamespaceContext.registerNamespace(namespace, prefix);
                this.namespaceOMNamesapceMap.put(namespace, omNamespace);
            }
        }
        return omNamespace;
    }

    public void writeStartElement(String localName) throws XMLStreamException {
        this.writeStartElement(null, localName, null);
    }

    public void writeStartElement(String namespace, String localName) throws XMLStreamException {
        this.writeStartElement(null, localName, namespace);
    }

    public void writeStartElement(String prefix, String localName, String namespace) throws XMLStreamException {
        OMNamespace omNamespace = this.getOMNamespace(namespace, prefix);
        this.currentOMElement = this.omFactory.createOMElement(localName, omNamespace);
        if (!this.omElementStack.isEmpty()) {
            OMElement parent = (OMElement)this.omElementStack.peek();
            parent.addChild((OMNode)this.currentOMElement);
        } else {
            this.rootElement = this.currentOMElement;
        }
        this.omElementStack.push(this.currentOMElement);
    }

    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.writeEmptyElement(null, localName, namespaceURI);
    }

    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.writeStartElement(prefix, localName, namespaceURI);
        this.writeEndElement();
    }

    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.writeEmptyElement(null, localName, null);
    }

    public void writeEndElement() throws XMLStreamException {
        this.omElementStack.pop();
    }

    public void writeEndDocument() throws XMLStreamException {
    }

    public void close() throws XMLStreamException {
    }

    public void flush() throws XMLStreamException {
    }

    public void setDataHandler(DataHandler dataHandler) {
        OMText omText = this.omFactory.createOMText((Object)dataHandler, true);
        this.currentOMElement.addChild((OMNode)omText);
    }

    public void writeAttribute(String attributeName, String attributeValue) throws XMLStreamException {
        this.writeAttribute(null, null, attributeName, attributeValue);
    }

    public void writeAttribute(String prefix, String namespace, String attributeName, String attributeValue) throws XMLStreamException {
        this.currentOMElement.addAttribute(attributeName, attributeValue, this.getOMNamespace(namespace, prefix));
    }

    public void writeAttribute(String namespace, String attributeName, String attributeValue) throws XMLStreamException {
        this.writeAttribute(null, namespace, attributeName, attributeValue);
    }

    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        if (namespaceURI != null) {
            OMNamespace omNamespace = this.getOMNamespace(namespaceURI, prefix);
            this.currentOMElement.declareNamespace(omNamespace);
        }
    }

    public void writeDefaultNamespace(String namespace) throws XMLStreamException {
        this.rootElement.declareDefaultNamespace(namespace);
        this.getOMNamespace(namespace, "");
    }

    public void writeComment(String string) throws XMLStreamException {
        this.omFactory.createOMComment((OMContainer)this.currentOMElement, string);
    }

    public void writeProcessingInstruction(String string) throws XMLStreamException {
        throw new UnsupportedOperationException("this method has not yet been implemented");
    }

    public void writeProcessingInstruction(String string, String string1) throws XMLStreamException {
        throw new UnsupportedOperationException("this method has not yet been implemented");
    }

    public void writeCData(String string) throws XMLStreamException {
        throw new UnsupportedOperationException("this method has not yet been implemented");
    }

    public void writeDTD(String string) throws XMLStreamException {
        throw new UnsupportedOperationException("this method has not yet been implemented");
    }

    public void writeEntityRef(String string) throws XMLStreamException {
        throw new UnsupportedOperationException("this method has not yet been implemented");
    }

    public void writeStartDocument() throws XMLStreamException {
    }

    public void writeStartDocument(String string) throws XMLStreamException {
    }

    public void writeStartDocument(String string, String string1) throws XMLStreamException {
    }

    public void writeCharacters(String string) throws XMLStreamException {
        this.currentOMElement.setText(string);
    }

    public void writeCharacters(char[] chars, int i, int i1) throws XMLStreamException {
        this.writeCharacters(new String(chars, i, i1));
    }

    public String getPrefix(String namespace) throws XMLStreamException {
        return this.omStreamNamespaceContext.getPrefix(namespace);
    }

    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        this.getOMNamespace(uri, prefix);
    }

    public void setDefaultNamespace(String namespace) throws XMLStreamException {
        this.rootElement.declareDefaultNamespace(namespace);
        this.getOMNamespace(namespace, "");
    }

    public void setNamespaceContext(NamespaceContext namespaceContext) throws XMLStreamException {
        throw new UnsupportedOperationException("this method has not yet been implemented");
    }

    public NamespaceContext getNamespaceContext() {
        return this.omStreamNamespaceContext;
    }

    public Object getProperty(String string) throws IllegalArgumentException {
        throw new UnsupportedOperationException("this method has not yet been implemented");
    }
}

