/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.description.builder.converter;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jws.WebService;
import javax.xml.ws.BindingType;
import javax.xml.ws.ServiceMode;
import javax.xml.ws.WebFault;
import javax.xml.ws.WebServiceClient;
import javax.xml.ws.WebServiceProvider;
import javax.xml.ws.WebServiceRef;
import javax.xml.ws.WebServiceRefs;
import javax.xml.ws.spi.WebServiceFeatureAnnotation;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.description.builder.BindingTypeAnnot;
import org.apache.axis2.jaxws.description.builder.DescriptionBuilderComposite;
import org.apache.axis2.jaxws.description.builder.FieldDescriptionComposite;
import org.apache.axis2.jaxws.description.builder.MethodDescriptionComposite;
import org.apache.axis2.jaxws.description.builder.ServiceModeAnnot;
import org.apache.axis2.jaxws.description.builder.WebFaultAnnot;
import org.apache.axis2.jaxws.description.builder.WebServiceAnnot;
import org.apache.axis2.jaxws.description.builder.WebServiceProviderAnnot;
import org.apache.axis2.jaxws.description.builder.WebServiceRefAnnot;
import org.apache.axis2.jaxws.description.builder.converter.ConverterUtils;
import org.apache.axis2.jaxws.description.builder.converter.JavaFieldsToFDCConverter;
import org.apache.axis2.jaxws.description.builder.converter.JavaMethodsToMDCConverter;
import org.apache.axis2.jaxws.util.ClassLoaderUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaClassToDBCConverter {
    private static final Log log = LogFactory.getLog(JavaClassToDBCConverter.class);
    private Class serviceClass;
    private String seiClassName;
    private List<Class> classes;
    private static final Map<Class, Object> annotationProcessors = new HashMap<Class, Object>();

    public JavaClassToDBCConverter(Class serviceClass) {
        this.serviceClass = serviceClass;
        this.classes = new ArrayList<Class>();
        this.establishClassHierarchy(serviceClass);
        this.establishInterfaceHierarchy(serviceClass.getInterfaces());
        this.establishExceptionClasses(serviceClass);
    }

    public HashMap<String, DescriptionBuilderComposite> produceDBC() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating DescriptionBuilderComposite map from Java Class.");
        }
        HashMap<String, DescriptionBuilderComposite> dbcMap = new HashMap<String, DescriptionBuilderComposite>();
        for (int i = 0; i < this.classes.size(); ++i) {
            this.buildDBC(dbcMap, this.classes.get(i));
            if (this.seiClassName == null || this.seiClassName.equals("")) continue;
            try {
                final ClassLoader contextClassLoader = (ClassLoader)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                    public Object run() {
                        return Thread.currentThread().getContextClassLoader();
                    }
                });
                Class seiClass = null;
                try {
                    seiClass = (Class)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                        public Object run() throws ClassNotFoundException {
                            return contextClassLoader.loadClass(JavaClassToDBCConverter.this.seiClassName);
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw (ClassNotFoundException)e.getException();
                }
                this.buildDBC(dbcMap, seiClass);
                Class<?>[] interfaces = seiClass.getInterfaces();
                for (int j = 0; j < interfaces.length; ++j) {
                    this.buildDBC(dbcMap, interfaces[i]);
                }
                continue;
            }
            catch (ClassNotFoundException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Class not found exception caught for class: " + this.seiClassName), (Throwable)e);
            }
        }
        return dbcMap;
    }

    private void buildDBC(HashMap<String, DescriptionBuilderComposite> dbcMap, Class clazz) {
        this.serviceClass = clazz;
        DescriptionBuilderComposite composite = new DescriptionBuilderComposite();
        this.introspectClass(composite);
        dbcMap.put(composite.getClassName(), composite);
    }

    private void introspectClass(DescriptionBuilderComposite composite) {
        composite.setClassLoader(ClassLoaderUtils.getClassLoader(this.serviceClass));
        composite.setIsInterface(this.serviceClass.isInterface());
        composite.setSuperClassName(this.serviceClass.getSuperclass() != null ? this.serviceClass.getSuperclass().getName() : null);
        composite.setClassName(this.serviceClass.getName());
        this.setInterfaces(composite);
        this.setTypeTargettedAnnotations(composite);
        Field[] fields = (Field[])AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                return JavaClassToDBCConverter.this.serviceClass.getFields();
            }
        });
        if (fields.length > 0) {
            JavaFieldsToFDCConverter fieldConverter = new JavaFieldsToFDCConverter(fields);
            List<FieldDescriptionComposite> fdcList = fieldConverter.convertFields();
            ConverterUtils.attachFieldDescriptionComposites(composite, fdcList);
        }
        if (this.serviceClass.getMethods().length > 0) {
            Method[] methods = (Method[])AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    return JavaClassToDBCConverter.this.serviceClass.getDeclaredMethods();
                }
            });
            Constructor[] declaredConstructors = (Constructor[])AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    return JavaClassToDBCConverter.this.serviceClass.getDeclaredConstructors();
                }
            });
            JavaMethodsToMDCConverter methodConverter = new JavaMethodsToMDCConverter(methods, declaredConstructors, this.serviceClass.getName());
            List<MethodDescriptionComposite> mdcList = methodConverter.convertMethods();
            ConverterUtils.attachMethodDescriptionComposites(composite, mdcList);
        }
    }

    private void setInterfaces(DescriptionBuilderComposite composite) {
        Type[] interfaces = (Type[])AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                return JavaClassToDBCConverter.this.serviceClass.getGenericInterfaces();
            }
        });
        ArrayList<String> interfaceList = interfaces.length > 0 ? new ArrayList<String>() : null;
        for (int i = 0; i < interfaces.length; ++i) {
            interfaceList.add(this.getNameFromType(interfaces[i]));
        }
        if (interfaceList != null) {
            composite.setInterfacesList(interfaceList);
        }
    }

    private String getNameFromType(Type type) {
        String returnName = null;
        if (type instanceof Class) {
            returnName = ((Class)type).getName();
        } else if (type instanceof ParameterizedType) {
            returnName = ((ParameterizedType)type).toString();
        }
        return returnName;
    }

    private void setTypeTargettedAnnotations(DescriptionBuilderComposite composite) {
        this.attachBindingTypeAnnotation(composite);
        this.attachHandlerChainAnnotation(composite);
        this.attachServiceModeAnnotation(composite);
        this.attachSoapBindingAnnotation(composite);
        this.attachWebFaultAnnotation(composite);
        this.attachWebServiceAnnotation(composite);
        this.attachWebServiceClientAnnotation(composite);
        this.attachWebServiceProviderAnnotation(composite);
        this.attachWebServiceRefsAnnotation(composite);
        this.attachWebServiceRefAnnotation(composite);
        this.attachWebServiceFeatureAnnotations(composite);
    }

    private void attachWebServiceAnnotation(DescriptionBuilderComposite composite) {
        WebService webService = (WebService)ConverterUtils.getAnnotation(WebService.class, this.serviceClass);
        if (webService != null) {
            WebServiceAnnot wsAnnot = WebServiceAnnot.createWebServiceAnnotImpl();
            wsAnnot.setEndpointInterface(webService.endpointInterface());
            this.seiClassName = webService.endpointInterface();
            wsAnnot.setName(webService.name());
            wsAnnot.setPortName(webService.portName());
            wsAnnot.setServiceName(webService.serviceName());
            wsAnnot.setTargetNamespace(webService.targetNamespace());
            wsAnnot.setWsdlLocation(webService.wsdlLocation());
            composite.setWebServiceAnnot(wsAnnot);
        }
    }

    private void attachWebServiceClientAnnotation(DescriptionBuilderComposite composite) {
        WebServiceClient webServiceClient = (WebServiceClient)ConverterUtils.getAnnotation(WebServiceClient.class, this.serviceClass);
        if (webServiceClient != null) {
            // empty if block
        }
    }

    private void attachWebServiceProviderAnnotation(DescriptionBuilderComposite composite) {
        WebServiceProvider webServiceProvider = (WebServiceProvider)ConverterUtils.getAnnotation(WebServiceProvider.class, this.serviceClass);
        if (webServiceProvider != null) {
            WebServiceProviderAnnot wspAnnot = WebServiceProviderAnnot.createWebServiceAnnotImpl();
            wspAnnot.setPortName(webServiceProvider.portName());
            wspAnnot.setServiceName(webServiceProvider.serviceName());
            wspAnnot.setTargetNamespace(webServiceProvider.targetNamespace());
            wspAnnot.setWsdlLocation(webServiceProvider.wsdlLocation());
            composite.setWebServiceProviderAnnot(wspAnnot);
        }
    }

    private void attachBindingTypeAnnotation(DescriptionBuilderComposite composite) {
        BindingType bindingType = (BindingType)ConverterUtils.getAnnotation(BindingType.class, this.serviceClass);
        if (bindingType != null) {
            BindingTypeAnnot btAnnot = BindingTypeAnnot.createBindingTypeAnnotImpl();
            btAnnot.setValue(bindingType.value());
            composite.setBindingTypeAnnot(btAnnot);
        }
    }

    private void attachHandlerChainAnnotation(DescriptionBuilderComposite composite) {
        ConverterUtils.attachHandlerChainAnnotation(composite, this.serviceClass);
    }

    private void attachServiceModeAnnotation(DescriptionBuilderComposite composite) {
        ServiceMode serviceMode = (ServiceMode)ConverterUtils.getAnnotation(ServiceMode.class, this.serviceClass);
        if (serviceMode != null) {
            ServiceModeAnnot smAnnot = ServiceModeAnnot.createWebServiceAnnotImpl();
            smAnnot.setValue(serviceMode.value());
            composite.setServiceModeAnnot(smAnnot);
        }
    }

    private void attachSoapBindingAnnotation(DescriptionBuilderComposite composite) {
        ConverterUtils.attachSoapBindingAnnotation(composite, this.serviceClass);
    }

    private void attachWebFaultAnnotation(DescriptionBuilderComposite composite) {
        WebFault webFault = (WebFault)ConverterUtils.getAnnotation(WebFault.class, this.serviceClass);
        if (webFault != null) {
            WebFaultAnnot webFaultAnnot = WebFaultAnnot.createWebFaultAnnotImpl();
            webFaultAnnot.setFaultBean(webFault.faultBean());
            webFaultAnnot.setName(webFault.name());
            webFaultAnnot.setTargetNamespace(webFault.targetNamespace());
            composite.setWebFaultAnnot(webFaultAnnot);
        }
    }

    private void attachWebServiceRefsAnnotation(DescriptionBuilderComposite composite) {
        WebServiceRefs webServiceRefs = (WebServiceRefs)ConverterUtils.getAnnotation(WebServiceRefs.class, this.serviceClass);
        if (webServiceRefs != null) {
            WebServiceRef[] refs;
            for (WebServiceRef ref : refs = webServiceRefs.value()) {
                WebServiceRefAnnot wsrAnnot = ConverterUtils.createWebServiceRefAnnot(ref);
                composite.setWebServiceRefAnnot(wsrAnnot);
            }
        }
    }

    private void attachWebServiceRefAnnotation(DescriptionBuilderComposite composite) {
        ConverterUtils.attachWebServiceRefAnnotation(composite, this.serviceClass);
    }

    private void attachWebServiceFeatureAnnotations(DescriptionBuilderComposite composite) {
        List<Annotation> features = ConverterUtils.getAnnotations(WebServiceFeatureAnnotation.class, this.serviceClass);
        if (features.size() > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("There were [" + features.size() + "] WebServiceFeature annotations found."));
            }
            composite.setWebServiceFeatures(features);
        }
    }

    private void establishClassHierarchy(Class rootClass) {
        this.classes.add(rootClass);
        if (rootClass.getSuperclass() != null && !rootClass.getSuperclass().getName().equals("java.lang.Object")) {
            this.classes.add(rootClass.getSuperclass());
            this.establishInterfaceHierarchy(rootClass.getSuperclass().getInterfaces());
            this.establishClassHierarchy(rootClass.getSuperclass());
        }
    }

    private void establishInterfaceHierarchy(Class[] interfaces) {
        if (interfaces.length > 0) {
            for (Class inter : interfaces) {
                this.classes.add(inter);
                this.establishInterfaceHierarchy(inter.getInterfaces());
            }
        }
    }

    private void establishExceptionClasses(final Class rootClass) {
        Method[] methods;
        for (Method method : methods = (Method[])AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                return rootClass.getMethods();
            }
        })) {
            Class<?>[] exceptionClasses = method.getExceptionTypes();
            if (exceptionClasses.length <= 0) continue;
            for (Class<?> checkedException : exceptionClasses) {
                this.classes.add(checkedException);
            }
        }
    }
}

