/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import antlr.collections.AST;
import de.hunsicker.jalopy.language.antlr.JavaNode;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.printer.PrinterFactory;
import java.io.IOException;

class BasicPrinter
extends AbstractPrinter {
    private static final Printer INSTANCE = new BasicPrinter();

    protected BasicPrinter() {
    }

    public static Printer getInstance() {
        return INSTANCE;
    }

    public void print(AST node, NodeWriter out) throws IOException {
        this.printCommentsBefore(node, false, out);
        int offset = out.print(node.getText(), node.getType());
        AST child = node.getFirstChild();
        while (child != null) {
            PrinterFactory.create(child, out).print(child, out);
            child = child.getNextSibling();
        }
        this.trackPosition((JavaNode)node, out.line, offset, out);
        if (out.state.arrayBrackets > 0) {
            int i = 0;
            while (i < out.state.arrayBrackets) {
                out.print("[]", node.getType());
                ++i;
            }
            out.state.arrayBrackets = 0;
        }
        this.printCommentsAfter(node, false, false, out);
    }
}

