/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.storage;

import java.io.Serializable;

public final class Project
implements Serializable {
    static final long serialVersionUID = -4874682073931915199L;
    private final String _name;
    private String _description;

    public Project(String name, String description2) {
        this.setDescription(description2);
        this.validate(name, '\\');
        this.validate(name, '/');
        this.validate(name, ':');
        this.validate(name, '*');
        this.validate(name, '?');
        this.validate(name, '\"');
        this.validate(name, '\'');
        this.validate(name, '<');
        this.validate(name, '>');
        this.validate(name, '|');
        this._name = name;
    }

    public void setDescription(String description2) {
        if (description2.length() > 256) {
            throw new IllegalArgumentException("description exceeds maximum of 256 -- " + description2.length());
        }
        this._description = description2;
    }

    public String getDescription() {
        return this._description;
    }

    public String getName() {
        return this._name;
    }

    public boolean equals(Object o) {
        if (o instanceof Project) {
            return this._name.equals(((Project)o)._name);
        }
        return false;
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    private void validate(String name, char character) {
        if (name.indexOf(character) > -1) {
            throw new IllegalArgumentException("invalid character found -- " + character);
        }
    }
}

