/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.swing;

import de.hunsicker.jalopy.storage.ConventionKeys;
import de.hunsicker.jalopy.swing.AbstractSettingsPage;
import de.hunsicker.jalopy.swing.NumberComboBoxPanel;
import de.hunsicker.jalopy.swing.NumberComboBoxPanelCheckBox;
import de.hunsicker.jalopy.swing.SettingsContainer;
import de.hunsicker.swing.util.SwingHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class IndentationSettingsPage
extends AbstractSettingsPage {
    private static final String EMPTY_STRING = "".intern();
    private static final String NONE = "-1";
    private static final String ZERO = "0";
    private JCheckBox _alignAssignmentsCheckBox;
    private JCheckBox _alignDeclAssignmentsCheckBox;
    private JCheckBox _alignMethodCallChainsCheckBox;
    private JCheckBox _alignMethodDefParamsCheckBox;
    private JCheckBox _alignTernaryOperatorCheckBox;
    private JCheckBox _alignVariablesCheckBox;
    private JCheckBox _indentCaseSwitchCheckBox;
    private JCheckBox _indentContinuationCheckBox;
    private JCheckBox _indentContinuationOperatorCheckBox;
    private JCheckBox _indentExtendsCheckBox;
    private JCheckBox _indentFirstColumnCheckBox;
    private JCheckBox _indentImplementsCheckBox;
    private JCheckBox _indentLabelsCheckBox;
    private JCheckBox _indentThrowsCheckBox;
    private JCheckBox _indentUsingLeadingTabsCheckBox;
    private JCheckBox _indentUsingTabsCheckBox;
    private JCheckBox _standardIndentCheckBox;
    private JComboBox _continuationIndentComboBox;
    private JComboBox _endlineIndentComboBox;
    private JComboBox _indentComboBox;
    private JComboBox _indentExtendsComboBox;
    private JComboBox _indentImplementsComboBox;
    private JComboBox _indentThrowsComboBox;
    private JComboBox _leadingIndentComboBox;
    private JComboBox _tabSizeComboBox;
    private JTabbedPane _tabbedPane;

    public IndentationSettingsPage() {
        this.initialize();
    }

    IndentationSettingsPage(SettingsContainer container) {
        super(container);
        this.initialize();
    }

    public String getPreviewFileName() {
        switch (this._tabbedPane.getSelectedIndex()) {
            case 1: {
                return "indentationmisc";
            }
        }
        return super.getPreviewFileName();
    }

    public void updateSettings() {
        this.settings.put(ConventionKeys.INDENT_SIZE, (String)this._indentComboBox.getSelectedItem());
        this.settings.put(ConventionKeys.INDENT_SIZE_LEADING, (String)this._leadingIndentComboBox.getSelectedItem());
        this.settings.put(ConventionKeys.INDENT_SIZE_CONTINUATION, (String)this._continuationIndentComboBox.getSelectedItem());
        this.settings.put(ConventionKeys.INDENT_SIZE_COMMENT_ENDLINE, (String)this._endlineIndentComboBox.getSelectedItem());
        this.settings.putBoolean(ConventionKeys.INDENT_CASE_FROM_SWITCH, this._indentCaseSwitchCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.INDENT_LABEL, this._indentLabelsCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.INDENT_CONTINUATION_BLOCK, this._indentContinuationCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.INDENT_FIRST_COLUMN_COMMENT, this._indentFirstColumnCheckBox.isSelected());
        this.settings.put(ConventionKeys.INDENT_SIZE_TABS, (String)this._tabSizeComboBox.getSelectedItem());
        this.settings.putBoolean(ConventionKeys.INDENT_WITH_TABS, this._indentUsingTabsCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.INDENT_WITH_TABS_ONLY_LEADING, this._indentUsingLeadingTabsCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.ALIGN_VAR_IDENTS, this._alignVariablesCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.ALIGN_VAR_ASSIGNS, this._alignAssignmentsCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.ALIGN_VAR_DECL_ASSIGNS, this._alignDeclAssignmentsCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.ALIGN_PARAMS_METHOD_DEF, this._alignMethodDefParamsCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.ALIGN_TERNARY_OPERATOR, this._alignTernaryOperatorCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.INDENT_CONTINUATION_OPERATOR, this._indentContinuationOperatorCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.INDENT_DEEP, !this._standardIndentCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.ALIGN_METHOD_CALL_CHAINS, this._alignMethodCallChainsCheckBox.isSelected());
        if (this._indentExtendsCheckBox.isSelected()) {
            this.settings.put(ConventionKeys.INDENT_SIZE_EXTENDS, (String)this._indentExtendsComboBox.getSelectedItem());
        } else {
            this.settings.put(ConventionKeys.INDENT_SIZE_EXTENDS, NONE);
        }
        if (this._indentImplementsCheckBox.isSelected()) {
            this.settings.put(ConventionKeys.INDENT_SIZE_IMPLEMENTS, (String)this._indentImplementsComboBox.getSelectedItem());
        } else {
            this.settings.put(ConventionKeys.INDENT_SIZE_IMPLEMENTS, NONE);
        }
        if (this._indentThrowsCheckBox.isSelected()) {
            this.settings.put(ConventionKeys.INDENT_SIZE_THROWS, (String)this._indentThrowsComboBox.getSelectedItem());
        } else {
            this.settings.put(ConventionKeys.INDENT_SIZE_THROWS, NONE);
        }
    }

    private JPanel createGeneralPane() {
        JPanel policyPanel = new JPanel();
        policyPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.bundle.getString("BDR_INDENTATION_POLICY")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        GridBagLayout policyPanelLayout = new GridBagLayout();
        policyPanel.setLayout(policyPanelLayout);
        GridBagConstraints c = new GridBagConstraints();
        this._standardIndentCheckBox = new JCheckBox(this.bundle.getString("CHK_STANDARD_INDENT"), !this.settings.getBoolean(ConventionKeys.INDENT_DEEP, false));
        this._standardIndentCheckBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 0, 0, 1, 1, 1.0, 1.0, 17, 2, c.insets, 0, 0);
        policyPanelLayout.setConstraints(this._standardIndentCheckBox, c);
        policyPanel.add(this._standardIndentCheckBox);
        JCheckBox deepIndentCheckBox = new JCheckBox(this.bundle.getString("CHK_DEEP_INDENT"), this.settings.getBoolean(ConventionKeys.INDENT_DEEP, false));
        deepIndentCheckBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 1, 0, 0, 1, 1.0, 1.0, 17, 2, c.insets, 0, 0);
        policyPanelLayout.setConstraints(deepIndentCheckBox, c);
        policyPanel.add(deepIndentCheckBox);
        ButtonGroup policyGroup = new ButtonGroup();
        policyGroup.add(this._standardIndentCheckBox);
        policyGroup.add(deepIndentCheckBox);
        JPanel indentPanel = new JPanel();
        indentPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.bundle.getString("BDR_SIZES")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        GridBagLayout indentPanelLayout = new GridBagLayout();
        indentPanel.setLayout(indentPanelLayout);
        Object[] items = this.createItemList(new int[]{2, 3, 4});
        NumberComboBoxPanel indent = new NumberComboBoxPanel(this.bundle.getString("LBL_GENERAL_INDENT"), items, this.settings.get(ConventionKeys.INDENT_SIZE, String.valueOf(4)));
        this._indentComboBox = indent.getComboBox();
        this._indentComboBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 0, 0, 0, 1, 1.0, 1.0, 18, 2, c.insets, 0, 0);
        indentPanelLayout.setConstraints(indent, c);
        indentPanel.add(indent);
        Object[] leadingItems = this.createItemList(new int[]{0, 2, 4, 6, 8, 10});
        NumberComboBoxPanel leadingIndent = new NumberComboBoxPanel(this.bundle.getString("LBL_LEADING_INDENT"), leadingItems, this.settings.get(ConventionKeys.INDENT_SIZE_LEADING, String.valueOf(0)));
        this._leadingIndentComboBox = leadingIndent.getComboBox();
        this._leadingIndentComboBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 0, 1, 0, 1, 1.0, 1.0, 18, 2, c.insets, 0, 0);
        indentPanelLayout.setConstraints(leadingIndent, c);
        indentPanel.add(leadingIndent);
        Object[] continuationItems = this.createItemList(new int[]{2, 4, 6, 8, 10, 12});
        NumberComboBoxPanel continuationIndent = new NumberComboBoxPanel(this.bundle.getString("LBL_CONTINUATION_INDENT"), continuationItems, this.settings.get(ConventionKeys.INDENT_SIZE_CONTINUATION, String.valueOf(4)));
        this._continuationIndentComboBox = continuationIndent.getComboBox();
        this._continuationIndentComboBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 0, 2, 0, 1, 1.0, 1.0, 18, 2, c.insets, 0, 0);
        indentPanelLayout.setConstraints(continuationIndent, c);
        indentPanel.add(continuationIndent);
        Object[] endlineItems = this.createItemList(new int[]{0, 1, 2, 3, 4});
        NumberComboBoxPanel endlineIndent = new NumberComboBoxPanel(this.bundle.getString("LBL_TRAILING_INDENT"), endlineItems, this.settings.get(ConventionKeys.INDENT_SIZE_COMMENT_ENDLINE, String.valueOf(1)));
        this._endlineIndentComboBox = endlineIndent.getComboBox();
        this._endlineIndentComboBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 0, 3, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
        indentPanelLayout.setConstraints(endlineIndent, c);
        indentPanel.add(endlineIndent);
        Object[] tabSizeItems = this.createItemList(new int[]{2, 3, 4, 6, 8, 10});
        NumberComboBoxPanel tabSize = new NumberComboBoxPanel(this.bundle.getString("LBL_ORIGINAL_TAB"), tabSizeItems, this.settings.get(ConventionKeys.INDENT_SIZE_TABS, String.valueOf(8)));
        this._tabSizeComboBox = tabSize.getComboBox();
        this._tabSizeComboBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 0, 4, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
        indentPanelLayout.setConstraints(tabSize, c);
        indentPanel.add(tabSize);
        Object[] identItems = this.createItemList(new int[]{0, 2, 3, 4, 6, 8});
        int indentExtends = this.settings.getInt(ConventionKeys.INDENT_SIZE_EXTENDS, -1);
        NumberComboBoxPanelCheckBox indentExtendsComboCheckBox = new NumberComboBoxPanelCheckBox(this.bundle.getString("CHK_EXTENDS_INDENT"), indentExtends > -1, EMPTY_STRING, identItems, indentExtends > -1 ? String.valueOf(indentExtends) : ZERO);
        this._indentExtendsCheckBox = indentExtendsComboCheckBox.getCheckBox();
        this._indentExtendsCheckBox.addActionListener(this.trigger);
        this._indentExtendsComboBox = indentExtendsComboCheckBox.getComboBoxPanel().getComboBox();
        this._indentExtendsComboBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 0, 5, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
        indentPanelLayout.setConstraints(indentExtendsComboCheckBox, c);
        indentPanel.add(indentExtendsComboCheckBox);
        int indentImplements = this.settings.getInt(ConventionKeys.INDENT_SIZE_IMPLEMENTS, -1);
        NumberComboBoxPanelCheckBox indentImplementsComboCheckBox = new NumberComboBoxPanelCheckBox(this.bundle.getString("CHK_IMPLEMENTS_INDENT"), indentImplements > -1, EMPTY_STRING, identItems, indentImplements > -1 ? String.valueOf(indentImplements) : ZERO);
        this._indentImplementsCheckBox = indentImplementsComboCheckBox.getCheckBox();
        this._indentImplementsCheckBox.addActionListener(this.trigger);
        this._indentImplementsComboBox = indentImplementsComboCheckBox.getComboBoxPanel().getComboBox();
        this._indentImplementsComboBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 0, 6, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
        indentPanelLayout.setConstraints(indentImplementsComboCheckBox, c);
        indentPanel.add(indentImplementsComboCheckBox);
        int indentThrows = this.settings.getInt(ConventionKeys.INDENT_SIZE_THROWS, -1);
        NumberComboBoxPanelCheckBox indentThrowsComboCheckBox = new NumberComboBoxPanelCheckBox(this.bundle.getString("CHK_THROWS_INDENT"), indentThrows > -1, EMPTY_STRING, identItems, indentThrows > -1 ? String.valueOf(indentThrows) : ZERO);
        this._indentThrowsCheckBox = indentThrowsComboCheckBox.getCheckBox();
        this._indentThrowsComboBox = indentThrowsComboCheckBox.getComboBoxPanel().getComboBox();
        this._indentThrowsCheckBox.addActionListener(this.trigger);
        this._indentThrowsComboBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 0, 7, 0, 1, 1.0, 1.0, 18, 2, c.insets, 0, 0);
        indentPanelLayout.setConstraints(indentThrowsComboCheckBox, c);
        indentPanel.add(indentThrowsComboCheckBox);
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        c.insets.bottom = 0;
        c.insets.top = 10;
        c.insets.left = 5;
        c.insets.right = 5;
        SwingHelper.setConstraints(c, 0, 0, 0, 1, 1.0, 0.0, 18, 2, c.insets, 5, 5);
        layout.setConstraints(policyPanel, c);
        panel.add(policyPanel);
        c.insets.bottom = 0;
        SwingHelper.setConstraints(c, 0, 1, 0, 1, 1.0, 1.0, 18, 2, c.insets, 5, 5);
        layout.setConstraints(indentPanel, c);
        panel.add(indentPanel);
        return panel;
    }

    private JPanel createMiscPane() {
        JPanel miscPanel = new JPanel();
        GridBagLayout miscPanelLayout = new GridBagLayout();
        miscPanel.setLayout(miscPanelLayout);
        miscPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.bundle.getString("BDR_MISC")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        GridBagConstraints c = new GridBagConstraints();
        this._indentUsingTabsCheckBox = new JCheckBox(this.bundle.getString("CHK_USE_TABS"), this.settings.getBoolean(ConventionKeys.INDENT_WITH_TABS, false));
        this._indentUsingTabsCheckBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 0, 0, 1, 1, 1.0, 0.0, 17, 2, c.insets, 0, 0);
        miscPanelLayout.setConstraints(this._indentUsingTabsCheckBox, c);
        miscPanel.add(this._indentUsingTabsCheckBox);
        this._indentUsingLeadingTabsCheckBox = new JCheckBox(this.bundle.getString("CHK_USE_LEADING_TABS"), this.settings.getBoolean(ConventionKeys.INDENT_WITH_TABS_ONLY_LEADING, false));
        this._indentUsingLeadingTabsCheckBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 1, 0, 0, 1, 1.0, 0.0, 17, 2, c.insets, 0, 0);
        miscPanelLayout.setConstraints(this._indentUsingLeadingTabsCheckBox, c);
        miscPanel.add(this._indentUsingLeadingTabsCheckBox);
        this._indentCaseSwitchCheckBox = new JCheckBox(this.bundle.getString("CHK_INDENT_CASE_SWITCH"), this.settings.getBoolean(ConventionKeys.INDENT_CASE_FROM_SWITCH, false));
        this._indentCaseSwitchCheckBox.addActionListener(this.trigger);
        c.insets.top = 0;
        SwingHelper.setConstraints(c, 0, 1, 1, 1, 1.0, 0.0, 17, 2, c.insets, 0, 0);
        miscPanelLayout.setConstraints(this._indentCaseSwitchCheckBox, c);
        miscPanel.add(this._indentCaseSwitchCheckBox);
        this._indentLabelsCheckBox = new JCheckBox(this.bundle.getString("CHK_INDENT_LABELS"), this.settings.getBoolean(ConventionKeys.INDENT_LABEL, false));
        this._indentLabelsCheckBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 1, 1, 0, 1, 1.0, 1.0, 17, 2, c.insets, 0, 0);
        miscPanelLayout.setConstraints(this._indentLabelsCheckBox, c);
        miscPanel.add(this._indentLabelsCheckBox);
        this._indentFirstColumnCheckBox = new JCheckBox(this.bundle.getString("CHK_INDENT_FIRST_COLUMN"), this.settings.getBoolean(ConventionKeys.INDENT_FIRST_COLUMN_COMMENT, true));
        this._indentFirstColumnCheckBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 0, 2, 0, 1, 1.0, 1.0, 17, 2, c.insets, 0, 0);
        miscPanelLayout.setConstraints(this._indentFirstColumnCheckBox, c);
        miscPanel.add(this._indentFirstColumnCheckBox);
        JPanel continuationPanel = new JPanel();
        GridBagLayout continuationPanelLayout = new GridBagLayout();
        continuationPanel.setLayout(continuationPanelLayout);
        continuationPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.bundle.getString("BDR_CONTINUATION_INDENT")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        this._indentContinuationCheckBox = new JCheckBox(this.bundle.getString("CHK_CONTINUATION_INDENT_BLOCKS"), this.settings.getBoolean(ConventionKeys.INDENT_CONTINUATION_BLOCK, true));
        this._indentContinuationCheckBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 0, 0, 1, 1, 1.0, 1.0, 17, 2, c.insets, 0, 0);
        continuationPanelLayout.setConstraints(this._indentContinuationCheckBox, c);
        continuationPanel.add(this._indentContinuationCheckBox);
        this._indentContinuationOperatorCheckBox = new JCheckBox(this.bundle.getString("CHK_CONTINUATION_INDENT_OPERATORS"), this.settings.getBoolean(ConventionKeys.INDENT_CONTINUATION_OPERATOR, false));
        this._indentContinuationOperatorCheckBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 1, 0, 0, 1, 1.0, 1.0, 17, 2, c.insets, 0, 0);
        continuationPanelLayout.setConstraints(this._indentContinuationOperatorCheckBox, c);
        continuationPanel.add(this._indentContinuationOperatorCheckBox);
        JPanel alignPanel = new JPanel();
        GridBagLayout alignPanelLayout = new GridBagLayout();
        alignPanel.setLayout(alignPanelLayout);
        alignPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.bundle.getString("BDR_ALIGN")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        this._alignVariablesCheckBox = new JCheckBox(this.bundle.getString("CHK_VAR_IDENT"), this.settings.getBoolean(ConventionKeys.ALIGN_VAR_IDENTS, false));
        this._alignVariablesCheckBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 0, 0, 1, 1, 1.0, 1.0, 17, 2, c.insets, 0, 0);
        alignPanelLayout.setConstraints(this._alignVariablesCheckBox, c);
        alignPanel.add(this._alignVariablesCheckBox);
        this._alignAssignmentsCheckBox = new JCheckBox(this.bundle.getString("CHK_VAR_ASSIGN"), this.settings.getBoolean(ConventionKeys.ALIGN_VAR_ASSIGNS, false));
        this._alignAssignmentsCheckBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 1, 0, 0, 1, 1.0, 0.0, 17, 2, c.insets, 0, 0);
        alignPanelLayout.setConstraints(this._alignAssignmentsCheckBox, c);
        alignPanel.add(this._alignAssignmentsCheckBox);
        this._alignMethodDefParamsCheckBox = new JCheckBox(this.bundle.getString("CHK_METHOD_PARAM"), this.settings.getBoolean(ConventionKeys.ALIGN_PARAMS_METHOD_DEF, false));
        this._alignMethodDefParamsCheckBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 0, 1, 1, 1, 1.0, 0.0, 17, 2, c.insets, 0, 0);
        alignPanelLayout.setConstraints(this._alignMethodDefParamsCheckBox, c);
        alignPanel.add(this._alignMethodDefParamsCheckBox);
        this._alignMethodCallChainsCheckBox = new JCheckBox(this.bundle.getString("CHK_METHOD_CALL_CHAINED"), this.settings.getBoolean(ConventionKeys.ALIGN_METHOD_CALL_CHAINS, true));
        this._alignMethodCallChainsCheckBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 1, 1, 0, 1, 1.0, 1.0, 17, 2, c.insets, 0, 0);
        alignPanelLayout.setConstraints(this._alignMethodCallChainsCheckBox, c);
        alignPanel.add(this._alignMethodCallChainsCheckBox);
        this._alignTernaryOperatorCheckBox = new JCheckBox(this.bundle.getString("CHK_TERNARY_EXPR"), this.settings.getBoolean(ConventionKeys.ALIGN_TERNARY_OPERATOR, true));
        this._alignTernaryOperatorCheckBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 0, 2, 1, 1, 1.0, 0.0, 17, 2, c.insets, 0, 0);
        alignPanelLayout.setConstraints(this._alignTernaryOperatorCheckBox, c);
        alignPanel.add(this._alignTernaryOperatorCheckBox);
        this._alignDeclAssignmentsCheckBox = new JCheckBox("Align Declaration Assignment", this.settings.getBoolean(ConventionKeys.ALIGN_VAR_DECL_ASSIGNS, this.settings.getBoolean(ConventionKeys.ALIGN_VAR_ASSIGNS, false)));
        this._alignDeclAssignmentsCheckBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 1, 2, 0, 1, 1.0, 1.0, 17, 2, c.insets, 0, 0);
        alignPanelLayout.setConstraints(this._alignDeclAssignmentsCheckBox, c);
        alignPanel.add(this._alignDeclAssignmentsCheckBox);
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        c.insets.bottom = 10;
        c.insets.top = 10;
        c.insets.left = 5;
        c.insets.right = 5;
        SwingHelper.setConstraints(c, 0, 0, 0, 1, 1.0, 0.0, 18, 2, c.insets, 5, 5);
        layout.setConstraints(miscPanel, c);
        panel.add(miscPanel);
        c.insets.top = 0;
        SwingHelper.setConstraints(c, 0, 1, 0, 1, 1.0, 0.0, 18, 2, c.insets, 5, 5);
        layout.setConstraints(alignPanel, c);
        panel.add(alignPanel);
        SwingHelper.setConstraints(c, 0, 2, 0, 1, 1.0, 1.0, 18, 2, c.insets, 5, 5);
        layout.setConstraints(continuationPanel, c);
        panel.add(continuationPanel);
        return panel;
    }

    private void initialize() {
        this._tabbedPane = new JTabbedPane();
        this._tabbedPane.add((Component)this.createGeneralPane(), this.bundle.getString("TAB_GENERAL"));
        this._tabbedPane.add((Component)this.createMiscPane(), this.bundle.getString("TAB_MISC"));
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        this.add((Component)this._tabbedPane, "Center");
        if (this.getContainer() != null) {
            this._tabbedPane.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent ev) {
                    String text = IndentationSettingsPage.this.getContainer().loadPreview(IndentationSettingsPage.this.getPreviewFileName());
                    IndentationSettingsPage.this.getContainer().getPreview().setText(text);
                }
            });
        }
    }
}

