/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.corba.idl.parser;

import antlr.collections.AST;
import java.util.Map;
import org.apache.axis2.corba.exceptions.InvalidIDLException;
import org.apache.axis2.corba.idl.types.AbstractCollectionType;
import org.apache.axis2.corba.idl.types.ArrayType;
import org.apache.axis2.corba.idl.types.DataType;
import org.apache.axis2.corba.idl.types.EnumType;
import org.apache.axis2.corba.idl.types.ExceptionType;
import org.apache.axis2.corba.idl.types.IDL;
import org.apache.axis2.corba.idl.types.Interface;
import org.apache.axis2.corba.idl.types.Member;
import org.apache.axis2.corba.idl.types.Operation;
import org.apache.axis2.corba.idl.types.PrimitiveDataType;
import org.apache.axis2.corba.idl.types.SequenceType;
import org.apache.axis2.corba.idl.types.Struct;
import org.apache.axis2.corba.idl.types.Typedef;
import org.apache.axis2.corba.idl.types.UnionMember;
import org.apache.axis2.corba.idl.types.UnionType;
import org.apache.axis2.corba.idl.types.ValueType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IDLVisitor {
    private static final Log log = LogFactory.getLog(IDLVisitor.class);
    private IDL idl = new IDL();
    private String module = "";
    private String moduleForInnerTypes = null;
    private static final String INNERTYPE_SUFFIX = "Package";

    public IDL getIDL() {
        return this.idl;
    }

    public void setIDL(IDL idl) {
        this.idl = idl;
    }

    public void visit(AST node) throws InvalidIDLException {
        while (node != null) {
            switch (node.getType()) {
                case 7: {
                    this.idl.addInterface(this.visitInterface(node));
                    break;
                }
                case 11: {
                    AST moduleName = node.getFirstChild();
                    IDLVisitor moduleVisitor = new IDLVisitor();
                    moduleVisitor.setIDL(this.idl);
                    moduleVisitor.setModule(this.module + moduleName);
                    moduleVisitor.visit(moduleName.getNextSibling());
                    this.idl.addIDL(moduleVisitor.getIDL());
                    break;
                }
                case 55: {
                    this.idl.addType(this.visitStruct(node));
                    break;
                }
                case 9: {
                    this.idl.addType(this.visitValueType(node));
                    break;
                }
                case 68: {
                    this.idl.addType(this.visitException(node));
                    break;
                }
                case 60: {
                    this.idl.addType(this.visitEnum(node));
                    break;
                }
                case 56: {
                    this.idl.addType(this.visitUnion(node));
                    break;
                }
                case 42: {
                    this.visitAndAddTypedefs(node, this.module);
                    break;
                }
                default: {
                    throw new InvalidIDLException("Unsupported IDL token " + node);
                }
            }
            node = node.getNextSibling();
        }
    }

    private Struct visitStruct(AST node) throws InvalidIDLException {
        AST structNode = node.getFirstChild();
        String structName = structNode.toString();
        Struct struct = new Struct();
        struct.setModule(this.module);
        struct.setName(structName);
        AST memberTypeNode = structNode.getNextSibling();
        while (memberTypeNode != null) {
            Member member = new Member();
            DataType dataType = this.findDataType(memberTypeNode, structName);
            AST memberNode = memberTypeNode.getNextSibling();
            String memberName = memberNode.getText();
            int dimensions = memberNode.getNumberOfChildren();
            if (dimensions > 0) {
                AbstractCollectionType arrayType = null;
                ArrayType rootArrayType = null;
                int i = 1;
                for (AST dimensionNode = memberNode.getFirstChild(); dimensionNode != null; dimensionNode = dimensionNode.getNextSibling()) {
                    ArrayType temp = new ArrayType();
                    temp.setElementModule(this.module);
                    temp.setElementName(memberName);
                    temp.setDepth(i);
                    ++i;
                    if (arrayType != null) {
                        arrayType.setDataType(temp);
                    } else {
                        rootArrayType = temp;
                    }
                    arrayType = temp;
                    arrayType.setElementCount(Integer.parseInt(dimensionNode.getText()));
                }
                if (arrayType != null) {
                    arrayType.setDataType(dataType);
                }
                Typedef typedef = new Typedef();
                typedef.setDataType(rootArrayType);
                typedef.setModule(this.module);
                typedef.setName(structName + '_' + memberName);
                this.idl.addType(typedef);
                dataType = typedef;
            }
            member.setDataType(dataType);
            member.setName(memberName);
            struct.addMember(member);
            memberTypeNode = memberNode.getNextSibling();
        }
        return struct;
    }

    private ValueType visitValueType(AST node) throws InvalidIDLException {
        AST valueNode = node.getFirstChild();
        ValueType value = new ValueType();
        value.setModule(this.module);
        String valueName = valueNode.toString();
        value.setName(valueName);
        AST memberModifierNode = valueNode.getNextSibling();
        while (memberModifierNode != null) {
            String memberModifierName = memberModifierNode.toString();
            if (!memberModifierName.equals("private") && !memberModifierName.equals("public")) {
                if (14 == memberModifierNode.getType()) {
                    String[] pragma;
                    if (memberModifierName.startsWith("pragma ID ") && (pragma = (memberModifierName = memberModifierName.substring(10)).split(" ")).length == 2 && pragma[0] != null && pragma[1] != null && pragma[0].equals(value.getName())) {
                        pragma[1] = pragma[1].replace('\"', ' ');
                        value.setId(pragma[1].trim());
                    }
                } else {
                    value.addOperation(this.visitOperation(memberModifierNode));
                }
                memberModifierNode = memberModifierNode.getNextSibling();
                continue;
            }
            Member memberType = new Member();
            memberType.setModifier(memberModifierName);
            AST memberTypeNode = memberModifierNode.getNextSibling();
            memberType.setDataType(this.findDataType(memberTypeNode, valueName));
            AST memberNode = memberTypeNode.getNextSibling();
            memberType.setName(memberNode.toString());
            value.addMember(memberType);
            memberModifierNode = memberNode.getNextSibling();
        }
        return value;
    }

    private Interface visitInterface(AST node) throws InvalidIDLException {
        Interface intf = new Interface();
        intf.setModule(this.module);
        AST interfaceNode = node.getFirstChild();
        String interfaceName = interfaceNode.toString();
        intf.setName(interfaceName);
        this.moduleForInnerTypes = this.module + interfaceName + INNERTYPE_SUFFIX + "::";
        block10: for (AST node2 = interfaceNode.getNextSibling(); node2 != null; node2 = node2.getNextSibling()) {
            switch (node2.getType()) {
                case 55: {
                    Struct innerStruct = this.visitStruct(node2);
                    innerStruct.setModule(this.moduleForInnerTypes);
                    this.idl.addType(innerStruct);
                    continue block10;
                }
                case 9: {
                    log.error((Object)("Unsupported IDL token " + node2));
                    continue block10;
                }
                case 68: {
                    ExceptionType innerEx = this.visitException(node2);
                    innerEx.setModule(this.moduleForInnerTypes);
                    this.idl.addType(innerEx);
                    continue block10;
                }
                case 60: {
                    EnumType innerEnum = this.visitEnum(node2);
                    innerEnum.setModule(this.moduleForInnerTypes);
                    this.idl.addType(innerEnum);
                    continue block10;
                }
                case 56: {
                    UnionType innerUnion = this.visitUnion(node2);
                    innerUnion.setModule(this.moduleForInnerTypes);
                    this.idl.addType(innerUnion);
                    continue block10;
                }
                case 42: {
                    this.visitAndAddTypedefs(node2, this.moduleForInnerTypes);
                    continue block10;
                }
                case 27: {
                    log.error((Object)("Unsupported IDL token " + node2));
                    continue block10;
                }
                case 81: {
                    intf.addOperation(this.visitGetAttribute(node2));
                    intf.addOperation(this.visitSetAttribute(node2));
                    continue block10;
                }
                default: {
                    if (node2.toString().startsWith("pragma ID ")) {
                        String pragmaId = node2.toString().substring(10);
                        String[] pragma = pragmaId.split(" ");
                        if (pragma.length != 2 || pragma[0] == null || pragma[1] == null || !pragma[0].equals(intf.getName())) continue block10;
                        pragma[1] = pragma[1].replace('\"', ' ');
                        intf.setId(pragma[1].trim());
                        continue block10;
                    }
                    intf.addOperation(this.visitOperation(node2));
                }
            }
        }
        this.moduleForInnerTypes = null;
        return intf;
    }

    private Operation visitGetAttribute(AST node) throws InvalidIDLException {
        Operation operation = new Operation();
        AST type = node.getFirstChild();
        AST name = type.getNextSibling();
        String attrName = name.toString();
        operation.setReturnType(this.findDataType(type, attrName));
        operation.setName("_get_" + attrName);
        return operation;
    }

    private Operation visitSetAttribute(AST node) throws InvalidIDLException {
        Operation operation = new Operation();
        AST type = node.getFirstChild();
        operation.setReturnType(PrimitiveDataType.getPrimitiveDataType("void"));
        AST name = type.getNextSibling();
        String attrName = name.toString();
        operation.setName("_set_" + attrName);
        Member param = new Member();
        param.setName(attrName);
        param.setDataType(this.findDataType(type, attrName));
        operation.addParam(param);
        return operation;
    }

    private Operation visitOperation(AST node) throws InvalidIDLException {
        Operation operation = new Operation();
        String opName = node.toString();
        operation.setName(opName);
        AST type = node.getFirstChild();
        operation.setReturnType(this.findDataType(type, opName));
        for (AST mode = type.getNextSibling(); mode != null; mode = mode.getNextSibling()) {
            if (73 == mode.getType()) {
                for (AST idlType = mode.getFirstChild(); idlType != null; idlType = idlType.getNextSibling()) {
                    operation.addRaises((ExceptionType)this.findDataType(idlType, opName));
                }
                continue;
            }
            Member param = new Member();
            param.setMode(mode.toString());
            AST idlType = mode.getFirstChild();
            AST paramName = idlType.getNextSibling();
            String paramNameStr = paramName.toString();
            param.setDataType(this.findDataType(idlType, paramNameStr));
            param.setName(paramNameStr);
            operation.addParam(param);
        }
        return operation;
    }

    private ExceptionType visitException(AST node) throws InvalidIDLException {
        ExceptionType raisesType = new ExceptionType();
        AST exNode = node.getFirstChild();
        String exName = exNode.toString();
        raisesType.setModule(this.module);
        raisesType.setName(exName);
        AST memberTypeNode = exNode.getNextSibling();
        while (memberTypeNode != null) {
            Member member = new Member();
            member.setDataType(this.findDataType(memberTypeNode, exName));
            AST memberNode = memberTypeNode.getNextSibling();
            member.setName(memberNode.toString());
            raisesType.addMember(member);
            memberTypeNode = memberNode.getNextSibling();
        }
        return raisesType;
    }

    private DataType findDataType(AST typeNode, String parentName) throws InvalidIDLException {
        return this.findDataType(typeNode, parentName, true, false);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DataType findDataType(AST typeNode, String parentName, boolean root, boolean noTypeDefForSeqs) throws InvalidIDLException {
        void var5_14;
        void var5_12;
        String typeName;
        if (typeNode.getType() == 61) {
            SequenceType sequenceType = this.visitAnonymousSequence(typeNode, parentName, root);
            if (noTypeDefForSeqs) {
                return sequenceType;
            }
            Typedef typedef = new Typedef();
            typedef.setDataType(sequenceType);
            typedef.setModule(this.module);
            typedef.setName(parentName + '_' + sequenceType.getName());
            this.idl.addType(typedef);
            return typedef;
        }
        Object var5_6 = null;
        Map compositeDataTypes = this.idl.getCompositeDataTypes();
        if (typeNode.getType() == 48) {
            AST nextNode = typeNode.getNextSibling();
            if (nextNode == null) {
                throw new InvalidIDLException("'unsigned' without a data type");
            }
            if (nextNode.getType() == 47) {
                typeNode.setNextSibling(nextNode.getNextSibling());
                typeNode.setFirstChild(nextNode.getFirstChild());
                typeName = "ushort";
            } else {
                if (nextNode.getType() != 46) throw new InvalidIDLException("either 'long' or 'short' is expected after the 'unsigned' keyword");
                AST nextToLong = nextNode.getNextSibling();
                if (nextToLong == null) {
                    throw new InvalidIDLException("an identifier is required after the 'long' keyword");
                }
                if (nextToLong.getType() == 46) {
                    typeNode.setNextSibling(nextToLong.getNextSibling());
                    typeNode.setFirstChild(nextToLong.getFirstChild());
                    typeName = "ulonglong";
                } else {
                    typeNode.setNextSibling(nextNode.getNextSibling());
                    typeNode.setFirstChild(nextNode.getFirstChild());
                    typeName = "ulong";
                }
            }
        } else if (typeNode.getType() == 46) {
            AST nextToLong = typeNode.getNextSibling();
            if (nextToLong == null) {
                throw new InvalidIDLException("an identifier is required after the 'long' keyword");
            }
            if (nextToLong.getType() == 46) {
                typeNode.setNextSibling(nextToLong.getNextSibling());
                typeNode.setFirstChild(nextToLong.getFirstChild());
                typeName = "longlong";
            } else {
                typeName = "long";
            }
        } else {
            typeName = this.getTypeName(typeNode);
        }
        if (compositeDataTypes != null) {
            void var5_10;
            void var5_8;
            if (!this.module.equals("") && !typeName.startsWith(this.module)) {
                DataType dataType = (DataType)this.idl.getCompositeDataTypes().get(this.module + typeName);
            }
            if (var5_8 == null && this.moduleForInnerTypes != null && !typeName.startsWith(this.module)) {
                DataType dataType = (DataType)this.idl.getCompositeDataTypes().get(this.moduleForInnerTypes + typeName);
            }
            if (var5_10 == null) {
                DataType dataType = (DataType)this.idl.getCompositeDataTypes().get(typeName);
            }
        }
        if (var5_12 == null) {
            PrimitiveDataType primitiveDataType = PrimitiveDataType.getPrimitiveDataType(typeName);
        }
        if (var5_14 != null) return var5_14;
        throw new InvalidIDLException("Invalid data type: " + typeName);
    }

    public String getTypeName(AST node) {
        String typeName = node.getText();
        for (AST memberTypeNodeChild = node.getFirstChild(); memberTypeNodeChild != null; memberTypeNodeChild = memberTypeNodeChild.getNextSibling()) {
            typeName = typeName + "::" + memberTypeNodeChild.toString();
        }
        return typeName;
    }

    public void setModule(String module) {
        if (module == null || module.length() < 1) {
            module = "";
        } else if (!module.endsWith("::")) {
            module = module + "::";
        }
        this.module = module;
    }

    private EnumType visitEnum(AST node) {
        AST enumNode = node.getFirstChild();
        String enumName = enumNode.toString();
        EnumType enumType = new EnumType();
        enumType.setModule(this.module);
        enumType.setName(enumName);
        for (AST memberTypeNode = enumNode.getNextSibling(); memberTypeNode != null; memberTypeNode = memberTypeNode.getNextSibling()) {
            enumType.addEnumMember(memberTypeNode.toString());
        }
        return enumType;
    }

    private UnionType visitUnion(AST node) throws InvalidIDLException {
        UnionType unionType = new UnionType();
        AST unNode = node.getFirstChild();
        String unName = unNode.toString();
        unionType.setModule(this.module);
        unionType.setName(unName);
        AST switchTypeNode = unNode.getNextSibling();
        unionType.setDiscriminatorType(this.findDataType(switchTypeNode, unName));
        for (AST caseOrDefaultNode = switchTypeNode.getNextSibling(); caseOrDefaultNode != null; caseOrDefaultNode = caseOrDefaultNode.getNextSibling()) {
            AST typeNode;
            UnionMember unionMember = new UnionMember();
            if (59 == caseOrDefaultNode.getType()) {
                unionMember.setDefault(true);
                typeNode = caseOrDefaultNode.getFirstChild();
            } else {
                unionMember.setDefault(false);
                AST caseValueNode = caseOrDefaultNode.getFirstChild();
                unionMember.setDiscriminatorValue(caseValueNode.getText());
                typeNode = caseValueNode.getNextSibling();
            }
            unionMember.setDataType(this.findDataType(typeNode, unName));
            AST memberNode = typeNode.getNextSibling();
            unionMember.setName(memberNode.toString());
            unionType.addMember(unionMember);
        }
        return unionType;
    }

    private void visitAndAddTypedefs(AST node, String moduleName) throws InvalidIDLException {
        AST typedefNameNode;
        AST typedefNode = node.getFirstChild();
        DataType dataType = this.findDataType(typedefNode, null, true, true);
        String typedefName = typedefNameNode.toString();
        for (typedefNameNode = typedefNode.getNextSibling(); typedefNameNode != null; typedefNameNode = typedefNameNode.getNextSibling()) {
            int dimensions = typedefNameNode.getNumberOfChildren();
            if (dimensions > 0) {
                AbstractCollectionType arrayType = null;
                ArrayType rootArrayType = null;
                int i = 1;
                for (AST dimensionNode = typedefNameNode.getFirstChild(); dimensionNode != null; dimensionNode = dimensionNode.getNextSibling()) {
                    ArrayType temp = new ArrayType();
                    temp.setElementModule(moduleName);
                    temp.setElementName(typedefName);
                    temp.setDepth(i);
                    ++i;
                    if (arrayType != null) {
                        arrayType.setDataType(temp);
                    } else {
                        rootArrayType = temp;
                    }
                    arrayType = temp;
                    arrayType.setElementCount(Integer.parseInt(dimensionNode.getText()));
                }
                if (arrayType != null) {
                    arrayType.setDataType(dataType);
                }
                dataType = rootArrayType;
            }
            Typedef typedef = new Typedef();
            typedef.setDataType(dataType);
            typedef.setModule(moduleName);
            typedef.setName(typedefName);
            this.idl.addType(typedef);
        }
    }

    private SequenceType visitAnonymousSequence(AST node, String parentName, boolean root) throws InvalidIDLException {
        AST countNode;
        AST typeNode = node.getFirstChild();
        SequenceType sequenceType = new SequenceType();
        DataType dataType = this.findDataType(typeNode, parentName, false, false);
        sequenceType.setDataType(dataType);
        sequenceType.setElementModule(this.module);
        AST elementNode = node.getNextSibling();
        if (elementNode != null && root) {
            String elementName = elementNode.getText();
            sequenceType.setName(elementName);
            SequenceType tempSeqType = sequenceType;
            int i = 1;
            while (true) {
                tempSeqType.setElementName(elementName);
                tempSeqType.setDepth(i);
                ++i;
                DataType tempDataType = tempSeqType.getDataType();
                if (!(tempDataType instanceof SequenceType)) break;
                tempSeqType = (SequenceType)tempDataType;
            }
        }
        if ((countNode = typeNode.getNextSibling()) != null) {
            sequenceType.setElementCount(Integer.parseInt(countNode.getText()));
        } else {
            sequenceType.setElementCount(0);
        }
        return sequenceType;
    }
}

