/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.framework;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceProvider;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.jaxws.addressing.util.EndpointContextMap;
import org.apache.axis2.jaxws.addressing.util.EndpointContextMapManager;
import org.apache.axis2.jaxws.addressing.util.EndpointKey;
import org.apache.axis2.jaxws.description.DescriptionFactory;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.server.JAXWSMessageReceiver;
import org.apache.axis2.util.Loader;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JAXWSDeployer
implements Deployer {
    private static Log log = LogFactory.getLog(JAXWSDeployer.class);
    protected ConfigurationContext configCtx;
    protected AxisConfiguration axisConfig;

    public void init(ConfigurationContext configCtx) {
        this.configCtx = configCtx;
        this.axisConfig = configCtx.getAxisConfiguration();
        this.deployServicesInWARClassPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deployServicesInWARClassPath() {
        String dir = DeploymentEngine.getWebLocationString();
        if (dir != null) {
            File file = new File(dir + "/WEB-INF/classes/");
            URL repository = this.axisConfig.getRepository();
            if (!file.isDirectory() || repository == null) {
                return;
            }
            ArrayList classList = this.getClassesInWebInfDirectory(file);
            ClassLoader threadClassLoader = null;
            try {
                threadClassLoader = Thread.currentThread().getContextClassLoader();
                ArrayList<URL> urls = new ArrayList<URL>();
                urls.add(repository);
                String webLocation = DeploymentEngine.getWebLocationString();
                if (webLocation != null) {
                    urls.add(new File(webLocation).toURL());
                }
                ClassLoader classLoader = Utils.createClassLoader(urls, (ClassLoader)this.axisConfig.getSystemClassLoader(), (boolean)true, (File)((File)this.axisConfig.getParameterValue("artifactsDIR")));
                Thread.currentThread().setContextClassLoader(classLoader);
                this.deployClasses("JAXWS-Builtin", file.toURL(), Thread.currentThread().getContextClassLoader(), classList);
            }
            catch (Exception e) {
                log.info((Object)Messages.getMessage((String)"deployingexception", (String)e.getMessage()), (Throwable)e);
            }
            finally {
                if (threadClassLoader != null) {
                    Thread.currentThread().setContextClassLoader(threadClassLoader);
                }
            }
        }
    }

    protected ArrayList getClassesInWebInfDirectory(File file) {
        String filePath = file.getAbsolutePath();
        Collection files = FileUtils.listFiles((File)file, (String[])new String[]{"class"}, (boolean)true);
        ArrayList<String> classList = new ArrayList<String>();
        for (File f : files) {
            String fPath = f.getAbsolutePath();
            String fqcn = fPath.substring(filePath.length() + 1);
            fqcn = fqcn.substring(0, fqcn.length() - ".class".length());
            fqcn = fqcn.replace('/', '.');
            fqcn = fqcn.replace('\\', '.');
            classList.add(fqcn);
        }
        return classList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(DeploymentFileData deploymentFileData) {
        ClassLoader threadClassLoader = null;
        try {
            threadClassLoader = Thread.currentThread().getContextClassLoader();
            String groupName = deploymentFileData.getName();
            URL location = deploymentFileData.getFile().toURL();
            if (JAXWSDeployer.isJar(deploymentFileData.getFile())) {
                log.info((Object)("Deploying artifact : " + deploymentFileData.getName()));
                ArrayList<URL> urls = new ArrayList<URL>();
                urls.add(deploymentFileData.getFile().toURL());
                urls.add(this.axisConfig.getRepository());
                String webLocation = DeploymentEngine.getWebLocationString();
                if (webLocation != null) {
                    urls.add(new File(webLocation).toURL());
                }
                ClassLoader classLoader = Utils.createClassLoader(urls, (ClassLoader)this.axisConfig.getSystemClassLoader(), (boolean)true, (File)((File)this.axisConfig.getParameterValue("artifactsDIR")));
                Thread.currentThread().setContextClassLoader(classLoader);
                ArrayList classList = this.getListOfClasses(deploymentFileData);
                AxisServiceGroup serviceGroup = this.deployClasses(groupName, location, classLoader, classList);
                if (serviceGroup == null) {
                    String msg = "Error:\n No annotated classes found in the jar: " + location.toString() + ". Service deployment failed.";
                    log.error((Object)msg);
                    this.axisConfig.getFaultyServices().put(deploymentFileData.getFile().getAbsolutePath(), msg);
                }
            }
        }
        catch (Throwable t) {
            log.debug((Object)Messages.getMessage((String)"stroringfaultyservice", (String)t.getMessage()), t);
            this.storeFaultyService(deploymentFileData, t);
        }
        finally {
            if (threadClassLoader != null) {
                Thread.currentThread().setContextClassLoader(threadClassLoader);
            }
        }
    }

    protected AxisServiceGroup deployClasses(String groupName, URL location, ClassLoader classLoader, List classList) throws ClassNotFoundException, InstantiationException, IllegalAccessException, AxisFault {
        ArrayList<AxisService> axisServiceList = new ArrayList<AxisService>();
        int size = classList.size();
        for (int i = 0; i < size; ++i) {
            AxisService axisService;
            Class pojoClass;
            String className = (String)classList.get(i);
            try {
                pojoClass = Loader.loadClass((ClassLoader)classLoader, (String)className);
            }
            catch (Exception e) {
                continue;
            }
            WebService wsAnnotation = pojoClass.getAnnotation(WebService.class);
            WebServiceProvider wspAnnotation = null;
            if (wsAnnotation == null) {
                wspAnnotation = pojoClass.getAnnotation(WebServiceProvider.class);
            }
            if (wsAnnotation == null && wspAnnotation == null || pojoClass.isInterface() || (axisService = this.createAxisService(classLoader, className, location)) == null) continue;
            log.info((Object)("Deploying JAXWS annotated class " + className + " as a service - " + axisService.getName()));
            axisServiceList.add(axisService);
        }
        int size2 = axisServiceList.size();
        if (size2 <= 0) {
            return null;
        }
        AxisServiceGroup serviceGroup = new AxisServiceGroup();
        serviceGroup.setServiceGroupName(groupName);
        for (int i = 0; i < size2; ++i) {
            AxisService axisService = (AxisService)axisServiceList.get(i);
            serviceGroup.addService(axisService);
        }
        this.axisConfig.addServiceGroup(serviceGroup);
        this.configureAddressing(serviceGroup);
        return serviceGroup;
    }

    protected ArrayList getListOfClasses(DeploymentFileData deploymentFileData) throws IOException {
        ArrayList<String> classList;
        FileInputStream fin = null;
        ZipInputStream zin = null;
        try {
            ZipEntry entry;
            fin = new FileInputStream(deploymentFileData.getAbsolutePath());
            zin = new ZipInputStream(fin);
            classList = new ArrayList<String>();
            while ((entry = zin.getNextEntry()) != null) {
                String name = entry.getName();
                if (!name.endsWith(".class")) continue;
                name = name.replaceAll(".class", "");
                name = name.replaceAll("/", ".");
                classList.add(name);
            }
            zin.close();
            fin.close();
        }
        catch (Exception e) {
            log.debug((Object)Messages.getMessage((String)"deployingexception", (String)e.getMessage()), (Throwable)e);
            throw new DeploymentException((Throwable)e);
        }
        finally {
            if (zin != null) {
                zin.close();
            }
            if (fin != null) {
                fin.close();
            }
        }
        return classList;
    }

    protected void storeFaultyService(DeploymentFileData deploymentFileData, Throwable t) {
        StringWriter errorWriter = new StringWriter();
        PrintWriter ptintWriter = new PrintWriter(errorWriter);
        t.printStackTrace(ptintWriter);
        String error = "Error:\n" + errorWriter.toString();
        this.axisConfig.getFaultyServices().put(deploymentFileData.getFile().getAbsolutePath(), error);
    }

    protected AxisService createAxisService(ClassLoader classLoader, String className, URL serviceLocation) throws ClassNotFoundException, InstantiationException, IllegalAccessException, AxisFault {
        AxisService axisService;
        Class pojoClass = Loader.loadClass((ClassLoader)classLoader, (String)className);
        try {
            axisService = DescriptionFactory.createAxisService((Class)pojoClass, (ConfigurationContext)this.configCtx);
        }
        catch (Throwable t) {
            log.info((Object)("Exception creating Axis Service : " + t.getCause()), t);
            return null;
        }
        if (axisService != null) {
            Iterator operations = axisService.getOperations();
            while (operations.hasNext()) {
                AxisOperation axisOperation = (AxisOperation)operations.next();
                if (axisOperation.getMessageReceiver() != null) continue;
                axisOperation.setMessageReceiver((MessageReceiver)new JAXWSMessageReceiver());
            }
            axisService.setElementFormDefault(false);
            axisService.setFileName(serviceLocation);
            axisService.setClassLoader(classLoader);
            axisService.addParameter(new Parameter("CACHE_CLASSLOADER", (Object)classLoader));
        }
        return axisService;
    }

    public void setDirectory(String directory) {
    }

    public void setExtension(String extension) {
    }

    public void unDeploy(String fileName) {
        if (JAXWSDeployer.isJar(new File(fileName = Utils.getShortFileName((String)fileName)))) {
            try {
                AxisServiceGroup serviceGroup = this.axisConfig.removeServiceGroup(fileName);
                if (this.configCtx != null) {
                    this.configCtx.removeServiceGroupContext(serviceGroup);
                }
                log.info((Object)Messages.getMessage((String)"serviceremoved", (String)fileName));
            }
            catch (AxisFault axisFault) {
                log.debug((Object)Messages.getMessage((String)"faultyserviceremoval", (String)axisFault.getMessage()), (Throwable)axisFault);
                this.axisConfig.removeFaultyService(fileName);
            }
        }
    }

    public static boolean isJar(File f) {
        try {
            JarInputStream jis = new JarInputStream(new FileInputStream(f));
            if (jis.getNextEntry() != null) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private boolean isEmpty(String string) {
        return string == null || "".equals(string);
    }

    private void configureAddressing(AxisServiceGroup serviceGroup) {
        EndpointContextMap map = (EndpointContextMap)this.configCtx.getProperty("org.apache.axis2.jaxws.addressing.util.EndpointContextMap");
        if (map == null) {
            map = EndpointContextMapManager.getEndpointContextMap();
            this.configCtx.setProperty("org.apache.axis2.jaxws.addressing.util.EndpointContextMap", (Object)map);
        }
        Iterator iterator = serviceGroup.getServices();
        while (iterator.hasNext()) {
            AxisService axisService = (AxisService)iterator.next();
            Parameter param = axisService.getParameter("org.apache.axis2.jaxws.description.EndpointDescription");
            EndpointDescription ed = (EndpointDescription)param.getValue();
            QName serviceName = ed.getServiceQName();
            QName portName = ed.getPortQName();
            EndpointKey key = new EndpointKey(serviceName, portName);
            map.put(key, axisService);
        }
    }
}

