/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.marshaller.impl.alt;

import java.beans.IntrospectionException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.ws.WebServiceException;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.description.FaultDescription;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.marshaller.impl.alt.MethodMarshallerUtils;
import org.apache.axis2.jaxws.runtime.description.marshal.FaultBeanDesc;
import org.apache.axis2.jaxws.runtime.description.marshal.MarshalServiceRuntimeDescription;
import org.apache.axis2.jaxws.utility.PropertyDescriptorPlus;
import org.apache.axis2.jaxws.wrapper.impl.JAXBWrapperToolImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LegacyExceptionUtil {
    private static Log log = LogFactory.getLog(LegacyExceptionUtil.class);
    private static Set<String> ignore = new HashSet<String>();

    private LegacyExceptionUtil() {
    }

    static Object createFaultBean(Throwable t, FaultDescription fd, MarshalServiceRuntimeDescription marshalDesc) throws WebServiceException {
        Object faultBean;
        block12: {
            faultBean = null;
            try {
                Class faultBeanClass;
                block11: {
                    FaultBeanDesc faultBeanDesc = marshalDesc.getFaultBeanDesc(fd);
                    String faultBeanName = faultBeanDesc.getFaultBeanClassName();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Legacy Exception FaultBean name is = " + faultBeanName));
                    }
                    faultBeanClass = null;
                    if (faultBeanName != null && faultBeanName.length() > 0) {
                        try {
                            try {
                                faultBeanClass = MethodMarshallerUtils.loadClass(faultBeanName);
                            }
                            catch (ClassNotFoundException e) {
                                faultBeanClass = MethodMarshallerUtils.loadClass(faultBeanName, fd.getOperationDescription().getEndpointInterfaceDescription().getEndpointDescription().getAxisService().getClassLoader());
                            }
                        }
                        catch (Throwable throwable) {
                            if (!log.isDebugEnabled()) break block11;
                            log.debug((Object)("Cannot load fault bean class = " + faultBeanName + ".  Fallback to using the exception object"));
                        }
                    }
                }
                if (faultBeanClass != null) {
                    Map<String, PropertyDescriptorPlus> pdMap = marshalDesc.getPropertyDescriptorMap(t.getClass());
                    Map<String, Object> childObjects = LegacyExceptionUtil.getChildObjectsMap(t, pdMap);
                    HashMap<String, Class> declaringClass = new HashMap<String, Class>();
                    ArrayList<String> childNames = new ArrayList<String>(childObjects.keySet());
                    if (log.isErrorEnabled()) {
                        log.debug((Object)("List of properties on the Legacy Exception is " + childNames));
                    }
                    JAXBWrapperToolImpl wrapperTool = new JAXBWrapperToolImpl();
                    Map<String, PropertyDescriptorPlus> pdMapForBean = marshalDesc.getPropertyDescriptorMap(faultBeanClass);
                    faultBean = wrapperTool.wrap(faultBeanClass, childNames, childObjects, declaringClass, pdMapForBean);
                    if (log.isErrorEnabled()) {
                        log.debug((Object)"Completed creation of the fault bean.");
                    }
                    break block12;
                }
                throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"faultProcessingNotSupported", (String)t.getClass().getName()));
            }
            catch (Exception e) {
                throw ExceptionFactory.makeWebServiceException((Throwable)e);
            }
        }
        return faultBean;
    }

    static Exception createFaultException(Class exceptionClass, Object jaxb, MarshalServiceRuntimeDescription marshalDesc) {
        Exception e = null;
        try {
            if (log.isErrorEnabled()) {
                log.debug((Object)("Create Legacy Exception for " + exceptionClass.getName()));
            }
            Map<String, PropertyDescriptorPlus> pdMap = marshalDesc.getPropertyDescriptorMap(exceptionClass);
            Iterator<Map.Entry<String, PropertyDescriptorPlus>> it = pdMap.entrySet().iterator();
            ArrayList<PropertyDescriptorPlus> piList = new ArrayList<PropertyDescriptorPlus>();
            while (it.hasNext()) {
                Map.Entry<String, PropertyDescriptorPlus> entry = it.next();
                String propertyName = entry.getValue().getPropertyName();
                if (ignore.contains(propertyName)) continue;
                piList.add(entry.getValue());
            }
            ArrayList<String> childNames = new ArrayList<String>();
            if (log.isErrorEnabled()) {
                log.debug((Object)("List of childNames on legacy exception is " + childNames));
            }
            Constructor constructor = LegacyExceptionUtil.findConstructor(exceptionClass, piList, childNames);
            if (log.isErrorEnabled()) {
                log.debug((Object)("The constructor used to create the exception is " + constructor));
            }
            JAXBWrapperToolImpl wrapperTool = new JAXBWrapperToolImpl();
            Map<String, PropertyDescriptorPlus> pdMapForBean = marshalDesc.getPropertyDescriptorMap(jaxb.getClass());
            Object[] childObjects = wrapperTool.unWrap(jaxb, childNames, pdMapForBean);
            if (log.isErrorEnabled()) {
                log.debug((Object)("Calling newInstance on the constructor " + constructor));
            }
            e = (Exception)constructor.newInstance(childObjects);
        }
        catch (Exception ex) {
            throw ExceptionFactory.makeWebServiceException((Throwable)ex);
        }
        return e;
    }

    private static Constructor findConstructor(Class cls, List<PropertyDescriptorPlus> pdList, List<String> childNames) {
        Constructor<?>[] constructors = cls.getConstructors();
        Constructor<?> constructor = null;
        if (constructors != null) {
            for (int i = 0; i < constructors.length && constructor == null; ++i) {
                int j;
                Constructor<?> tryConstructor = constructors[i];
                if (tryConstructor.getParameterTypes().length != pdList.size()) continue;
                ArrayList<PropertyDescriptorPlus> list = new ArrayList<PropertyDescriptorPlus>(pdList);
                ArrayList args = new ArrayList();
                Class<?>[] parms = tryConstructor.getParameterTypes();
                boolean valid = true;
                for (j = 0; j < list.size(); ++j) {
                    if (!"message".equals(((PropertyDescriptorPlus)list.get(j)).getPropertyName())) continue;
                    args.add(list.remove(j));
                }
                if (args.size() != 1 || !parms[0].isAssignableFrom(((PropertyDescriptorPlus)args.get(0)).getPropertyType())) {
                    valid = false;
                }
                for (j = 1; j < parms.length && valid; ++j) {
                    Class<?> parm = parms[j];
                    boolean found = false;
                    for (int k = 0; k < list.size() && !found; ++k) {
                        Class arg = ((PropertyDescriptorPlus)list.get(k)).getPropertyType();
                        if (!parm.isAssignableFrom(arg)) continue;
                        found = true;
                        args.add(list.remove(k));
                    }
                    if (found) continue;
                    valid = false;
                }
                if (!valid) continue;
                constructor = tryConstructor;
                for (int index = 0; index < args.size(); ++index) {
                    childNames.add(((PropertyDescriptorPlus)args.get(index)).getPropertyName());
                }
            }
        }
        return constructor;
    }

    private static Map<String, Object> getChildObjectsMap(Throwable t, Map<String, PropertyDescriptorPlus> pdMap) throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        HashMap<String, Object> coMap = new HashMap<String, Object>();
        for (Map.Entry<String, PropertyDescriptorPlus> entry : pdMap.entrySet()) {
            String propertyName = entry.getValue().getPropertyName();
            String xmlName = entry.getKey();
            if (ignore.contains(propertyName)) continue;
            Object value = entry.getValue().get(t);
            coMap.put(xmlName, value);
        }
        return coMap;
    }

    static {
        ignore.add("localizedMessage");
        ignore.add("stackTrace");
        ignore.add("class");
        ignore.add("cause");
    }
}

