/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.swing;

import de.hunsicker.jalopy.language.Type;
import de.hunsicker.swing.util.SwingHelper;
import de.hunsicker.util.ResourceBundleFactory;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

class TableList
extends JPanel {
    public static final int TYPE_ADD_REMOVE = 1;
    public static final int TYPE_UP_DOWN = 2;
    public static final int TYPE_BOTH = 3;
    static final String EMPTY_STRING = "".intern();
    private static final String BUNDLE_NAME = "de.hunsicker.jalopy.swing.Bundle";
    static final TableCellRenderer RENDERER_DEFAULT = new DefaultRenderer();
    static final TableCellRenderer RENDERER_NUMBER = new NumberRenderer();
    static final TableCellRenderer RENDERER_BOOLEAN = new BooleanRenderer();
    static final TableCellRenderer RENDERER_TYPE = new TypeRenderer();
    JButton addButton;
    JButton downButton;
    JButton removeButton;
    JButton upButton;
    DefaultTableModel _tableModel;
    private JScrollPane _scrollPane;
    JTable _table;
    private List _downContraints;
    private List _upConstraints;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$de$hunsicker$jalopy$language$Type;
    static /* synthetic */ Class class$java$lang$Boolean;

    public TableList(DefaultTableModel model, int type) {
        this._tableModel = model;
        this._table = new JTable(this._tableModel);
        this._table.getTableHeader().setResizingAllowed(false);
        this._table.getTableHeader().setReorderingAllowed(false);
        this._table.setSelectionMode(0);
        this._table.setCellSelectionEnabled(false);
        this._table.setColumnSelectionAllowed(false);
        this._table.setRowSelectionAllowed(true);
        this._table.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = TableList.class$("java.lang.Object")) : class$java$lang$Object, RENDERER_DEFAULT);
        this._table.setDefaultRenderer(class$java$lang$Number == null ? (class$java$lang$Number = TableList.class$("java.lang.Number")) : class$java$lang$Number, RENDERER_NUMBER);
        this._table.setDefaultRenderer(class$de$hunsicker$jalopy$language$Type == null ? (class$de$hunsicker$jalopy$language$Type = TableList.class$("de.hunsicker.jalopy.language.Type")) : class$de$hunsicker$jalopy$language$Type, RENDERER_TYPE);
        this._table.setDefaultRenderer(class$java$lang$Boolean == null ? (class$java$lang$Boolean = TableList.class$("java.lang.Boolean")) : class$java$lang$Boolean, RENDERER_BOOLEAN);
        this.initializeColumnSizes(this._table);
        this._scrollPane = new JScrollPane(this._table);
        this._scrollPane.getViewport().setBackground(UIManager.getColor("Table.background"));
        int height = SwingHelper.getTableHeight(this._table);
        this._scrollPane.setMinimumSize(new Dimension(300, height));
        this._scrollPane.setPreferredSize(new Dimension(300, height + 17));
        this._scrollPane.setMaximumSize(new Dimension(300, height + 17));
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        GridBagConstraints c = new GridBagConstraints();
        SwingHelper.setConstraints(c, 0, 0, 0, 1, 1.0, 1.0, 18, 1, c.insets, 0, 0);
        layout.setConstraints(this._scrollPane, c);
        this.add(this._scrollPane);
        switch (type) {
            case 1: {
                this.initializeAddRemove();
                break;
            }
            case 2: {
                this.initializeUpDown();
                break;
            }
            case 3: {
                this.initializeAddRemove();
                this.initializeUpDown();
            }
        }
    }

    public JButton getAddButton() {
        return this.addButton;
    }

    public JButton getDownButton() {
        return this.downButton;
    }

    public void setEnabled(boolean enable) {
        if (enable) {
            this._table.setEnabled(true);
            this.updateButtons(this._table.getRowCount(), this._table.getSelectedRow());
        } else {
            this._table.setEnabled(false);
            this.downButton.setEnabled(false);
            this.upButton.setEnabled(false);
        }
        super.setEnabled(enable);
    }

    public JButton getRemoveButton() {
        return this.removeButton;
    }

    public JTable getTable() {
        return this._table;
    }

    public JButton getUpButton() {
        return this.upButton;
    }

    public void addConstraint(Type first, Type second, int constraint) {
        if (constraint == 1) {
            if (this._upConstraints == null) {
                this._upConstraints = new ArrayList(3);
            }
            this._upConstraints.add(new Constraint(first, second, constraint));
        } else {
            if (this._downContraints == null) {
                this._downContraints = new ArrayList(3);
            }
            this._downContraints.add(new Constraint(first, second, constraint));
        }
    }

    public void removeConstraint(Type first, Type second, int constraint) {
        if (constraint == 1) {
            if (this._upConstraints != null) {
                this._upConstraints.remove(new Constraint(first, second, constraint));
            }
        } else if (this._downContraints != null) {
            this._downContraints.remove(new Constraint(first, second, constraint));
        }
    }

    private void setState(JButton button, boolean state) {
        if (button != null) {
            button.setEnabled(state);
        }
    }

    private boolean checkHighConstraint(Type cur, Type prev) {
        if (this._upConstraints == null) {
            return true;
        }
        int i = 0;
        int size = this._upConstraints.size();
        while (i < size) {
            Constraint c = (Constraint)this._upConstraints.get(i);
            if (c.first == cur && c.second == prev) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean checkLowConstraint(Type cur, Type next) {
        if (this._downContraints == null) {
            return true;
        }
        int i = 0;
        int size = this._downContraints.size();
        while (i < size) {
            Constraint c = (Constraint)this._downContraints.get(i);
            if (c.first == cur && c.second == next) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void initializeAddRemove() {
        this.addButton = SwingHelper.createButton(ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("BTN_ADD"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TableList.this.removeButton.setEnabled(true);
                TableList.this._tableModel.addRow(new Object[1]);
                TableList.this._table.changeSelection(TableList.this._table.getRowCount() - 1, 0, false, false);
                TableList.this._table.editCellAt(TableList.this._table.getRowCount() - 1, 0);
                DefaultCellEditor editor = (DefaultCellEditor)TableList.this._table.getCellEditor(TableList.this._table.getRowCount() - 1, 0);
                Component comp = editor.getTableCellEditorComponent(TableList.this._table, EMPTY_STRING, true, TableList.this._table.getRowCount() - 1, 0);
                comp.requestFocus();
            }
        });
        this.removeButton = SwingHelper.createButton(ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("BTN_REMOVE"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int curRow;
                TableCellEditor editor = TableList.this._table.getCellEditor();
                if (editor != null) {
                    editor.cancelCellEditing();
                }
                if ((curRow = TableList.this._table.getSelectionModel().getMinSelectionIndex()) > -1) {
                    TableList.this._tableModel.removeRow(curRow);
                }
                if (TableList.this._tableModel.getRowCount() > 0) {
                    if (curRow == 0) {
                        TableList.this._table.changeSelection(0, 0, false, false);
                    } else {
                        TableList.this._table.changeSelection(curRow - 1, 0, false, false);
                    }
                    TableList.this.removeButton.requestFocus();
                } else {
                    TableList.this.removeButton.setEnabled(false);
                }
            }
        });
    }

    private void initializeColumnSizes(JTable table) {
        TableCellRenderer headerRenderer = table.getTableHeader().getDefaultRenderer();
        int i = 1;
        int size = table.getColumnModel().getColumnCount();
        while (i < size) {
            TableColumn column = table.getColumnModel().getColumn(i);
            Component comp = headerRenderer.getTableCellRendererComponent(null, column.getHeaderValue(), false, false, 0, 0);
            int headerWidth = comp.getPreferredSize().width;
            column.setPreferredWidth(headerWidth);
            ++i;
        }
    }

    private void initializeUpDown() {
        this.upButton = SwingHelper.createButton(ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("BTN_UP"));
        this.upButton.setEnabled(false);
        this.upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                int row = TableList.this._table.getSelectedRow();
                TableList.this._tableModel.moveRow(row, row, row - 1);
                TableList.this._table.changeSelection(row - 1, 0, false, false);
                if (row - 1 != 0) {
                    TableList.this.upButton.requestFocus();
                }
            }
        });
        this.downButton = SwingHelper.createButton(ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("BTN_DOWN"));
        this.downButton.setEnabled(false);
        this.downButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                int row = TableList.this._table.getSelectedRow();
                TableList.this._tableModel.moveRow(row, row, row + 1);
                TableList.this._table.changeSelection(row + 1, 0, false, false);
                if (row + 2 != TableList.this._table.getRowCount()) {
                    TableList.this.downButton.requestFocus();
                }
            }
        });
        this._table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent ev) {
                if (ev.getValueIsAdjusting()) {
                    return;
                }
                TableList.this.updateButtons(TableList.this._table.getRowCount(), TableList.this._table.getSelectedRow());
            }
        });
    }

    void updateButtons(int rows, int selectedRow) {
        Type next;
        Type cur;
        if (selectedRow == -1) {
            this.setState(this.removeButton, false);
            this.setState(this.upButton, false);
            this.setState(this.downButton, false);
        } else if (selectedRow == 0) {
            this.setState(this.removeButton, true);
            this.setState(this.downButton, rows > 1);
            this.setState(this.upButton, false);
        } else if (selectedRow == rows - 1) {
            this.setState(this.removeButton, true);
            this.setState(this.upButton, true);
            this.setState(this.downButton, false);
        } else {
            this.setState(this.removeButton, true);
            this.setState(this.upButton, true);
            this.setState(this.downButton, true);
        }
        if (this.upButton != null && this.upButton.isEnabled() && selectedRow != -1 && this._upConstraints != null) {
            Type prev = (Type)this._tableModel.getValueAt(selectedRow - 1, 0);
            Type cur2 = (Type)this._tableModel.getValueAt(selectedRow, 0);
            if (!this.checkHighConstraint(cur2, prev)) {
                this.upButton.setEnabled(false);
            }
        }
        if (this.downButton != null && this.downButton.isEnabled() && selectedRow != -1 && this._downContraints != null && !this.checkLowConstraint(cur = (Type)this._tableModel.getValueAt(selectedRow, 0), next = (Type)this._tableModel.getValueAt(selectedRow + 1, 0))) {
            this.downButton.setEnabled(false);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class TypeRenderer
    extends DefaultTableCellRenderer {
        private TypeRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (table.isEnabled()) {
                if (isSelected) {
                    super.setForeground(table.getSelectionForeground());
                    super.setBackground(table.getSelectionBackground());
                } else {
                    super.setForeground(table.getForeground());
                    super.setBackground(table.getBackground());
                }
            } else {
                super.setForeground(UIManager.getColor("textInactiveText"));
                super.setBackground(UIManager.getColor("Table.background"));
            }
            this.setFont(table.getFont());
            this.setValue(value);
            Color back = this.getBackground();
            boolean colorMatch = back != null && back.equals(table.getBackground()) && table.isOpaque();
            this.setOpaque(!colorMatch);
            return this;
        }
    }

    private static class NumberRenderer
    extends DefaultRenderer {
        public NumberRenderer() {
            this.setHorizontalAlignment(4);
        }
    }

    private static class GlassPane
    extends JComponent
    implements AWTEventListener {
        JComponent editor;
        TableList tableList;
        boolean empty;

        public GlassPane(TableList tableList, JComponent editor) {
            this.tableList = tableList;
            this.editor = editor;
        }

        public void addNotify() {
            super.addNotify();
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 56L);
        }

        public void eventDispatched(AWTEvent ev) {
            if (ev instanceof MouseEvent) {
                MouseEvent e = (MouseEvent)ev;
                e.consume();
            } else if (ev instanceof KeyEvent) {
                KeyEvent e = (KeyEvent)ev;
                switch (e.getKeyCode()) {
                    case 27: {
                        JTextField textField;
                        String value;
                        if (!this.empty || !(this.editor instanceof JTextField) || (value = (textField = (JTextField)this.editor).getText()).trim().length() != 0) break;
                        JTable table = this.tableList.getTable();
                        int row = table.getSelectionModel().getMinSelectionIndex();
                        ((DefaultTableModel)table.getModel()).removeRow(row);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeNotify() {
            try {
                Toolkit.getDefaultToolkit().removeAWTEventListener(this);
                Object var2_1 = null;
                super.removeNotify();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                super.removeNotify();
                throw throwable;
            }
        }
    }

    private static class DefaultRenderer
    extends DefaultTableCellRenderer {
        private DefaultRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (table.isEnabled()) {
                if (isSelected) {
                    super.setForeground(table.getSelectionForeground());
                    super.setBackground(table.getSelectionBackground());
                } else {
                    super.setForeground(table.getForeground());
                    super.setBackground(table.getBackground());
                }
            } else {
                super.setForeground(UIManager.getColor("textInactiveText"));
                super.setBackground(UIManager.getColor("Table.background"));
            }
            this.setFont(table.getFont());
            if (hasFocus && table.getCellSelectionEnabled()) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
                if (table.isCellEditable(row, column)) {
                    super.setForeground(UIManager.getColor("Table.focusCellForeground"));
                    super.setBackground(UIManager.getColor("Table.focusCellBackground"));
                }
            } else {
                this.setBorder(DefaultTableCellRenderer.noFocusBorder);
            }
            this.setValue(value);
            Color back = this.getBackground();
            boolean colorMatch = back != null && back.equals(table.getBackground()) && table.isOpaque();
            this.setOpaque(!colorMatch);
            return this;
        }
    }

    private static class BooleanRenderer
    extends JCheckBox
    implements TableCellRenderer {
        boolean disabled;

        public BooleanRenderer() {
            this.setHorizontalAlignment(0);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (table.isEnabled()) {
                if (isSelected) {
                    this.setForeground(table.getSelectionForeground());
                    super.setBackground(table.getSelectionBackground());
                } else {
                    this.setForeground(table.getForeground());
                    this.setBackground(table.getBackground());
                }
                if (!this.disabled && !this.isEnabled()) {
                    this.setEnabled(true);
                }
            } else if (this.isEnabled()) {
                this.setEnabled(false);
                this.setBackground(UIManager.getColor("Table.background"));
            }
            if (value == null) {
                this.setEnabled(false);
            }
            this.setSelected(value != null && (Boolean)value != false);
            return this;
        }
    }

    static class TableListCellEditor
    extends DefaultCellEditor {
        TableList tableList;

        public TableListCellEditor(TableList list, JCheckBox component) {
            super(component);
            this.initialize();
            this.tableList = list;
        }

        public TableListCellEditor(TableList list, JTextField component) {
            super(component);
            this.initialize();
            this.tableList = list;
        }

        public TableListCellEditor(TableList list, JComboBox component) {
            super(component);
            this.initialize();
            this.tableList = list;
        }

        private void initialize() {
            JComponent component = (JComponent)this.getComponent();
            FocusAdapter listener = new FocusAdapter(this, component){
                JDialog dialog;
                JFrame frame;
                GlassPane pane;
                Component glassPane;
                private final /* synthetic */ JComponent val$component;
                private final /* synthetic */ TableListCellEditor this$0;
                {
                    this.this$0 = this$0;
                    this.val$component = val$component;
                    this.glassPane = null;
                }

                public void focusGained(FocusEvent ev) {
                    JTextField textField;
                    String value;
                    Window window = SwingUtilities.windowForComponent(this.val$component);
                    if (window == null) {
                        return;
                    }
                    if (this.pane == null) {
                        this.pane = new GlassPane(this.this$0.tableList, this.val$component);
                    }
                    this.pane.empty = this.val$component instanceof JTextField ? (value = (textField = (JTextField)this.val$component).getText()).trim().length() == 0 : false;
                    if (window instanceof JFrame) {
                        this.frame = (JFrame)window;
                        this.glassPane = this.frame.getGlassPane();
                        this.frame.setGlassPane(this.pane);
                        this.pane.setVisible(true);
                    } else if (window instanceof JDialog) {
                        this.dialog = (JDialog)window;
                        this.glassPane = this.dialog.getGlassPane();
                        this.dialog.setGlassPane(this.pane);
                        this.pane.setVisible(true);
                    }
                }

                public void focusLost(FocusEvent ev) {
                    this.pane.setVisible(false);
                    if (this.frame != null) {
                        this.frame.setGlassPane(this.glassPane);
                        this.frame = null;
                    } else if (this.dialog != null) {
                        this.dialog.setGlassPane(this.glassPane);
                        this.dialog = null;
                    }
                    this.glassPane = null;
                }
            };
            component.addFocusListener(listener);
        }
    }

    static class Constraint {
        public static final int DOWN = 2;
        public static final int UP = 1;
        Type first;
        Type second;
        int constraint;

        public Constraint(Type first, Type second, int constraint) {
            this.first = first;
            this.second = second;
            this.constraint = constraint;
        }
    }
}

