/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering.tribes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.axis2.clustering.tribes.TribesUtil;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.group.ChannelInterceptorBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AtMostOnceInterceptor
extends ChannelInterceptorBase {
    private static Log log = LogFactory.getLog(AtMostOnceInterceptor.class);
    private static final Map<ChannelMessage, Long> receivedMessages = new HashMap<ChannelMessage, Long>();
    private static final int TIMEOUT = 300000;

    public AtMostOnceInterceptor() {
        Thread cleanupThread = new Thread(new MessageCleanupTask());
        cleanupThread.setPriority(1);
        cleanupThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(ChannelMessage msg) {
        if (this.okToProcess(msg.getOptions())) {
            Map<ChannelMessage, Long> map = receivedMessages;
            synchronized (map) {
                if (receivedMessages.get(msg) == null) {
                    receivedMessages.put(msg, System.currentTimeMillis());
                    super.messageReceived(msg);
                } else {
                    log.info((Object)("Duplicate message received from " + TribesUtil.getName(msg.getAddress())));
                }
            }
        } else {
            super.messageReceived(msg);
        }
    }

    private class MessageCleanupTask
    implements Runnable {
        private MessageCleanupTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    Thread.sleep(300000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                try {
                    ArrayList<ChannelMessage> toBeRemoved = new ArrayList<ChannelMessage>();
                    Thread.yield();
                    Map map = receivedMessages;
                    synchronized (map) {
                        for (ChannelMessage msg : receivedMessages.keySet()) {
                            long arrivalTime = (Long)receivedMessages.get(msg);
                            if (System.currentTimeMillis() - arrivalTime < 300000L) continue;
                            toBeRemoved.add(msg);
                            if (toBeRemoved.size() <= 10000) continue;
                            break;
                        }
                        for (ChannelMessage msg : toBeRemoved) {
                            receivedMessages.remove(msg);
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)"Cleaned up message ");
                        }
                        continue;
                    }
                }
                catch (Throwable e) {
                    log.error((Object)"Exception occurred while trying to cleanup messages", e);
                    continue;
                }
                break;
            }
        }
    }
}

