/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataHandler;
import javax.mail.MessagingException;
import org.apache.axiom.attachments.impl.BufferUtils;
import org.apache.axiom.attachments.lifecycle.LifecycleManager;
import org.apache.axiom.attachments.lifecycle.impl.FileAccessor;
import org.apache.axiom.attachments.lifecycle.impl.LifecycleManagerImpl;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.util.Base64;

public class TextHelper {
    private static int DEFAULT_FILE_THRESHOLD = 102400;
    private static String DEFAULT_ATTACHMENT_DIR = "axiomTmp";
    private static int DELETE_TIME = 3600;

    public static String toString(InputStream inStream) throws IOException {
        StringBuffer buffer = new StringBuffer();
        TextHelper.toStringBuffer(inStream, buffer);
        return buffer.toString();
    }

    public static void toStringBuffer(InputStream inStream, StringBuffer buffer) throws IOException {
        int avail = inStream.available();
        if (avail > 0) {
            buffer.ensureCapacity((int)((double)avail * 1.35) + buffer.length());
        }
        byte[] data = new byte[1023];
        boolean eos = false;
        do {
            int read;
            int len = 0;
            do {
                if ((read = inStream.read(data, len, data.length - len)) != -1) continue;
                eos = true;
                break;
            } while ((len += read) < data.length);
            Base64.encode(data, 0, len, buffer);
        } while (!eos);
    }

    public static void toStringBuffer(OMText omText, StringBuffer buffer) throws IOException {
        InputStream is;
        Object dh;
        if (omText.isOptimized() && (dh = omText.getDataHandler()) instanceof DataHandler && (is = ((DataHandler)dh).getInputStream()) != null) {
            TextHelper.toStringBuffer(is, buffer);
            return;
        }
        buffer.append(omText.getText());
    }

    public static OMText toOMText(byte[] b, int off, int length, OMFactory factory, boolean isOptimize) throws IOException, MessagingException {
        String attachmentDir = TextHelper.getAttachmentDir(factory);
        return TextHelper.toOMText(b, off, length, factory, isOptimize, attachmentDir);
    }

    public static OMText toOMText(byte[] b, int off, int length, OMFactory factory, boolean isOptimize, String attachmentDir) throws IOException, MessagingException {
        OMText omText = null;
        if (isOptimize) {
            LifecycleManager lm = TextHelper.getLifecycleManager(factory);
            int threshold = TextHelper.getThreshold(factory);
            if (length >= threshold && attachmentDir != null) {
                FileAccessor fileAccessor = lm.create(attachmentDir);
                OutputStream fos = fileAccessor.getOutputStream();
                ByteArrayInputStream is = new ByteArrayInputStream(b, off, length);
                BufferUtils.inputStream2OutputStream(is, fos);
                fos.close();
                lm.deleteOnExit(fileAccessor.getFile());
                lm.deleteOnTimeInterval(DELETE_TIME, fileAccessor.getFile());
                DataHandler dh = fileAccessor.getDataHandler(null);
                omText = factory.createOMText(dh, isOptimize);
            }
        }
        if (omText == null) {
            omText = factory.createOMText(Base64.encode(b, off, length));
            omText.setOptimize(isOptimize);
        }
        return omText;
    }

    private static LifecycleManager getLifecycleManager(OMFactory factory) {
        LifecycleManager lm = null;
        if (lm == null) {
            return new LifecycleManagerImpl();
        }
        return lm;
    }

    private static int getThreshold(OMFactory factory) {
        int threshold = DEFAULT_FILE_THRESHOLD;
        return threshold;
    }

    private static String getAttachmentDir(OMFactory factory) {
        String attachmentDir = DEFAULT_ATTACHMENT_DIR;
        return attachmentDir;
    }
}

