/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http.util;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;

public class URIEncoderDecoder {
    static final String digits = "0123456789ABCDEF";
    static final String encoding = "UTF8";

    static void validate(String s, String legal) throws URISyntaxException {
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            if (ch == '%') {
                do {
                    if (i + 2 >= s.length()) {
                        throw new URISyntaxException(s, "Incomplete % sequence");
                    }
                    int d1 = Character.digit(s.charAt(i + 1), 16);
                    int d2 = Character.digit(s.charAt(i + 2), 16);
                    if (d1 != -1 && d2 != -1) continue;
                    throw new URISyntaxException(s, "Invalid % sequence " + s.substring(i, i + 3), i);
                } while ((i += 3) < s.length() && s.charAt(i) == '%');
                continue;
            }
            if (!(ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || legal.indexOf(ch) > -1 || ch > '\u007f' && !Character.isSpaceChar(ch) && !Character.isISOControl(ch))) {
                throw new URISyntaxException(s, "Illegal character", i);
            }
            ++i;
        }
    }

    static void validateSimple(String s, String legal) throws URISyntaxException {
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || legal.indexOf(ch) > -1) continue;
            throw new URISyntaxException(s, "Illegal character", i);
        }
    }

    public static String quoteIllegal(String s, String legal) throws UnsupportedEncodingException {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || legal.indexOf(ch) > -1) {
                buf.append(ch);
                continue;
            }
            byte[] bytes = new String(new char[]{ch}).getBytes(encoding);
            for (int j = 0; j < bytes.length; ++j) {
                buf.append('%');
                buf.append(digits.charAt((bytes[j] & 0xF0) >> 4));
                buf.append(digits.charAt(bytes[j] & 0xF));
            }
        }
        return buf.toString();
    }

    static String encodeOthers(String s) throws UnsupportedEncodingException {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch <= '\u007f') {
                buf.append(ch);
                continue;
            }
            byte[] bytes = new String(new char[]{ch}).getBytes(encoding);
            for (int j = 0; j < bytes.length; ++j) {
                buf.append('%');
                buf.append(digits.charAt((bytes[j] & 0xF0) >> 4));
                buf.append(digits.charAt(bytes[j] & 0xF));
            }
        }
        return buf.toString();
    }

    public static String decode(String s) throws UnsupportedEncodingException {
        StringBuffer result = new StringBuffer();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '%') {
                out.reset();
                do {
                    if (i + 2 >= s.length()) {
                        throw new IllegalArgumentException("Incomplete % sequence at " + i);
                    }
                    int d1 = Character.digit(s.charAt(i + 1), 16);
                    int d2 = Character.digit(s.charAt(i + 2), 16);
                    if (d1 == -1 || d2 == -1) {
                        throw new IllegalArgumentException("Invalid % sequence" + s.substring(i, i + 3) + "at " + String.valueOf(i));
                    }
                    out.write((byte)((d1 << 4) + d2));
                } while ((i += 3) < s.length() && s.charAt(i) == '%');
                result.append(out.toString(encoding));
                continue;
            }
            result.append(c);
            ++i;
        }
        return result.toString();
    }
}

