/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.vote;

import java.util.Iterator;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.Authentication;
import org.acegisecurity.ConfigAttributeDefinition;
import org.acegisecurity.vote.AbstractAccessDecisionManager;
import org.acegisecurity.vote.AccessDecisionVoter;

public class ConsensusBased
extends AbstractAccessDecisionManager {
    private boolean allowIfEqualGrantedDeniedDecisions = true;

    public void decide(Authentication authentication, Object object, ConfigAttributeDefinition config) throws AccessDeniedException {
        Iterator iter = this.getDecisionVoters().iterator();
        int grant = 0;
        int deny = 0;
        int abstain = 0;
        block4: while (iter.hasNext()) {
            AccessDecisionVoter voter = (AccessDecisionVoter)iter.next();
            int result = voter.vote(authentication, object, config);
            switch (result) {
                case 1: {
                    ++grant;
                    continue block4;
                }
                case -1: {
                    ++deny;
                    continue block4;
                }
            }
            ++abstain;
        }
        if (grant > deny) {
            return;
        }
        if (deny > grant) {
            throw new AccessDeniedException(this.messages.getMessage("AbstractAccessDecisionManager.accessDenied", "Access is denied"));
        }
        if (grant == deny && grant != 0) {
            if (this.allowIfEqualGrantedDeniedDecisions) {
                return;
            }
            throw new AccessDeniedException(this.messages.getMessage("AbstractAccessDecisionManager.accessDenied", "Access is denied"));
        }
        this.checkAllowIfAllAbstainDecisions();
    }

    public boolean isAllowIfEqualGrantedDeniedDecisions() {
        return this.allowIfEqualGrantedDeniedDecisions;
    }

    public void setAllowIfEqualGrantedDeniedDecisions(boolean allowIfEqualGrantedDeniedDecisions) {
        this.allowIfEqualGrantedDeniedDecisions = allowIfEqualGrantedDeniedDecisions;
    }
}

