/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.config.ConfigUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class AuthenticationManagerBeanDefinitionParser
implements BeanDefinitionParser {
    private static final String ATT_SESSION_CONTROLLER_REF = "session-controller-ref";
    private static final String ATT_ALIAS = "alias";
    static /* synthetic */ Class class$org$springframework$security$config$SessionRegistryInjectionBeanPostProcessor;

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        String sessionControllerRef;
        BeanDefinition authManager = ConfigUtils.registerProviderManagerIfNecessary(parserContext);
        String alias = element.getAttribute(ATT_ALIAS);
        if (!StringUtils.hasText((String)alias)) {
            parserContext.getReaderContext().error("alias is required.", (Object)element);
        }
        if (StringUtils.hasText((String)(sessionControllerRef = element.getAttribute(ATT_SESSION_CONTROLLER_REF)))) {
            ConfigUtils.setSessionControllerOnAuthenticationManager(parserContext, "_concurrentSessionController", element);
            authManager.getPropertyValues().addPropertyValue("sessionController", (Object)new RuntimeBeanReference(sessionControllerRef));
            RootBeanDefinition sessionRegistryInjector = new RootBeanDefinition(class$org$springframework$security$config$SessionRegistryInjectionBeanPostProcessor == null ? (class$org$springframework$security$config$SessionRegistryInjectionBeanPostProcessor = AuthenticationManagerBeanDefinitionParser.class$("org.springframework.security.config.SessionRegistryInjectionBeanPostProcessor")) : class$org$springframework$security$config$SessionRegistryInjectionBeanPostProcessor);
            sessionRegistryInjector.setRole(2);
            sessionRegistryInjector.getConstructorArgumentValues().addGenericArgumentValue((Object)sessionControllerRef);
            parserContext.getRegistry().registerBeanDefinition("_sessionRegistryInjectionPostProcessor", (BeanDefinition)sessionRegistryInjector);
        }
        parserContext.getRegistry().registerAlias("_authenticationManager", alias);
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

