/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import antlr.collections.AST;
import de.hunsicker.jalopy.language.antlr.JavaNode;
import de.hunsicker.jalopy.printer.BlockPrinter;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.printer.PrinterFactory;
import java.io.IOException;

final class CaseBlockPrinter
extends BlockPrinter {
    private static final Printer INSTANCE = new CaseBlockPrinter();

    protected CaseBlockPrinter() {
    }

    public static final Printer getInstance() {
        return INSTANCE;
    }

    public void print(AST node, NodeWriter out) throws IOException {
        boolean indent = false;
        JavaNode first = (JavaNode)node.getFirstChild();
        if (first != null) {
            switch (first.getType()) {
                case 12: {
                    break;
                }
                default: {
                    indent = true;
                    break;
                }
            }
        } else {
            out.printNewline();
        }
        if (indent) {
            out.indent();
        }
        AST child = first;
        while (child != null) {
            PrinterFactory.create(child, out).print(child, out);
            child = child.getNextSibling();
        }
        if (indent) {
            out.unindent();
        }
        out.last = 8;
    }
}

