/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.net.messaging;

import com.icesoft.faces.webapp.http.common.Configuration;
import com.icesoft.net.messaging.MessagePublisher;
import com.icesoft.net.messaging.MessageServiceClient;
import com.icesoft.net.messaging.MessageServiceException;
import com.icesoft.net.messaging.NoopMessagePublisher;
import com.icesoft.net.messaging.QueueMessagePublisher;
import com.icesoft.util.Properties;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledFuture;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultMessageService
implements MessageServiceClient.Administrator {
    private static final Log LOG = LogFactory.getLog((Class)DefaultMessageService.class);
    private static final int STATE_UNINITIALIZED = 0;
    private static final int STATE_SET_UP = 1;
    private static final int STATE_SET_UP_DONE = 2;
    private static final int STATE_STARTED = 3;
    private static final int STATE_STOPPED = 4;
    private static final int STATE_TEAR_DOWN = 5;
    private static final int STATE_TEAR_DOWN_DONE = 6;
    private static final int STATE_CLOSED = 7;
    private static final int DEFAULT_INTERVAL = 10000;
    private static final int DEFAULT_MAX_RETRIES = 30;
    private static final int DEFAULT_INTERVAL_ON_RECONNECT = 5000;
    private static final int DEFAULT_MAX_RETRIES_ON_RECONNECT = 60;
    private final Object reconnectLock = new Object();
    private final Object stateLock = new Object();
    private final Configuration configuration;
    private final MessageServiceClient messageServiceClient;
    private final boolean retryOnFail;
    private final ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    private MessagePublisher currentMessagePublisher;
    private long successTimestamp;
    private int currentState = 0;
    private int requestedState = 0;

    public DefaultMessageService(MessageServiceClient messageServiceClient, ScheduledThreadPoolExecutor scheduledThreadPoolExecutor) throws IllegalArgumentException {
        this(messageServiceClient, scheduledThreadPoolExecutor, null, false);
    }

    public DefaultMessageService(MessageServiceClient messageServiceClient, ScheduledThreadPoolExecutor scheduledThreadPoolExecutor, boolean retryOnFail) throws IllegalArgumentException {
        this(messageServiceClient, scheduledThreadPoolExecutor, null, retryOnFail);
    }

    public DefaultMessageService(MessageServiceClient messageServiceClient, ScheduledThreadPoolExecutor scheduledThreadPoolExecutor, Configuration configuration) throws IllegalArgumentException {
        this(messageServiceClient, scheduledThreadPoolExecutor, configuration, false);
    }

    public DefaultMessageService(MessageServiceClient messageServiceClient, ScheduledThreadPoolExecutor scheduledThreadPoolExecutor, Configuration configuration, boolean retryOnFail) throws IllegalArgumentException {
        if (messageServiceClient == null) {
            throw new IllegalArgumentException("messageServiceClient is null");
        }
        if (scheduledThreadPoolExecutor == null) {
            throw new IllegalArgumentException("scheduledThreadPoolExecutor is null");
        }
        this.messageServiceClient = messageServiceClient;
        this.messageServiceClient.setAdministrator(this);
        this.scheduledThreadPoolExecutor = scheduledThreadPoolExecutor;
        this.configuration = configuration;
        this.retryOnFail = retryOnFail;
        this.currentMessagePublisher = new QueueMessagePublisher(this, messageServiceClient, scheduledThreadPoolExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        Object object = this.stateLock;
        synchronized (object) {
            block8: {
                this.requestedState = 7;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Requested State: CLOSED");
                }
                if (this.currentState == 6) {
                    try {
                        this.messageServiceClient.close();
                        this.currentState = 7;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Current State: CLOSED");
                        }
                    }
                    catch (MessageServiceException exception) {
                        if (!LOG.isErrorEnabled()) break block8;
                        LOG.error((Object)"Failed to close the message service client.", (Throwable)exception);
                    }
                }
            }
        }
    }

    public MessageServiceClient getMessageServiceClient() {
        return this.messageServiceClient;
    }

    public final void publish(Serializable object, Properties messageProperties, String topicName) {
        this.currentMessagePublisher.publish(object, messageProperties, topicName);
    }

    public final void publish(Serializable object, Properties messageProperties, String messageType, String topicName) {
        this.currentMessagePublisher.publish(object, messageProperties, messageType, topicName);
    }

    public final void publish(Serializable object, String topicName) {
        this.currentMessagePublisher.publish(object, topicName);
    }

    public final void publish(Serializable object, String messageType, String topicName) {
        this.currentMessagePublisher.publish(object, messageType, topicName);
    }

    public final void publish(String text, Properties messageProperties, String topicName) {
        this.currentMessagePublisher.publish(text, messageProperties, topicName);
    }

    public final void publish(String text, Properties messageProperties, String messageType, String topicName) {
        this.currentMessagePublisher.publish(text, messageProperties, messageType, topicName);
    }

    public final void publish(String text, String topicName) {
        this.currentMessagePublisher.publish(text, topicName);
    }

    public final void publish(String text, String messageType, String topicName) {
        this.currentMessagePublisher.publish(text, messageType, topicName);
    }

    public final void publishNow(Serializable object, Properties messageProperties, String topicName) {
        this.currentMessagePublisher.publishNow(object, messageProperties, topicName);
    }

    public final void publishNow(Serializable object, Properties messageProperties, String messageType, String topicName) {
        this.currentMessagePublisher.publishNow(object, messageProperties, messageType, topicName);
    }

    public final void publishNow(Serializable object, String topicName) {
        this.currentMessagePublisher.publishNow(object, topicName);
    }

    public final void publishNow(Serializable object, String messageType, String topicName) {
        this.currentMessagePublisher.publishNow(object, messageType, topicName);
    }

    public final void publishNow(String text, Properties messageProperties, String topicName) {
        this.currentMessagePublisher.publishNow(text, messageProperties, topicName);
    }

    public final void publishNow(String text, Properties messageProperties, String messageType, String topicName) {
        this.currentMessagePublisher.publishNow(text, messageProperties, messageType, topicName);
    }

    public final void publishNow(String text, String topicName) {
        this.currentMessagePublisher.publishNow(text, topicName);
    }

    public final void publishNow(String text, String messageType, String topicName) {
        this.currentMessagePublisher.publishNow(text, messageType, topicName);
    }

    public final void reconnect() {
        LOG.debug((Object)"Reconnecting...");
        if (this.scheduledThreadPoolExecutor == null) {
            this.reconnectNow();
        } else {
            new ReconnectTask().execute();
        }
    }

    public final boolean reconnectNow() {
        LOG.debug((Object)"Reconnecting now...");
        return new ReconnectTask().executeNow();
    }

    public final void setUp() {
        LOG.debug((Object)"Setting up...");
        this.setUp(!this.retryOnFail ? 0 : this.configuration.getAttributeAsInteger("interval", 10000), !this.retryOnFail ? 0 : this.configuration.getAttributeAsInteger("maxRetries", 30));
    }

    public final boolean setUpNow() {
        LOG.debug((Object)"Setting up now...");
        return this.setUpNow(!this.retryOnFail ? 0 : this.configuration.getAttributeAsInteger("interval", 10000), !this.retryOnFail ? 0 : this.configuration.getAttributeAsInteger("maxRetries", 30));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        Object object = this.stateLock;
        synchronized (object) {
            block8: {
                this.requestedState = 3;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Requested State: STARTED");
                }
                if (this.currentState == 2) {
                    try {
                        this.messageServiceClient.start();
                        this.currentState = 3;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Current State: STARTED");
                        }
                    }
                    catch (MessageServiceException exception) {
                        if (!LOG.isFatalEnabled()) break block8;
                        LOG.fatal((Object)"Failed to start message delivery!", (Throwable)exception);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        Object object = this.stateLock;
        synchronized (object) {
            block8: {
                this.requestedState = 4;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Requested State: STOPPED");
                }
                if (this.currentState == 3) {
                    try {
                        this.messageServiceClient.stop();
                        this.currentState = 4;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Current State: STOPPED");
                        }
                    }
                    catch (MessageServiceException exception) {
                        if (!LOG.isFatalEnabled()) break block8;
                        LOG.fatal((Object)"Failed to stop message delivery!", (Throwable)exception);
                    }
                }
            }
        }
    }

    public final void tearDown() {
        LOG.debug((Object)"Tearing down...");
        if (this.scheduledThreadPoolExecutor == null) {
            this.tearDownNow();
        } else {
            new TearDownTask(this.scheduledThreadPoolExecutor).execute();
        }
    }

    public final boolean tearDownNow() {
        LOG.debug((Object)"Tearing down now...");
        return new TearDownTask().executeNow();
    }

    protected void setUpMessageServiceClient() throws MessageServiceException {
    }

    protected void tearDownMessageServiceClient() throws MessageServiceException {
    }

    private void setUp(int interval, int maxRetries) {
        LOG.debug((Object)("Setting up... (interval: [" + interval + "], maxRetries: [" + maxRetries + "])"));
        if (this.scheduledThreadPoolExecutor == null) {
            this.setUpNow(interval, maxRetries);
        } else {
            new SetUpTask(interval, maxRetries, this.scheduledThreadPoolExecutor).execute();
        }
    }

    private boolean setUpNow(int interval, int maxRetries) {
        LOG.debug((Object)("Setting up now... (interval: [" + interval + "], maxRetries: [" + maxRetries + "])"));
        return new SetUpTask(interval, maxRetries).executeNow();
    }

    private class TearDownTask
    implements Runnable {
        private final ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
        private ScheduledFuture scheduledFuture;
        private boolean succeeded = false;

        private TearDownTask() {
            this((ScheduledThreadPoolExecutor)null);
        }

        private TearDownTask(ScheduledThreadPoolExecutor scheduledThreadPoolExecutor) {
            this.scheduledThreadPoolExecutor = scheduledThreadPoolExecutor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block8: {
                LOG.debug((Object)"Executing Tear Down task...");
                try {
                    DefaultMessageService.this.tearDownMessageServiceClient();
                    if (this.scheduledFuture != null) {
                        this.scheduledFuture.cancel(false);
                        this.scheduledFuture = null;
                    }
                    this.succeeded = true;
                    Object object = DefaultMessageService.this.stateLock;
                    synchronized (object) {
                        DefaultMessageService.this.currentState = 6;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Current State: TEAR DOWN DONE");
                        }
                        if (DefaultMessageService.this.requestedState == 7) {
                            DefaultMessageService.this.close();
                        }
                    }
                }
                catch (Exception exception) {
                    if (this.scheduledFuture == null) break block8;
                    this.scheduledFuture.cancel(false);
                    this.scheduledFuture = null;
                }
            }
            LOG.debug((Object)("Executing Tear Down task... (succeeded: [" + this.succeeded + "])"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void execute() {
            Object object = DefaultMessageService.this.stateLock;
            synchronized (object) {
                DefaultMessageService.this.currentState = 5;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Current State: TEAR DOWN");
                }
            }
            if (this.scheduledThreadPoolExecutor != null) {
                this.scheduledFuture = this.scheduledThreadPoolExecutor.schedule((Runnable)this, 0L, TimeUnit.MILLISECONDS);
            } else {
                this.executeNow();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean executeNow() {
            Object object = DefaultMessageService.this.stateLock;
            synchronized (object) {
                DefaultMessageService.this.currentState = 5;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Current State: TEAR DOWN");
                }
            }
            this.run();
            return this.succeeded;
        }
    }

    private class SetUpTask
    implements Runnable {
        private final int interval;
        private final int maxRetries;
        private final ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
        private ScheduledFuture scheduledFuture;
        private boolean cancelled = false;
        private int retries = 0;
        private boolean succeeded = false;

        private SetUpTask(int interval, int maxRetries) {
            this(interval, maxRetries, (ScheduledThreadPoolExecutor)null);
        }

        private SetUpTask(int interval, int maxRetries, ScheduledThreadPoolExecutor scheduledThreadPoolExecutor) {
            this.interval = interval;
            this.maxRetries = maxRetries;
            this.scheduledThreadPoolExecutor = scheduledThreadPoolExecutor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block9: {
                LOG.debug((Object)"Executing Set Up task...");
                try {
                    DefaultMessageService.this.setUpMessageServiceClient();
                    if (this.scheduledFuture != null) {
                        this.scheduledFuture.cancel(false);
                        this.scheduledFuture = null;
                    }
                    this.cancelled = true;
                    this.succeeded = true;
                    Object object = DefaultMessageService.this.stateLock;
                    synchronized (object) {
                        DefaultMessageService.this.currentState = 2;
                        if (LOG.isInfoEnabled()) {
                            LOG.debug((Object)"Current State: SET UP DONE");
                        }
                        if (DefaultMessageService.this.requestedState == 3) {
                            DefaultMessageService.this.start();
                        }
                    }
                }
                catch (Exception exception) {
                    LOG.debug((Object)("Exception: " + exception.getClass().getName() + ": " + exception.getMessage()));
                    DefaultMessageService.this.tearDownNow();
                    if (this.retries++ != this.maxRetries) break block9;
                    if (this.scheduledFuture != null) {
                        this.scheduledFuture.cancel(false);
                        this.scheduledFuture = null;
                    }
                    this.cancelled = true;
                    DefaultMessageService.this.currentMessagePublisher.stop();
                    DefaultMessageService.this.currentMessagePublisher = new NoopMessagePublisher();
                    if (!LOG.isDebugEnabled()) break block9;
                    LOG.debug((Object)("Set up of the message service client failed: " + exception.getMessage()));
                }
            }
            LOG.debug((Object)("Executing Set Up task... (succeeded: [" + this.succeeded + "])"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void execute() {
            Object object = DefaultMessageService.this.stateLock;
            synchronized (object) {
                DefaultMessageService.this.currentState = 1;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Current State: SET UP");
                }
            }
            if (this.scheduledThreadPoolExecutor != null) {
                this.scheduledFuture = this.scheduledThreadPoolExecutor.scheduleAtFixedRate((Runnable)this, 0L, (long)this.interval, TimeUnit.MILLISECONDS);
            } else {
                this.executeNow();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean executeNow() {
            Object object = DefaultMessageService.this.stateLock;
            synchronized (object) {
                DefaultMessageService.this.currentState = 1;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Current State: SET UP");
                }
            }
            while (!this.cancelled) {
                this.run();
                if (this.cancelled) continue;
                try {
                    Thread.sleep(this.interval);
                }
                catch (InterruptedException interruptedException) {}
            }
            return this.succeeded;
        }
    }

    private class ReconnectTask
    implements Runnable {
        private final ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
        private ScheduledFuture scheduledFuture;
        private boolean succeeded = false;

        private ReconnectTask() {
            this((ScheduledThreadPoolExecutor)null);
        }

        private ReconnectTask(ScheduledThreadPoolExecutor scheduledThreadPoolExecutor) {
            this.scheduledThreadPoolExecutor = scheduledThreadPoolExecutor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LOG.debug((Object)"Executing Reconnect task...");
            long _failTimestamp = System.currentTimeMillis();
            Object object = DefaultMessageService.this.reconnectLock;
            synchronized (object) {
                if (_failTimestamp > DefaultMessageService.this.successTimestamp + 5000L) {
                    DefaultMessageService.this.tearDownNow();
                    if (DefaultMessageService.this.setUpNow(!DefaultMessageService.this.retryOnFail ? 0 : DefaultMessageService.this.configuration.getAttributeAsInteger("intervalOnReconnect", 5000), !DefaultMessageService.this.retryOnFail ? 0 : DefaultMessageService.this.configuration.getAttributeAsInteger("maxRetriesOnReconnect", 60))) {
                        DefaultMessageService.this.successTimestamp = System.currentTimeMillis();
                        this.succeeded = true;
                    }
                } else {
                    this.succeeded = true;
                }
            }
            if (this.scheduledFuture != null) {
                this.scheduledFuture.cancel(false);
                this.scheduledFuture = null;
            }
            LOG.debug((Object)("Executing Reconnect task... (succeeded: [" + this.succeeded + "])"));
        }

        private void execute() {
            if (this.scheduledThreadPoolExecutor != null) {
                this.scheduledFuture = this.scheduledThreadPoolExecutor.schedule((Runnable)this, 0L, TimeUnit.MILLISECONDS);
            } else {
                this.executeNow();
            }
        }

        private boolean executeNow() {
            this.run();
            return this.succeeded;
        }
    }
}

