/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.application;

import com.icesoft.faces.context.BridgeFacesContext;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.faces.application.StateManager;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ViewRootStateManagerImpl
extends StateManager {
    protected static Log log = LogFactory.getLog((Class)ViewRootStateManagerImpl.class);
    protected StateManager delegate;
    protected boolean parametersInitialized;
    protected boolean pureDelegation;
    protected Method v2DelegateSaveViewMethod;
    final String VIEW_STATE_PARAM = "javax.faces.ViewState";
    final char[] STATE_FIELD_START = "<input type=\"hidden\" name=\"javax.faces.ViewState\" id=\"javax.faces.ViewState\" value=\"".toCharArray();
    final char[] STATE_FIELD_END = "\" />".toCharArray();
    static /* synthetic */ Class class$com$icesoft$faces$application$SingleCopyStateManagerImpl;

    public ViewRootStateManagerImpl(StateManager delegate) {
        if (log.isInfoEnabled()) {
            log.info((Object)("ViewRootStateManagerImpl constructed with Delegate: " + delegate));
        }
        this.delegate = delegate;
    }

    public UIViewRoot restoreView(FacesContext context, String viewId, String renderKitId) {
        UIViewRoot root;
        Map sessionMap;
        HashMap stateMap;
        this.initializeParameters(context);
        if (this.pureDelegation || !(context instanceof BridgeFacesContext)) {
            return this.delegate.restoreView(context, viewId, renderKitId);
        }
        BridgeFacesContext bfc = (BridgeFacesContext)context;
        String viewNumber = bfc.getViewNumber();
        if (log.isDebugEnabled()) {
            log.debug((Object)("RestoreView called for View: " + bfc.getIceFacesId() + ", viewNumber: " + viewNumber));
        }
        if ((stateMap = (HashMap)(sessionMap = bfc.getExternalContext().getSessionMap()).get("icefaces.state.maps")) == null) {
            stateMap = new HashMap();
            sessionMap.put("icefaces.state.maps", stateMap);
        }
        if ((root = (UIViewRoot)stateMap.get(viewNumber)) == null) {
            log.error((Object)("Missing ViewRoot in restoreState, ice.session: " + bfc.getIceFacesId() + ", viewNumber: " + viewNumber));
            return null;
        }
        return root;
    }

    private void initializeParameters(FacesContext context) {
        if (this.parametersInitialized) {
            return;
        }
        StackTraceElement[] ste = new RuntimeException().getStackTrace();
        boolean external = false;
        for (int i = 0; i < ste.length; ++i) {
            String className = ste[i].getClassName();
            if (className.equals(((Object)((Object)this)).getClass().getName()) || className.equals((class$com$icesoft$faces$application$SingleCopyStateManagerImpl == null ? ViewRootStateManagerImpl.class$("com.icesoft.faces.application.SingleCopyStateManagerImpl") : class$com$icesoft$faces$application$SingleCopyStateManagerImpl).getName())) {
                if (!external) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Pure delegate role taken by ViewRootStateSavingImpl");
                }
                this.pureDelegation = true;
                break;
            }
            external = true;
        }
        try {
            this.v2DelegateSaveViewMethod = this.delegate.getClass().getMethod("saveView", FacesContext.class);
        }
        catch (Exception e) {
            log.error((Object)"Exception finding JSF1.2 saveView method on delegate", (Throwable)e);
        }
        this.parametersInitialized = true;
    }

    public Object saveView(FacesContext context) {
        StateManager sm;
        this.initializeParameters(context);
        if (this.pureDelegation || !(context instanceof BridgeFacesContext)) {
            if (this.v2DelegateSaveViewMethod != null) {
                try {
                    return this.v2DelegateSaveViewMethod.invoke((Object)this.delegate, context);
                }
                catch (Exception e) {
                    log.error((Object)"Exception in saveView", (Throwable)e);
                }
            } else {
                return this.delegate.saveSerializedView(context);
            }
        }
        UIViewRoot root = context.getViewRoot();
        BridgeFacesContext bfc = (BridgeFacesContext)context;
        String viewNumber = bfc.getViewNumber();
        Map sessionMap = bfc.getExternalContext().getSessionMap();
        HashMap<String, UIViewRoot> stateMap = (HashMap<String, UIViewRoot>)sessionMap.get("icefaces.state.maps");
        if (stateMap == null) {
            stateMap = new HashMap<String, UIViewRoot>();
            sessionMap.put("icefaces.state.maps", stateMap);
        }
        stateMap.put(viewNumber, root);
        StateManager stateManager = sm = context.getApplication().getStateManager();
        stateManager.getClass();
        return new StateManager.SerializedView(stateManager, (Object)viewNumber, null);
    }

    public StateManager.SerializedView saveSerializedView(FacesContext context) {
        if (this.pureDelegation || !(context instanceof BridgeFacesContext)) {
            return this.delegate.saveSerializedView(context);
        }
        return (StateManager.SerializedView)this.saveView(context);
    }

    public void writeState(FacesContext context, StateManager.SerializedView view) throws IOException {
        this.initializeParameters(context);
        if (this.pureDelegation || !(context instanceof BridgeFacesContext)) {
            this.delegate.writeState(context, view);
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.write(this.STATE_FIELD_START);
        writer.write(view.getStructure().toString());
        writer.write(this.STATE_FIELD_END);
        ViewRootStateManagerImpl.writeRenderKitIdField(context, writer);
    }

    public static void writeRenderKitIdField(FacesContext context, ResponseWriter writer) throws IOException {
        String result = context.getApplication().getDefaultRenderKitId();
        if (result != null && !"HTML_BASIC".equals(result)) {
            writer.startElement("input", (UIComponent)context.getViewRoot());
            writer.writeAttribute("type", (Object)"hidden", "type");
            writer.writeAttribute("name", (Object)"javax.faces.RenderKitId", "name");
            writer.writeAttribute("value", (Object)result, "value");
            writer.endElement("input");
        }
    }

    public void restoreComponentState(FacesContext context, UIViewRoot viewRoot, String renderKitId) {
    }

    protected UIViewRoot restoreTreeStructure(FacesContext context, String viewId, String renderKitId) {
        return null;
    }

    protected Object getComponentStateToSave(FacesContext context) {
        return null;
    }

    protected Object getTreeStructureToSave(FacesContext context) {
        return null;
    }
}

