/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.jcharts.test;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import org.krysalis.jcharts.axisChart.AxisChart;
import org.krysalis.jcharts.chartData.AxisChartDataSet;
import org.krysalis.jcharts.chartData.ChartDataException;
import org.krysalis.jcharts.chartData.DataSeries;
import org.krysalis.jcharts.properties.AxisProperties;
import org.krysalis.jcharts.properties.BarChartProperties;
import org.krysalis.jcharts.properties.ChartProperties;
import org.krysalis.jcharts.properties.ChartTypeProperties;
import org.krysalis.jcharts.properties.DataAxisProperties;
import org.krysalis.jcharts.properties.LegendProperties;
import org.krysalis.jcharts.properties.PropertyException;
import org.krysalis.jcharts.properties.util.ChartStroke;
import org.krysalis.jcharts.test.AxisChartTestBase;
import org.krysalis.jcharts.test.ChartTestDriver;
import org.krysalis.jcharts.test.TestDataGenerator;
import org.krysalis.jcharts.types.ChartType;

public final class BarTestDriver
extends AxisChartTestBase {
    boolean supportsImageMap() {
        return true;
    }

    static ChartTypeProperties getChartTypeProperties(int n) {
        BarChartProperties barChartProperties = new BarChartProperties();
        barChartProperties.setWidthPercentage(1.0f);
        return barChartProperties;
    }

    DataSeries getDataSeries() throws ChartDataException {
        int n = (int)TestDataGenerator.getRandomNumber(2.0, 25.0);
        int n2 = 1;
        DataSeries dataSeries = super.createDataSeries(n);
        AxisChartDataSet axisChartDataSet = super.createAxisChartDataSet(ChartType.BAR, BarTestDriver.getChartTypeProperties(n2), n2, n, -200, 400);
        dataSeries.addIAxisPlotDataSet(axisChartDataSet);
        return dataSeries;
    }

    public static void main(String[] stringArray) throws PropertyException, ChartDataException {
        BarChartProperties barChartProperties = new BarChartProperties();
        double[][] dArrayArray = new double[][]{{0.4, 0.6, 0.04, 0.3}};
        Paint[] paintArray = new Paint[]{Color.green};
        String[] stringArray2 = new String[]{"Test Legend Label"};
        AxisChartDataSet axisChartDataSet = new AxisChartDataSet(dArrayArray, stringArray2, paintArray, ChartType.BAR, barChartProperties);
        String[] stringArray3 = new String[]{"1900", "2000", "2010", "2050"};
        DataSeries dataSeries = new DataSeries(stringArray3, "Wonka Bars", "Years", "Oompa Loompa Productivity");
        dataSeries.addIAxisPlotDataSet(axisChartDataSet);
        ChartProperties chartProperties = new ChartProperties();
        AxisProperties axisProperties = new AxisProperties(false);
        axisProperties.getYAxisProperties().setShowGridLines(1);
        axisProperties.getYAxisProperties().setAxisStroke(new ChartStroke(new BasicStroke(1.5f), Color.red));
        axisProperties.getYAxisProperties().setGridLineChartStroke(new ChartStroke(new BasicStroke(1.5f), Color.red));
        DataAxisProperties dataAxisProperties = (DataAxisProperties)axisProperties.getYAxisProperties();
        dataAxisProperties.setNumItems(10);
        dataAxisProperties.setRoundToNearest(-3);
        LegendProperties legendProperties = new LegendProperties();
        AxisChart axisChart = new AxisChart(dataSeries, chartProperties, axisProperties, legendProperties, 500, 400);
        ChartTestDriver.exportImage(axisChart, "BarChartTest.png");
    }
}

