/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.jcharts.test;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import org.krysalis.jcharts.chartData.ChartDataException;
import org.krysalis.jcharts.chartData.PieChartDataSet;
import org.krysalis.jcharts.imageMap.ImageMap;
import org.krysalis.jcharts.nonAxisChart.PieChart2D;
import org.krysalis.jcharts.nonAxisChart.PieChart3D;
import org.krysalis.jcharts.properties.ChartProperties;
import org.krysalis.jcharts.properties.LegendProperties;
import org.krysalis.jcharts.properties.PieChart2DProperties;
import org.krysalis.jcharts.properties.PieChart3DProperties;
import org.krysalis.jcharts.properties.PropertyException;
import org.krysalis.jcharts.properties.util.ChartStroke;
import org.krysalis.jcharts.test.ChartTestDriver;
import org.krysalis.jcharts.test.HTMLGenerator;
import org.krysalis.jcharts.test.TestDataGenerator;
import org.krysalis.jcharts.types.PieLabelType;

public class Pie3DTestDriver {
    static void test() throws ChartDataException, PropertyException {
        int n = 15;
        HTMLGenerator hTMLGenerator = new HTMLGenerator("pieChart2dTest.html");
        for (int i = 0; i < n; ++i) {
            ImageMap imageMap;
            boolean bl = true;
            int n2 = (int)TestDataGenerator.getRandomNumber(1.0, 10.0);
            PieChartDataSet pieChartDataSet = Pie3DTestDriver.getPieChartDataSet(n2, 1, 7);
            int n3 = (int)TestDataGenerator.getRandomNumber(100.0, 600.0);
            int n4 = (int)TestDataGenerator.getRandomNumber(100.0, 600.0);
            LegendProperties legendProperties = new LegendProperties();
            TestDataGenerator.randomizeLegend(legendProperties);
            ChartProperties chartProperties = new ChartProperties();
            chartProperties.setBackgroundPaint(TestDataGenerator.getRandomPaint());
            PieChart2D pieChart2D = new PieChart2D(pieChartDataSet, legendProperties, chartProperties, n3, n4);
            String string = "pieChart2d" + i + ".png";
            if (bl) {
                pieChart2D.renderWithImageMap();
                imageMap = pieChart2D.getImageMap();
            } else {
                imageMap = null;
            }
            ChartTestDriver.exportImage(pieChart2D, string);
            hTMLGenerator.chartTableStart("PieChart2D", string, imageMap);
            hTMLGenerator.propertiesTableRowStart();
            pieChartDataSet.toHTML(hTMLGenerator);
            hTMLGenerator.propertiesTableRowStart();
            pieChart2D.toHTML(hTMLGenerator, string);
            hTMLGenerator.addLineBreak();
        }
        hTMLGenerator.saveFile();
    }

    private static PieChartDataSet getPieChartDataSet(int n, int n2, int n3) throws ChartDataException {
        PieChart2DProperties pieChart2DProperties = new PieChart2DProperties();
        pieChart2DProperties.setBorderChartStroke(new ChartStroke(new BasicStroke(1.0f), TestDataGenerator.getRandomPaint()));
        String[] stringArray = TestDataGenerator.getRandomStrings(n, (int)TestDataGenerator.getRandomNumber(3.0, 20.0), false);
        Paint[] paintArray = TestDataGenerator.getRandomPaints(n);
        return new PieChartDataSet("This is a test title", TestDataGenerator.getRandomNumbers(n, n2, n3), stringArray, paintArray, pieChart2DProperties);
    }

    public static void main(String[] stringArray) throws ChartDataException, PropertyException {
        double[] dArray = new double[]{45.0, 90.0, 45.0, 180.0};
        String[] stringArray2 = new String[]{"Equities", "Bonds", "Money Market", "Alternative Investments"};
        Paint[] paintArray = new Paint[]{new Color(200, 0, 0, 20), new Color(0, 200, 0, 220), new Color(0, 0, 200, 20), new Color(200, 200, 0, 20)};
        PieChart3DProperties pieChart3DProperties = new PieChart3DProperties();
        pieChart3DProperties.setPieLabelType(PieLabelType.LEGEND_LABELS);
        pieChart3DProperties.setTickLength(5.0f);
        pieChart3DProperties.setZeroDegreeOffset(60.0f);
        pieChart3DProperties.setDepth(15);
        LegendProperties legendProperties = new LegendProperties();
        legendProperties.setPlacement(1);
        legendProperties.setNumColumns(1);
        PieChartDataSet pieChartDataSet = new PieChartDataSet("Investment Categories", dArray, stringArray2, paintArray, pieChart3DProperties);
        ChartProperties chartProperties = new ChartProperties();
        chartProperties.setBorderStroke(ChartStroke.DEFAULT_CHART_OUTLINE);
        PieChart3D pieChart3D = new PieChart3D(pieChartDataSet, legendProperties, chartProperties, 600, 200);
        ChartTestDriver.exportImage(pieChart3D, "pie3d.png");
    }
}

