/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.el.impl;

import com.sun.faces.el.impl.BeanInfoIndexedProperty;
import com.sun.faces.el.impl.BeanInfoProperty;
import com.sun.faces.el.impl.Constants;
import com.sun.faces.el.impl.ElException;
import com.sun.faces.el.impl.MessageUtil;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessControlException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeanInfoManager {
    private static Log log = LogFactory.getLog((Class)(class$com$sun$faces$el$impl$BeanInfoManager == null ? (class$com$sun$faces$el$impl$BeanInfoManager = BeanInfoManager.class$("com.sun.faces.el.impl.BeanInfoManager")) : class$com$sun$faces$el$impl$BeanInfoManager));
    Class mBeanClass;
    BeanInfo mBeanInfo;
    Map mPropertyByName;
    Map mIndexedPropertyByName;
    Map mEventSetByName;
    boolean mInitialized;
    static Map mBeanInfoManagerByClass = new HashMap();
    static /* synthetic */ Class class$com$sun$faces$el$impl$BeanInfoManager;

    public Class getBeanClass() {
        return this.mBeanClass;
    }

    BeanInfoManager(Class pBeanClass) {
        this.mBeanClass = pBeanClass;
    }

    public static BeanInfoManager getBeanInfoManager(Class pClass) {
        BeanInfoManager ret = (BeanInfoManager)mBeanInfoManagerByClass.get(pClass);
        if (ret == null) {
            ret = BeanInfoManager.createBeanInfoManager(pClass);
        }
        return ret;
    }

    static synchronized BeanInfoManager createBeanInfoManager(Class pClass) {
        BeanInfoManager ret = (BeanInfoManager)mBeanInfoManagerByClass.get(pClass);
        if (ret == null) {
            ret = new BeanInfoManager(pClass);
            mBeanInfoManagerByClass.put(pClass, ret);
        }
        return ret;
    }

    public static BeanInfoProperty getBeanInfoProperty(Class pClass, String pPropertyName) throws ElException {
        return BeanInfoManager.getBeanInfoManager(pClass).getProperty(pPropertyName);
    }

    public static BeanInfoIndexedProperty getBeanInfoIndexedProperty(Class pClass, String pIndexedPropertyName) throws ElException {
        return BeanInfoManager.getBeanInfoManager(pClass).getIndexedProperty(pIndexedPropertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkInitialized() throws ElException {
        if (!this.mInitialized) {
            BeanInfoManager beanInfoManager = this;
            synchronized (beanInfoManager) {
                if (!this.mInitialized) {
                    this.initialize();
                    this.mInitialized = true;
                }
            }
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void initialize() throws ElException {
        try {
            block7: {
                int i;
                EventSetDescriptor[] esds;
                block6: {
                    this.mBeanInfo = Introspector.getBeanInfo(this.mBeanClass);
                    this.mPropertyByName = new HashMap();
                    this.mIndexedPropertyByName = new HashMap();
                    PropertyDescriptor[] pds = this.mBeanInfo.getPropertyDescriptors();
                    int i2 = 0;
                    while (pds != null && i2 < pds.length) {
                        PropertyDescriptor pd = pds[i2];
                        if (pd instanceof IndexedPropertyDescriptor) {
                            IndexedPropertyDescriptor ipd = (IndexedPropertyDescriptor)pd;
                            Method readMethod = BeanInfoManager.getPublicMethod(ipd.getIndexedReadMethod());
                            Method writeMethod = BeanInfoManager.getPublicMethod(ipd.getIndexedWriteMethod());
                            BeanInfoIndexedProperty property = new BeanInfoIndexedProperty(readMethod, writeMethod, ipd);
                            this.mIndexedPropertyByName.put(ipd.getName(), property);
                        }
                        Method readMethod = BeanInfoManager.getPublicMethod(pd.getReadMethod());
                        Method writeMethod = BeanInfoManager.getPublicMethod(pd.getWriteMethod());
                        BeanInfoProperty property = new BeanInfoProperty(readMethod, writeMethod, pd);
                        this.mPropertyByName.put(pd.getName(), property);
                        ++i2;
                    }
                    this.mEventSetByName = new HashMap();
                    esds = this.mBeanInfo.getEventSetDescriptors();
                    i = 0;
                    if (!true) break block6;
                    if (esds == null) return;
                    if (i >= esds.length) break block7;
                }
                do {
                    EventSetDescriptor esd = esds[i];
                    this.mEventSetByName.put(esd.getName(), esd);
                    ++i;
                    if (esds == null) return;
                } while (i < esds.length);
            }
            return;
        }
        catch (IntrospectionException exc) {
            if (!log.isWarnEnabled()) return;
            log.warn((Object)MessageUtil.getMessageWithArgs(Constants.EXCEPTION_GETTING_BEANINFO, this.mBeanClass.getName()), (Throwable)exc);
            return;
        }
    }

    BeanInfo getBeanInfo() throws ElException {
        this.checkInitialized();
        return this.mBeanInfo;
    }

    public BeanInfoProperty getProperty(String pPropertyName) throws ElException {
        this.checkInitialized();
        return (BeanInfoProperty)this.mPropertyByName.get(pPropertyName);
    }

    public BeanInfoIndexedProperty getIndexedProperty(String pIndexedPropertyName) throws ElException {
        this.checkInitialized();
        return (BeanInfoIndexedProperty)this.mIndexedPropertyByName.get(pIndexedPropertyName);
    }

    public EventSetDescriptor getEventSet(String pEventSetName) throws ElException {
        this.checkInitialized();
        return (EventSetDescriptor)this.mEventSetByName.get(pEventSetName);
    }

    static Method getPublicMethod(Method pMethod) {
        if (pMethod == null) {
            return null;
        }
        Class<?> cl = pMethod.getDeclaringClass();
        if (Modifier.isPublic(cl.getModifiers())) {
            return pMethod;
        }
        Method ret = BeanInfoManager.getPublicMethod(cl, pMethod);
        if (ret != null) {
            return ret;
        }
        return pMethod;
    }

    static Method getPublicMethod(Class pClass, Method pMethod) {
        Method m;
        Class superclass;
        Class<?>[] interfaces;
        if (Modifier.isPublic(pClass.getModifiers())) {
            try {
                Method m2;
                try {
                    m2 = pClass.getDeclaredMethod(pMethod.getName(), pMethod.getParameterTypes());
                }
                catch (AccessControlException ex) {
                    m2 = pClass.getMethod(pMethod.getName(), pMethod.getParameterTypes());
                }
                if (Modifier.isPublic(m2.getModifiers())) {
                    return m2;
                }
            }
            catch (NoSuchMethodException exc) {
                // empty catch block
            }
        }
        if ((interfaces = pClass.getInterfaces()) != null) {
            int i = 0;
            while (i < interfaces.length) {
                Method m3 = BeanInfoManager.getPublicMethod(interfaces[i], pMethod);
                if (m3 != null) {
                    return m3;
                }
                ++i;
            }
        }
        if ((superclass = pClass.getSuperclass()) != null && (m = BeanInfoManager.getPublicMethod(superclass, pMethod)) != null) {
            return m;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

