/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.taglibs.authz;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.userdetails.UserDetails;

public class AuthenticationTag
extends TagSupport {
    private static final Set methodPrefixValidOptions = new HashSet();
    private String methodPrefix = "get";
    private String operation = "";

    public int doStartTag() throws JspException {
        if (null == this.operation || "".equals(this.operation)) {
            return 0;
        }
        this.validateArguments();
        if (SecurityContextHolder.getContext() == null || !(SecurityContextHolder.getContext() instanceof SecurityContext) || SecurityContextHolder.getContext().getAuthentication() == null) {
            return 0;
        }
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth.getPrincipal() == null) {
            return 0;
        }
        if (auth.getPrincipal() instanceof UserDetails) {
            this.writeMessage(this.invokeOperation(auth.getPrincipal()));
            return 0;
        }
        this.writeMessage(auth.getPrincipal().toString());
        return 0;
    }

    public String getMethodPrefix() {
        return this.methodPrefix;
    }

    public String getOperation() {
        return this.operation;
    }

    protected String invokeOperation(Object obj) throws JspException {
        Class<?> clazz = obj.getClass();
        String methodToInvoke = this.getOperation();
        StringBuffer methodName = new StringBuffer();
        methodName.append(this.getMethodPrefix());
        methodName.append(methodToInvoke.substring(0, 1).toUpperCase());
        methodName.append(methodToInvoke.substring(1));
        Method method = null;
        try {
            method = clazz.getMethod(methodName.toString(), null);
        }
        catch (SecurityException se) {
            throw new JspException((Throwable)se);
        }
        catch (NoSuchMethodException nsme) {
            throw new JspException((Throwable)nsme);
        }
        Object retVal = null;
        try {
            retVal = method.invoke(obj, (Object[])null);
        }
        catch (IllegalArgumentException iae) {
            throw new JspException((Throwable)iae);
        }
        catch (IllegalAccessException iae) {
            throw new JspException((Throwable)iae);
        }
        catch (InvocationTargetException ite) {
            throw new JspException((Throwable)ite);
        }
        if (retVal == null) {
            retVal = "";
        }
        return retVal.toString();
    }

    public void setMethodPrefix(String methodPrefix) {
        this.methodPrefix = methodPrefix;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    protected void validateArguments() throws JspException {
        if (this.getMethodPrefix() != null && !this.getMethodPrefix().equals("")) {
            if (!methodPrefixValidOptions.contains(this.getMethodPrefix())) {
                throw new JspException("Authorization tag : no valid method prefix available");
            }
        } else {
            throw new JspException("Authorization tag : no method prefix available");
        }
    }

    protected void writeMessage(String msg) throws JspException {
        try {
            this.pageContext.getOut().write(String.valueOf(msg));
        }
        catch (IOException ioe) {
            throw new JspException((Throwable)ioe);
        }
    }

    static {
        methodPrefixValidOptions.add("get");
        methodPrefixValidOptions.add("is");
    }
}

