/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.runas;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationException;
import org.springframework.security.BadCredentialsException;
import org.springframework.security.SpringSecurityMessageSource;
import org.springframework.security.providers.AuthenticationProvider;
import org.springframework.security.runas.RunAsUserToken;
import org.springframework.util.Assert;

public class RunAsImplAuthenticationProvider
implements InitializingBean,
AuthenticationProvider,
MessageSourceAware {
    protected MessageSourceAccessor messages = SpringSecurityMessageSource.getAccessor();
    private String key;
    static /* synthetic */ Class class$org$springframework$security$runas$RunAsUserToken;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.key, (String)"A Key is required and should match that configured for the RunAsManagerImpl");
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        RunAsUserToken token = (RunAsUserToken)authentication;
        if (token.getKeyHash() == this.key.hashCode()) {
            return authentication;
        }
        throw new BadCredentialsException(this.messages.getMessage("RunAsImplAuthenticationProvider.incorrectKey", "The presented RunAsUserToken does not contain the expected key"));
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messages = new MessageSourceAccessor(messageSource);
    }

    public boolean supports(Class authentication) {
        return (class$org$springframework$security$runas$RunAsUserToken == null ? (class$org$springframework$security$runas$RunAsUserToken = RunAsImplAuthenticationProvider.class$("org.springframework.security.runas.RunAsUserToken")) : class$org$springframework$security$runas$RunAsUserToken).isAssignableFrom(authentication);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

