/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.inputfile;

import com.icesoft.faces.util.CoreUtils;
import java.io.File;
import java.io.Serializable;

public class FileInfo
implements Cloneable,
Serializable {
    public static final int DEFAULT = 0;
    public static final int UPLOADING = 1;
    public static final int SAVED = 2;
    public static final int INVALID = 3;
    public static final int SIZE_LIMIT_EXCEEDED = 4;
    public static final int UNKNOWN_SIZE = 5;
    public static final int INVALID_NAME_PATTERN = 6;
    public static final int UNSPECIFIED_NAME = 7;
    public static final int INVALID_CONTENT_TYPE = 8;
    private int status = 0;
    private long size = 0L;
    private String fileName = null;
    private String contentType = null;
    private File file = null;
    private int percent = 0;
    private Exception exception = null;
    private boolean preUpload = false;
    private boolean postUpload = false;

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getPhysicalPath() {
        if (this.file != null) {
            return this.file.getAbsolutePath();
        }
        return null;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public int getPercent() {
        return this.percent;
    }

    public void setPercent(int percent) {
        this.percent = percent;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public boolean isPreUpload() {
        return this.preUpload;
    }

    public void setPreUpload(boolean pre) {
        this.preUpload = pre;
    }

    public boolean isPostUpload() {
        return this.postUpload;
    }

    public void setPostUpload(boolean post) {
        this.postUpload = post;
    }

    public boolean isSaved() {
        return this.status == 2;
    }

    public boolean isFinished() {
        return this.status >= 2;
    }

    public boolean isFailed() {
        return this.status >= 3 && this.status <= 8;
    }

    public Object clone() {
        FileInfo fi = new FileInfo();
        fi.status = this.status;
        fi.size = this.size;
        fi.fileName = this.fileName;
        fi.contentType = this.contentType;
        fi.file = this.file;
        fi.percent = this.percent;
        fi.exception = this.exception;
        fi.preUpload = this.preUpload;
        fi.postUpload = this.postUpload;
        return fi;
    }

    public String toString() {
        return "FileInfo: {\n  percent=" + this.percent + ",\n  preUpload=" + this.preUpload + ",\n  postUpload=" + this.postUpload + ",\n  exception=" + this.exception + ",\n  fileName=" + this.fileName + ",\n  file=" + this.file + ",\n  physicalPath=" + this.getPhysicalPath() + ",\n  contentType=" + this.contentType + ",\n  size=" + this.size + ",\n  status=" + this.status + "\n}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileInfo fileInfo = (FileInfo)o;
        if (this.status != fileInfo.status) {
            return false;
        }
        if (this.percent != fileInfo.percent) {
            return false;
        }
        if (this.postUpload != fileInfo.postUpload) {
            return false;
        }
        if (this.preUpload != fileInfo.preUpload) {
            return false;
        }
        if (this.size != fileInfo.size) {
            return false;
        }
        if (this.contentType != null ? !this.contentType.equals(fileInfo.contentType) : fileInfo.contentType != null) {
            return false;
        }
        if (!CoreUtils.throwablesEqual(this.exception, fileInfo.exception)) {
            return false;
        }
        if (this.fileName != null ? !this.fileName.equals(fileInfo.fileName) : fileInfo.fileName != null) {
            return false;
        }
        return !(this.file != null ? !this.file.equals(fileInfo.file) : fileInfo.file != null);
    }

    public int hashCode() {
        int result = (int)(this.size ^ this.size >>> 32);
        result = 31 * result + this.status;
        result = 31 * result + (this.fileName != null ? this.fileName.hashCode() : 0);
        result = 31 * result + (this.contentType != null ? this.contentType.hashCode() : 0);
        result = 31 * result + (this.file != null ? this.file.hashCode() : 0);
        result = 31 * result + this.percent;
        result = 31 * result + (this.exception != null ? this.exception.hashCode() : 0);
        result = 31 * result + (this.preUpload ? 1 : 0);
        result = 31 * result + (this.postUpload ? 1 : 0);
        return result;
    }
}

