/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.traverse;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.traverse.OMChildrenIterator;

public class OMChildrenQNameIterator
extends OMChildrenIterator {
    private final QName givenQName;
    private boolean needToMoveForward = true;
    private boolean isMatchingNodeFound = false;

    public OMChildrenQNameIterator(OMNode currentChild, QName givenQName) {
        super(currentChild);
        this.givenQName = givenQName;
        this.findNextElementWithQName();
    }

    public boolean isEqual(QName searchQName, QName currentQName) {
        return searchQName.equals(currentQName);
    }

    public boolean hasNext() {
        while (this.needToMoveForward) {
            this.findNextElementWithQName();
        }
        return this.isMatchingNodeFound;
    }

    private void findNextElementWithQName() {
        if (this.currentChild != null) {
            if (this.currentChild instanceof OMElement) {
                QName thisQName = ((OMElement)this.currentChild).getQName();
                if (this.givenQName == null || this.isEqual(this.givenQName, thisQName)) {
                    this.isMatchingNodeFound = true;
                    this.needToMoveForward = false;
                    return;
                }
            }
            this.currentChild = this.currentChild.getNextOMSibling();
            this.needToMoveForward = this.currentChild != null;
            this.isMatchingNodeFound = this.needToMoveForward;
        } else {
            this.needToMoveForward = false;
        }
    }

    public Object next() {
        this.needToMoveForward = true;
        this.isMatchingNodeFound = false;
        this.nextCalled = true;
        this.removeCalled = false;
        this.lastChild = this.currentChild;
        this.currentChild = this.currentChild.getNextOMSibling();
        return this.lastChild;
    }

    public static boolean isEquals_Legacy(QName searchQName, QName currentQName) {
        String localPart = searchQName.getLocalPart();
        boolean localNameMatch = localPart == null || localPart.equals("") || currentQName != null && currentQName.getLocalPart().equals(localPart);
        String namespaceURI = searchQName.getNamespaceURI();
        boolean namespaceURIMatch = namespaceURI == null || namespaceURI.equals("") || currentQName != null && currentQName.getNamespaceURI().equals(namespaceURI);
        return localNameMatch && namespaceURIMatch;
    }
}

