/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import antlr.CommonHiddenStreamToken;
import antlr.collections.AST;
import de.hunsicker.jalopy.language.JavaNodeHelper;
import de.hunsicker.jalopy.language.antlr.JavaNode;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.LeftParenthesisPrinter;
import de.hunsicker.jalopy.printer.Marker;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.ParenthesesScope;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.printer.RightParenthesisPrinter;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.IOException;

abstract class OperatorPrinter
extends AbstractPrinter {
    protected OperatorPrinter() {
    }

    protected boolean performWrap(int length, AST node, boolean wrapBefore, boolean paddOperator, NodeWriter out) throws IOException {
        if (out.mode == 1) {
            int lineLength;
            int offset = out.column + length + (paddOperator ? 2 : 0);
            if (wrapBefore) {
                offset += node.getText().length();
            }
            if (out.column >= (lineLength = AbstractPrinter.settings.getInt(ConventionKeys.LINE_LENGTH, 80)) || offset > lineLength) {
                out.printNewline();
                this.printIndentation(out);
                return true;
            }
        }
        return false;
    }

    protected AST printLeftHandSide(AST node, NodeWriter out) throws IOException {
        AST first = node.getFirstChild();
        switch (first.getType()) {
            case 108: {
                int count = 0;
                AST child = first;
                while (child != null) {
                    PrinterFactory.create(child, out).print(child, out);
                    switch (child.getType()) {
                        case 108: {
                            ++count;
                            break;
                        }
                        case 109: {
                            if (--count != 0) break;
                            return child.getNextSibling();
                        }
                    }
                    child = child.getNextSibling();
                }
                throw new IllegalStateException("missing closing parenthesis");
            }
        }
        PrinterFactory.create(first, out).print(first, out);
        return first.getNextSibling();
    }

    protected void printRightHandSide(AST node, NodeWriter out) throws IOException {
        AST child = node;
        while (child != null) {
            PrinterFactory.create(child, out).print(child, out);
            child = child.getNextSibling();
        }
    }

    int getPrecedence(AST node) {
        int result = 0;
        switch (node.getType()) {
            case 146: {
                result = 1;
                break;
            }
            case 145: {
                result = 2;
                break;
            }
            case 144: {
                result = 3;
                break;
            }
            case 142: {
                result = 4;
                break;
            }
            case 141: {
                result = 5;
                break;
            }
            case 143: {
                result = 6;
                break;
            }
            case 137: {
                result = 7;
                break;
            }
            case 136: {
                result = 8;
                break;
            }
            case 140: {
                result = 9;
                break;
            }
            case 139: {
                result = 10;
                break;
            }
            case 138: {
                result = 11;
                break;
            }
            case 110: {
                result = 12;
                break;
            }
            case 120: {
                result = 13;
                break;
            }
            case 81: {
                result = 14;
                break;
            }
            case 147: {
                result = 15;
                break;
            }
            case 148: {
                result = 16;
                break;
            }
            case 149: {
                result = 17;
                break;
            }
            case 150: {
                result = 18;
                break;
            }
            case 114: {
                result = 19;
                break;
            }
            case 151: {
                result = 20;
                break;
            }
            case 152: {
                result = 21;
                break;
            }
            case 154: {
                result = 22;
                break;
            }
            case 153: {
                result = 23;
                break;
            }
            case 86: {
                result = 24;
                break;
            }
            case 84: {
                result = 25;
                break;
            }
            case 87: {
                result = 26;
                break;
            }
            case 156: {
                result = 27;
                break;
            }
            case 158: {
                result = 28;
                break;
            }
            case 157: {
                result = 29;
                break;
            }
            case 160: {
                result = 30;
                break;
            }
            case 159: {
                result = 31;
                break;
            }
            case 98: {
                result = 32;
            }
        }
        return result;
    }

    static boolean canWrap(AST operator, NodeWriter out) {
        if (out.mode != 1) {
            return false;
        }
        switch (operator.getType()) {
            case 114: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 157: 
            case 158: {
                return true;
            }
        }
        return false;
    }

    boolean isTopMost(JavaNode node) {
        JavaNode parent = node.getParent();
        switch (parent.getType()) {
            case 33: {
                return true;
            }
        }
        return false;
    }

    void addParentheses(JavaNode operand, NodeWriter out) {
        JavaNode parent = operand.getParent();
        JavaNode lparen = (JavaNode)out.getJavaNodeFactory().create(108, "(");
        JavaNode rparen = (JavaNode)out.getJavaNodeFactory().create(109, ")");
        if (parent.getFirstChild() == operand) {
            parent.setFirstChild(lparen);
            lparen.setPreviousSibling(parent);
        }
        lparen.setParent(parent);
        lparen.setNextSibling(operand);
        rparen.setParent(parent);
        rparen.setPreviousSibling(operand);
        rparen.setNextSibling(operand.getNextSibling());
        operand.setPreviousSibling(lparen);
        operand.setNextSibling(rparen);
    }

    boolean printWithParentheses(JavaNode node, AST leftParen, AST rightParen, NodeWriter out) throws IOException {
        JavaNode n = JavaNodeHelper.getLastChild(node);
        if (n == null || n.hasCommentsAfter()) {
            LeftParenthesisPrinter.getInstance().print(leftParen, out);
            if (out.mode == 1) {
                out.state.parenScope.addFirst(new ParenthesesScope(out.state.paramLevel));
            }
            Marker marker = out.state.markers.add();
            PrinterFactory.create(node, out).print(node, out);
            out.state.markers.remove(marker);
            RightParenthesisPrinter.getInstance().print(rightParen, out);
            if (out.mode == 1) {
                out.state.parenScope.removeFirst();
            }
            return false;
        }
        CommonHiddenStreamToken t = n.getHiddenAfter();
        n.setHiddenAfter(null);
        Marker marker = out.state.markers.add();
        LeftParenthesisPrinter.getInstance().print(leftParen, out);
        if (out.mode == 1) {
            out.state.parenScope.addFirst(new ParenthesesScope(out.state.paramLevel));
        }
        PrinterFactory.create(node, out).print(node, out);
        RightParenthesisPrinter.getInstance().print(rightParen, out);
        out.state.markers.remove(marker);
        if (out.mode == 1) {
            out.state.parenScope.removeFirst();
        }
        n.setHiddenAfter(t);
        this.printCommentsAfter(n, false, false, out);
        return true;
    }
}

