/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.jcharts.properties;

import java.awt.BasicStroke;
import java.awt.Stroke;
import org.krysalis.jcharts.chartData.interfaces.IAxisPlotDataSet;
import org.krysalis.jcharts.properties.AxisChartTypeProperties;
import org.krysalis.jcharts.properties.PropertyException;
import org.krysalis.jcharts.test.HTMLGenerator;

public final class StockChartProperties
extends AxisChartTypeProperties {
    public static final Stroke DEFAULT_STROKE = new BasicStroke(1.5f);
    private Stroke hiLowStroke;
    private Stroke openStroke;
    private int openLength;
    private Stroke closeStroke;
    private int closeLength;

    public StockChartProperties() {
        this.hiLowStroke = DEFAULT_STROKE;
        this.openStroke = DEFAULT_STROKE;
        this.openLength = 5;
        this.closeStroke = DEFAULT_STROKE;
        this.closeLength = 5;
    }

    public StockChartProperties(Stroke stroke, Stroke stroke2, int n, Stroke stroke3, int n2) {
        this.hiLowStroke = stroke;
        this.openStroke = stroke2;
        this.openLength = n;
        this.closeStroke = stroke3;
        this.closeLength = n2;
    }

    public Stroke getHiLowStroke() {
        return this.hiLowStroke;
    }

    public void setHiLowStroke(Stroke stroke) {
        this.hiLowStroke = stroke;
    }

    public Stroke getOpenStroke() {
        return this.openStroke;
    }

    public void setOpenStroke(Stroke stroke) {
        this.openStroke = stroke;
    }

    public int getOpenPixelLength() {
        return this.openLength;
    }

    public void setOpenPixelLength(int n) {
        this.openLength = n;
    }

    public Stroke getCloseStroke() {
        return this.closeStroke;
    }

    public void setCloseStroke(Stroke stroke) {
        this.closeStroke = stroke;
    }

    public int getClosePixelLength() {
        return this.closeLength;
    }

    public void setClosePixelLength(int n) {
        this.closeLength = n;
    }

    public void validate(IAxisPlotDataSet iAxisPlotDataSet) throws PropertyException {
    }

    public void toHTML(HTMLGenerator hTMLGenerator) {
        hTMLGenerator.propertiesTableStart("StockChartProperties");
        hTMLGenerator.addTableRow("HiLow Stroke", this.hiLowStroke);
        hTMLGenerator.addTableRow("Open Stroke", this.openStroke);
        hTMLGenerator.addTableRow("Open Length", Integer.toString(this.openLength));
        hTMLGenerator.addTableRow("Close Stroke", this.closeStroke);
        hTMLGenerator.addTableRow("Close Length", Integer.toString(this.closeLength));
        hTMLGenerator.propertiesTableEnd();
    }
}

