/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.server.config;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.xml.namespace.QName;
import javax.xml.ws.RespectBinding;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.EndpointDescriptionJava;
import org.apache.axis2.jaxws.description.EndpointDescriptionWSDL;
import org.apache.axis2.jaxws.feature.ServerConfigurator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RespectBindingConfigurator
implements ServerConfigurator {
    private static final Log log = LogFactory.getLog(RespectBindingConfigurator.class);

    public void configure(EndpointDescription endpointDescription) {
        RespectBinding annotation = (RespectBinding)((EndpointDescriptionJava)((Object)endpointDescription)).getAnnoFeature("javax.xml.ws.RespectBindingFeature");
        if (annotation != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Setting respectBinding to " + annotation.enabled()));
            }
            endpointDescription.setRespectBinding(annotation.enabled());
            EndpointDescriptionWSDL edw = (EndpointDescriptionWSDL)((Object)endpointDescription);
            Binding bnd = edw.getWSDLBinding();
            if (bnd != null) {
                List l = bnd.getExtensibilityElements();
                if (l == null || l.size() == 0) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"No extensibility elements found.");
                    }
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Checking list of " + l.size() + " extensibility elements for required bindings."));
                    }
                    Iterator i = l.iterator();
                    ArrayList<QName> unusedElements = new ArrayList<QName>();
                    while (i.hasNext()) {
                        ExtensibilityElement e = (ExtensibilityElement)i.next();
                        if (e instanceof SOAPBinding || e instanceof SOAP12Binding) continue;
                        if (e instanceof UnknownExtensibilityElement) {
                            UnknownExtensibilityElement ue = (UnknownExtensibilityElement)e;
                            String reqd = ue.getElement().getAttribute("required");
                            if (reqd.equals("true") || reqd.equals("TRUE")) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Found a required element: " + e.getElementType()));
                                }
                                endpointDescription.addRequiredBinding(e.getElementType());
                                continue;
                            }
                            unusedElements.add(e.getElementType());
                            continue;
                        }
                        if (e.getRequired() != null && e.getRequired().booleanValue()) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Found a required element: " + e.getElementType()));
                            }
                            endpointDescription.addRequiredBinding(e.getElementType());
                            continue;
                        }
                        unusedElements.add(e.getElementType());
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"The following extensibility elements were found, but were not required.");
                        for (int n = 0; n < unusedElements.size(); ++n) {
                            log.debug((Object)("[" + i + "] - " + unusedElements.get(n)));
                        }
                    }
                }
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"No @RespectBinding annotation was found.");
        }
    }

    public boolean supports(String bindingId) {
        return true;
    }
}

