/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.util;

import com.icesoft.faces.application.D2DViewHandler;
import com.icesoft.faces.context.BridgeExternalContext;
import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicRenderer;
import com.icesoft.faces.webapp.http.common.Configuration;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Iterator;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.portlet.PortletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class CoreUtils {
    private static final Log log = LogFactory.getLog((Class)CoreUtils.class);
    private static Boolean renderPortletStyleClass;
    private static Boolean portletEnvironment;
    public static int toolTipcounter;

    public static String resolveResourceURL(FacesContext facesContext, String path) {
        return facesContext.getApplication().getViewHandler().getResourceURL(facesContext, path);
    }

    public static boolean isPortletEnvironment() {
        if (portletEnvironment == null) {
            try {
                portletEnvironment = new Boolean(FacesContext.getCurrentInstance().getExternalContext().getRequest() instanceof PortletRequest);
            }
            catch (NoClassDefFoundError e) {
                portletEnvironment = Boolean.FALSE;
            }
        }
        return portletEnvironment;
    }

    public static String getPortletStyleClass(String className) {
        if (CoreUtils.isPortletEnvironment() && CoreUtils.isRenderPortletStyleClass()) {
            return " " + className;
        }
        return "";
    }

    private static boolean isRenderPortletStyleClass() {
        if (renderPortletStyleClass == null) {
            String renderStyle = FacesContext.getCurrentInstance().getExternalContext().getInitParameter("com.icesoft.faces.portlet.renderStyles");
            renderPortletStyleClass = renderStyle == null ? Boolean.TRUE : Boolean.valueOf(renderStyle);
        }
        return renderPortletStyleClass;
    }

    public static String addPortletStyleClassToQualifiedClass(String qualifiedStyleClass, String defaultClass, String portletClass) {
        return CoreUtils.addPortletStyleClassToQualifiedClass(qualifiedStyleClass, defaultClass, portletClass, false);
    }

    public static String addPortletStyleClassToQualifiedClass(String qualifiedStyleClass, String defaultClass, String portletClass, boolean disabled) {
        if (CoreUtils.isPortletEnvironment() && CoreUtils.isRenderPortletStyleClass()) {
            if (disabled) {
                return qualifiedStyleClass.replaceAll(defaultClass + "-dis", defaultClass + "-dis" + " " + portletClass);
            }
            return qualifiedStyleClass.replaceAll(defaultClass, defaultClass + " " + portletClass);
        }
        return qualifiedStyleClass;
    }

    public static void recoverFacesMessages(FacesContext facesContext, UIComponent uiComponent) {
        if (!(uiComponent instanceof UIInput)) {
            return;
        }
        UIInput input = (UIInput)uiComponent;
        String clientId = input.getClientId(facesContext);
        String localFacesMsgId = clientId + "$ice-msg$";
        String localRequired = clientId + "$ice-req$";
        if (input.getAttributes().get(localRequired) == null) {
            input.getAttributes().put(localRequired, new Boolean(input.isRequired()));
        }
        if (!input.isValid()) {
            Iterator messages = facesContext.getMessages(clientId);
            FacesMessage message = null;
            if (messages == null || !messages.hasNext()) {
                if (input.getAttributes().get(localFacesMsgId) != null) {
                    message = (FacesMessage)input.getAttributes().get(localFacesMsgId);
                    facesContext.addMessage(clientId, message);
                }
            } else {
                message = (FacesMessage)messages.next();
                input.getAttributes().put(localFacesMsgId, message);
            }
        } else {
            input.getAttributes().remove(localFacesMsgId);
        }
    }

    public static void addPanelTooltip(FacesContext facesContext, UIComponent uiComponent) {
        UIComponent form;
        DOMContext domContext = DOMContext.getDOMContext(facesContext, uiComponent);
        if (uiComponent.getAttributes().get("panelTooltip") == null) {
            return;
        }
        String panelTooltipId = String.valueOf(uiComponent.getAttributes().get("panelTooltip"));
        int delay = 500;
        String hideOn = "mouseout";
        boolean dynamic = false;
        String formId = "";
        String ctxValue = "";
        String displayOn = "hover";
        boolean moveWithMouse = false;
        UIComponent panelTooltip = D2DViewHandler.findComponent(panelTooltipId, uiComponent);
        if (panelTooltip != null) {
            panelTooltipId = panelTooltip.getClientId(facesContext);
            if (panelTooltip.getAttributes().get("hideOn") != null) {
                hideOn = String.valueOf(panelTooltip.getAttributes().get("hideOn"));
            }
            if (panelTooltip.getAttributes().get("dynamic") != null) {
                dynamic = (Boolean)panelTooltip.getAttributes().get("dynamic");
            }
            if (panelTooltip.getAttributes().get("hoverDelay") != null) {
                delay = new Integer(String.valueOf(panelTooltip.getAttributes().get("hoverDelay")));
            }
            if (uiComponent.getAttributes().get("contextValue") != null) {
                ctxValue = String.valueOf(uiComponent.getAttributes().get("contextValue"));
            }
            if (panelTooltip.getAttributes().get("displayOn") != null) {
                displayOn = String.valueOf(panelTooltip.getAttributes().get("displayOn"));
            }
            if (panelTooltip.getAttributes().get("moveWithMouse") != null) {
                moveWithMouse = (Boolean)panelTooltip.getAttributes().get("moveWithMouse");
            }
        }
        if ((form = DomBasicRenderer.findForm(panelTooltip)) != null) {
            formId = form.getClientId(facesContext);
        }
        Element rootElement = (Element)domContext.getRootNode();
        String onAttr = displayOn.equals("click") || displayOn.equals("dblclick") ? "on" + displayOn : (displayOn.equals("altclick") ? "oncontextmenu" : "onmouseover");
        String onValue = String.valueOf(rootElement.getAttribute(onAttr));
        onValue = onValue + "; new ToolTipPanelPopup(this, '" + panelTooltipId + "', event, '" + hideOn + "','" + delay + "', '" + dynamic + "', '" + formId + "', '" + ctxValue + "','" + CoreUtils.resolveResourceURL(facesContext, "/xmlhttp/blank") + "','" + displayOn + "'," + moveWithMouse + ");";
        rootElement.setAttribute(onAttr, onValue);
    }

    public static void addAuxiliaryContexts(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        if (!(externalContext instanceof BridgeExternalContext)) {
            return;
        }
        BridgeExternalContext bridgeExternalContext = (BridgeExternalContext)externalContext;
        Configuration configuration = bridgeExternalContext.getConfiguration();
        String className = configuration.getAttribute("auxiliaryContexts", "");
        if ("".equals(className)) {
            return;
        }
        try {
            Class<?> contextClass = Class.forName(className);
            Constructor<?> contextConstructor = contextClass.getDeclaredConstructors()[0];
            contextConstructor.setAccessible(true);
            contextConstructor.newInstance(facesContext);
        }
        catch (Throwable t) {
            log.error((Object)("Unable to add auxiliary context " + className), t);
        }
    }

    public static boolean objectsEqual(Object ob1, Object ob2) {
        if (ob1 == null && ob2 == null) {
            return true;
        }
        if (ob1 == null || ob2 == null) {
            return false;
        }
        return ob1.equals(ob2);
    }

    public static boolean throwablesEqual(Throwable th1, Throwable th2) {
        StackTraceElement[] st2;
        if (th1 == null && th2 == null) {
            return true;
        }
        if (th1 == null || th2 == null) {
            return false;
        }
        if (th1.getClass() != th2.getClass()) {
            return false;
        }
        if (!th1.getMessage().equals(th2.getMessage())) {
            return false;
        }
        StackTraceElement[] st1 = th1.getStackTrace();
        if (st1.length != (st2 = th2.getStackTrace()).length) {
            return false;
        }
        for (int i = 0; i < st1.length; ++i) {
            if (st1[i].equals(st2[i])) continue;
            return false;
        }
        return true;
    }

    public static String getRealPath(FacesContext facesContext, String path) {
        Object session = FacesContext.getCurrentInstance().getExternalContext().getSession(false);
        if (session == null) {
            log.error((Object)"getRealPath() session is null", (Throwable)new NullPointerException());
            return null;
        }
        if (CoreUtils.isPortletEnvironment()) {
            return CoreUtils.getRealPath(session, "getPortletContext", path);
        }
        return CoreUtils.getRealPath(session, "getServletContext", path);
    }

    private static String getRealPath(Object session, String getContext, String path) {
        try {
            Method getContextMethod = session.getClass().getMethod(getContext, null);
            Object context = getContextMethod.invoke(session, null);
            Class[] classargs = new Class[]{String.class};
            Method getRealPath = context.getClass().getMethod("getRealPath", classargs);
            Object[] args = new Object[]{path};
            return String.valueOf(getRealPath.invoke(context, args));
        }
        catch (Exception e) {
            log.error((Object)"Error getting realpath", (Throwable)e);
            return null;
        }
    }

    static {
        toolTipcounter = 1;
    }
}

