/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.el;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import javax.faces.el.EvaluationException;
import javax.faces.el.PropertyNotFoundException;
import javax.faces.el.PropertyResolver;
import javax.faces.el.ReferenceSyntaxException;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyResolverImpl
extends PropertyResolver {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$el$PropertyResolverImpl == null ? (class$org$apache$myfaces$el$PropertyResolverImpl = PropertyResolverImpl.class$("org.apache.myfaces.el.PropertyResolverImpl")) : class$org$apache$myfaces$el$PropertyResolverImpl));
    private static final Object[] NO_ARGS = new Object[0];
    static /* synthetic */ Class class$org$apache$myfaces$el$PropertyResolverImpl;
    static /* synthetic */ Class class$java$lang$Object;

    public Object getValue(Object base, Object property) throws EvaluationException, PropertyNotFoundException {
        try {
            if (base == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("property : " + property + " could not be retrieved as base was null."));
                }
                return null;
            }
            if (property == null || property instanceof String && ((String)property).length() == 0 && !(base instanceof Map)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("property for base with class: " + base.getClass().getName() + " could not be retrieved as property was null."));
                }
                return null;
            }
            if (base instanceof Map) {
                return ((Map)base).get(property);
            }
            return PropertyResolverImpl.getProperty(base, property.toString());
        }
        catch (PropertyNotFoundException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception while retrieving property; base with class : " + base.getClass().getName() + ", property : " + property), (Throwable)e);
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception while retrieving property; base : " + base.getClass().getName() + ", property : " + property), (Throwable)e);
            }
            throw new EvaluationException("Exception getting value of property " + property + " of base of type : " + base.getClass().getName(), (Throwable)e);
        }
    }

    public Object getValue(Object base, int index) throws EvaluationException, PropertyNotFoundException {
        try {
            if (base == null) {
                log.debug((Object)("index : " + index + " not retrievable cause base is null."));
                return null;
            }
            try {
                if (base.getClass().isArray()) {
                    return Array.get(base, index);
                }
                if (base instanceof List) {
                    return ((List)base).get(index);
                }
            }
            catch (IndexOutOfBoundsException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("IndexOutOfBoundException while getting property; base with class: " + base.getClass().getName() + ", index : " + index), (Throwable)e);
                }
                return null;
            }
            throw new ReferenceSyntaxException("Must be array or List. Bean with class: " + base.getClass().getName() + ", index " + index);
        }
        catch (RuntimeException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception while getting property; base with class: " + base.getClass().getName() + ", index : " + index), (Throwable)e);
            }
            throw new EvaluationException("Exception getting value for index " + index + " of bean " + base != null ? base.getClass().getName() : "NULL", (Throwable)e);
        }
    }

    public void setValue(Object base, Object property, Object newValue) throws EvaluationException, PropertyNotFoundException {
        try {
            if (base == null) {
                throw new PropertyNotFoundException("Null bean, property: " + property);
            }
            if (property == null || property instanceof String && ((String)property).length() == 0) {
                throw new PropertyNotFoundException("Bean with class : " + base.getClass().getName() + ", null or empty property name");
            }
            if (base instanceof Map) {
                ((Map)base).put(property, newValue);
                return;
            }
            PropertyResolverImpl.setProperty(base, property.toString(), newValue);
        }
        catch (PropertyNotFoundException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception while setting property; base with class : " + base.getClass().getName() + ", property : " + property), (Throwable)e);
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception while setting property; base : " + base.getClass().getName() + ", property : " + property), (Throwable)e);
            }
            throw new EvaluationException("Exception setting property " + property + " of base with class " + base.getClass().getName(), (Throwable)e);
        }
    }

    public void setValue(Object base, int index, Object newValue) throws EvaluationException, PropertyNotFoundException {
        try {
            if (base == null) {
                throw new PropertyNotFoundException("Null bean, index: " + index);
            }
            try {
                if (base.getClass().isArray()) {
                    Array.set(base, index, newValue);
                    return;
                }
                if (base instanceof List) {
                    ((List)base).set(index, newValue);
                    return;
                }
            }
            catch (IndexOutOfBoundsException e) {
                throw new PropertyNotFoundException("Base with class : " + base.getClass().getName() + ", index " + index, (Throwable)e);
            }
            throw new EvaluationException("Bean must be array or List. Base with class: " + base.getClass().getName() + ", index " + index);
        }
        catch (PropertyNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new EvaluationException("Exception setting value of index " + index + " of bean " + base.getClass().getName(), (Throwable)e);
        }
    }

    public boolean isReadOnly(Object base, Object property) {
        try {
            if (base == null || property == null || property instanceof String && ((String)property).length() == 0) {
                return false;
            }
            if (base instanceof Map) {
                return false;
            }
            PropertyDescriptor propertyDescriptor = PropertyResolverImpl.getPropertyDescriptor(base, property.toString());
            return propertyDescriptor.getWriteMethod() == null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isReadOnly(Object base, int index) {
        try {
            if (base == null) {
                return false;
            }
            if (base instanceof List || base.getClass().isArray()) {
                return false;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Class getType(Object base, Object property) {
        try {
            if (base == null) {
                throw new PropertyNotFoundException("Base bean is null.");
            }
            if (property == null) {
                throw new PropertyNotFoundException("Property name is null.");
            }
            if (property instanceof String && ((String)property).length() == 0) {
                throw new PropertyNotFoundException("Property name is an empty String.");
            }
            if (base instanceof Map) {
                Object value = ((Map)base).get(property);
                Class clazz = value == null ? (class$java$lang$Object == null ? (class$java$lang$Object = PropertyResolverImpl.class$("java.lang.Object")) : class$java$lang$Object) : value.getClass();
                return clazz;
            }
            PropertyDescriptor propertyDescriptor = PropertyResolverImpl.getPropertyDescriptor(base, property.toString());
            return propertyDescriptor.getPropertyType();
        }
        catch (PropertyNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Class getType(Object base, int index) {
        if (base == null) {
            throw new PropertyNotFoundException("Bean is null");
        }
        try {
            if (base.getClass().isArray()) {
                if (base instanceof Object[] && ((Object[])base)[index] != null) {
                    Object[] array = (Object[])base;
                    return array[index].getClass();
                }
                return base.getClass().getComponentType();
            }
            if (base instanceof List) {
                Object value = ((List)base).get(index);
                return value != null ? value.getClass() : (class$java$lang$Object == null ? (class$java$lang$Object = PropertyResolverImpl.class$("java.lang.Object")) : class$java$lang$Object);
            }
            return null;
        }
        catch (IndexOutOfBoundsException e) {
            throw new PropertyNotFoundException("Bean: " + base.getClass().getName() + ", index " + index, (Throwable)e);
        }
        catch (Exception e) {
            throw new EvaluationException("Exception getting type of index " + index + " of bean with class : " + base.getClass().getName(), (Throwable)e);
        }
    }

    public static void setProperty(Object base, String name, Object newValue) {
        PropertyDescriptor propertyDescriptor = PropertyResolverImpl.getPropertyDescriptor(base, name);
        Method m = propertyDescriptor.getWriteMethod();
        if (m == null) {
            throw new PropertyNotFoundException(PropertyResolverImpl.getMessage(base, name) + " (no write method for property!)");
        }
        if ((m = MethodUtils.getAccessibleMethod((Method)m)) == null) {
            throw new PropertyNotFoundException(PropertyResolverImpl.getMessage(base, name) + " (not accessible!)");
        }
        try {
            m.invoke(base, newValue);
        }
        catch (Throwable t) {
            log.debug((Object)"Exception while invoking setter method.", t);
            throw new EvaluationException(PropertyResolverImpl.getMessage(base, name, newValue, m), t);
        }
    }

    private static String getMessage(Object base, String name, Object newValue, Method m) {
        return "Bean: " + base.getClass().getName() + ", property: " + name + ", newValue: " + (newValue == null ? " null " : newValue) + ",newValue class: " + (newValue == null ? " null " : newValue.getClass().getName()) + " method parameter class: " + (m.getParameterTypes() != null && m.getParameterTypes().length > 0 ? m.getParameterTypes()[0].getName() : "null");
    }

    private static String getMessage(Object base, String name) {
        return "Bean: " + base.getClass().getName() + ", property: " + name;
    }

    public static Object getProperty(Object base, String name) {
        PropertyDescriptor propertyDescriptor = PropertyResolverImpl.getPropertyDescriptor(base, name);
        Method m = propertyDescriptor.getReadMethod();
        if (m == null) {
            throw new PropertyNotFoundException(PropertyResolverImpl.getMessage(base, name));
        }
        if ((m = MethodUtils.getAccessibleMethod((Method)m)) == null) {
            throw new PropertyNotFoundException(PropertyResolverImpl.getMessage(base, name) + " (not accessible!)");
        }
        try {
            return m.invoke(base, NO_ARGS);
        }
        catch (Throwable t) {
            throw new EvaluationException(PropertyResolverImpl.getMessage(base, name), t);
        }
    }

    public static PropertyDescriptor getPropertyDescriptor(Object base, String name) {
        PropertyDescriptor propertyDescriptor;
        try {
            propertyDescriptor = PropertyResolverImpl.getPropertyDescriptor(Introspector.getBeanInfo(base.getClass()), name);
        }
        catch (IntrospectionException e) {
            throw new PropertyNotFoundException(PropertyResolverImpl.getMessage(base, name), (Throwable)e);
        }
        return propertyDescriptor;
    }

    public static PropertyDescriptor getPropertyDescriptor(BeanInfo beanInfo, String propertyName) {
        PropertyDescriptor[] propDescriptors = beanInfo.getPropertyDescriptors();
        if (propDescriptors != null) {
            int len = propDescriptors.length;
            for (int i = 0; i < len; ++i) {
                if (!propDescriptors[i].getName().equals(propertyName)) continue;
                return propDescriptors[i];
            }
        }
        throw new PropertyNotFoundException("Bean: " + beanInfo.getBeanDescriptor().getBeanClass().getName() + ", property: " + propertyName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

