/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.context.rmi;

import java.lang.reflect.InvocationTargetException;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.remoting.support.RemoteInvocation;
import org.springframework.security.context.SecurityContext;
import org.springframework.security.context.SecurityContextHolder;

public class ContextPropagatingRemoteInvocation
extends RemoteInvocation {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$security$context$rmi$ContextPropagatingRemoteInvocation == null ? (class$org$springframework$security$context$rmi$ContextPropagatingRemoteInvocation = ContextPropagatingRemoteInvocation.class$("org.springframework.security.context.rmi.ContextPropagatingRemoteInvocation")) : class$org$springframework$security$context$rmi$ContextPropagatingRemoteInvocation));
    private SecurityContext securityContext = SecurityContextHolder.getContext();
    static /* synthetic */ Class class$org$springframework$security$context$rmi$ContextPropagatingRemoteInvocation;

    public ContextPropagatingRemoteInvocation(MethodInvocation methodInvocation) {
        super(methodInvocation);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("RemoteInvocation now has SecurityContext: " + this.securityContext));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object targetObject) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        SecurityContextHolder.setContext(this.securityContext);
        if (SecurityContextHolder.getContext() != null && SecurityContextHolder.getContext().getAuthentication() != null) {
            SecurityContextHolder.getContext().getAuthentication().setAuthenticated(false);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Set SecurityContextHolder to contain: " + this.securityContext));
        }
        try {
            Object object = super.invoke(targetObject);
            return object;
        }
        finally {
            SecurityContextHolder.clearContext();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Set SecurityContext to new instance of SecurityContextImpl");
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

