/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.jcharts.chartData.processors;

import java.awt.font.FontRenderContext;
import java.util.Iterator;
import org.krysalis.jcharts.axisChart.AxisChart;
import org.krysalis.jcharts.chartData.interfaces.IAxisChartDataSet;
import org.krysalis.jcharts.chartData.interfaces.IAxisPlotDataSet;
import org.krysalis.jcharts.chartData.interfaces.IDataSeries;
import org.krysalis.jcharts.chartData.interfaces.IStockChartDataSet;
import org.krysalis.jcharts.chartData.processors.NonStackedDataProcessor;
import org.krysalis.jcharts.chartData.processors.StackedDataProcessor;
import org.krysalis.jcharts.chartData.processors.StockDataProcessor;
import org.krysalis.jcharts.properties.DataAxisProperties;
import org.krysalis.jcharts.types.ChartType;

public class AxisChartDataProcessor {
    private double max;
    private double min;
    private int numberOfElementsInADataSet;

    public void processData(AxisChart axisChart, FontRenderContext fontRenderContext) {
        DataAxisProperties dataAxisProperties = axisChart.getAxisProperties().isPlotHorizontal() ? (DataAxisProperties)axisChart.getAxisProperties().getXAxisProperties() : (DataAxisProperties)axisChart.getAxisProperties().getYAxisProperties();
        if (!dataAxisProperties.hasUserDefinedScale()) {
            this.processDataSet((IDataSeries)axisChart.getIAxisDataSeries());
        }
        Iterator iterator = axisChart.getIAxisDataSeries().getIAxisPlotDataSetIterator();
        IAxisPlotDataSet iAxisPlotDataSet = (IAxisPlotDataSet)iterator.next();
        this.numberOfElementsInADataSet = iAxisPlotDataSet.getNumberOfDataItems();
    }

    private void processDataSet(IDataSeries iDataSeries) {
        Iterator iterator = iDataSeries.getIAxisPlotDataSetIterator();
        while (iterator.hasNext()) {
            IAxisPlotDataSet iAxisPlotDataSet = (IAxisPlotDataSet)iterator.next();
            if (iAxisPlotDataSet.getChartType().isStacked()) {
                StackedDataProcessor.processData((IAxisChartDataSet)iAxisPlotDataSet, this);
                continue;
            }
            if (iAxisPlotDataSet.getChartType().equals(ChartType.STOCK)) {
                StockDataProcessor.processData((IStockChartDataSet)iAxisPlotDataSet, this);
                continue;
            }
            NonStackedDataProcessor.processData((IAxisChartDataSet)iAxisPlotDataSet, this);
        }
    }

    void setMaxValue(double d) {
        this.max = d;
    }

    public double getMaxValue() {
        return this.max;
    }

    void setMinValue(double d) {
        this.min = d;
    }

    public double getMinValue() {
        return this.min;
    }

    public int getNumberOfElementsInADataSet() {
        return this.numberOfElementsInADataSet;
    }
}

