/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.swing;

import antlr.CommonASTWithHiddenTokens;
import antlr.collections.AST;
import antlr.debug.misc.JTreeASTModel;
import antlr.debug.misc.JTreeASTPanel;
import de.hunsicker.io.IoHelper;
import de.hunsicker.jalopy.Jalopy;
import de.hunsicker.jalopy.storage.ConventionKeys;
import de.hunsicker.jalopy.storage.Loggers;
import de.hunsicker.jalopy.swing.AbstractSettingsPage;
import de.hunsicker.jalopy.swing.LocationDialog;
import de.hunsicker.jalopy.swing.syntax.DefaultSyntaxDocument;
import de.hunsicker.jalopy.swing.syntax.SyntaxEditorKit;
import de.hunsicker.swing.util.SwingHelper;
import de.hunsicker.util.ResourceBundleFactory;
import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.TreePath;
import org.apache.log4j.Level;

final class PreviewFrame
extends JDialog {
    private static final String EXT_JAVA = ".java";
    static final String EMPTY_STRING = "".intern();
    boolean customFile;
    AbstractSettingsPage _page;
    final Action ACTION_FILE_CLOSE = new FileCloseAction();
    private final Action ACTION_FILE_OPEN = new FileOpenAction();
    private final Action TREE_VIEW_ACTION = new TreeViewAction();
    JEditorPane _textArea;
    Jalopy _jalopy = new Jalopy();
    List _threads = new ArrayList(3);
    ResourceBundle bundle;
    private Window _dialog;
    private boolean _wasVisible;
    JEditorPane _textOriginal = null;

    protected PreviewFrame(Dialog owner) {
        super(owner);
        this.initialize();
        this.setTitle(this.bundle.getString("TLE_PREVIEW"));
    }

    protected PreviewFrame(Frame owner) {
        super(owner);
        this.initialize();
        this.setTitle(this.bundle.getString("TLE_PREVIEW"));
    }

    public static PreviewFrame create(Window owner) {
        return PreviewFrame.create(owner, owner);
    }

    public void setCurrentPage(AbstractSettingsPage page) {
        this._page = page;
    }

    public AbstractSettingsPage getCurrentPage() {
        return this._page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setText(String text) {
        if (text == null) {
            text = this._textOriginal.getText();
        }
        List list = this._threads;
        synchronized (list) {
            FormatThread thread;
            if (this._threads.size() > 0) {
                try {
                    thread = (FormatThread)this._threads.remove(0);
                    thread.interrupt();
                    if (thread.isAlive()) {
                        thread.join(50L);
                    }
                }
                catch (InterruptedException ignored) {
                    // empty catch block
                }
                this._jalopy.reset();
            }
            thread = new FormatThread(text);
            this._textOriginal.setText(text);
            ((DefaultSyntaxDocument)this._textOriginal.getDocument()).tokenizeLines();
            this._threads.add(thread);
            thread.start();
        }
    }

    public String getText() {
        return this._textOriginal.getText();
    }

    public void show() {
        if (!this._wasVisible) {
            Dimension screen = this.getToolkit().getScreenSize();
            int screenWidth = screen.width;
            int screenHeight = screen.height;
            int dialogWidth = this._dialog.getWidth();
            int dialogY = this._dialog.getY();
            int frameWidth = 600;
            if (screenWidth > dialogWidth + frameWidth) {
                this._dialog.setLocation((screenWidth - frameWidth - dialogWidth) / 2, dialogY);
                this.setSize(frameWidth, screenHeight - 30);
                this.setLocation(this._dialog.getX() + dialogWidth, 1);
            } else {
                this._dialog.setLocation(1, dialogY);
                this.setSize(screenWidth - dialogWidth - 2, screenHeight - 30);
                this.setLocation(this._dialog.getX() + dialogWidth, 1);
            }
            this._wasVisible = true;
        }
        super.show();
        this._dialog.toFront();
    }

    public void update() {
        this.setText(this._textOriginal.getText());
    }

    static PreviewFrame create(Window owner, Window target) {
        PreviewFrame frame = null;
        frame = owner instanceof Frame ? new PreviewFrame((Frame)owner) : new PreviewFrame((Dialog)owner);
        frame._dialog = target;
        return frame;
    }

    private void initialize() {
        this.bundle = ResourceBundleFactory.getBundle("de.hunsicker.jalopy.swing.Bundle");
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new BorderLayout());
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu();
        SwingHelper.setMenuText(fileMenu, this.bundle.getString("MNE_FILE"), true);
        menuBar.add(fileMenu);
        JMenuItem openFileMenuItem = new JMenuItem(this.ACTION_FILE_OPEN);
        SwingHelper.setMenuText(openFileMenuItem, this.bundle.getString("MNE_OPEN"), true);
        fileMenu.add(openFileMenuItem);
        JMenuItem closeFileMenuItem = new JMenuItem(this.ACTION_FILE_CLOSE);
        SwingHelper.setMenuText(closeFileMenuItem, this.bundle.getString("MNE_CLOSE"), true);
        fileMenu.add(closeFileMenuItem);
        JMenuItem treeViewItem = new JMenuItem(this.TREE_VIEW_ACTION);
        SwingHelper.setMenuText(treeViewItem, "Tree view", true);
        fileMenu.add(treeViewItem);
        this.setJMenuBar(menuBar);
        SyntaxEditorKit kit = new SyntaxEditorKit();
        DefaultSyntaxDocument doc = new DefaultSyntaxDocument();
        doc.setAsynchronousLoadPriority(-1);
        this._textArea = new JEditorPane();
        this._textArea.setDocument(doc);
        this._textArea.setFont(new Font("Monospaced", 0, 12));
        this._textArea.setEditable(false);
        this._textArea.setCaretPosition(0);
        this._textArea.setMargin(new Insets(2, 2, 2, 2));
        this._textArea.setOpaque(true);
        this._textArea.setEditorKit(kit);
        JScrollPane scrollPane = new JScrollPane(this._textArea);
        JTabbedPane mainTabbedPane = new JTabbedPane();
        doc = new DefaultSyntaxDocument();
        doc.setAsynchronousLoadPriority(-1);
        this._textOriginal = new JEditorPane();
        this._textOriginal.setDocument(doc);
        this._textOriginal.setFont(new Font("Monospaced", 0, 12));
        this._textOriginal.setEditable(false);
        this._textOriginal.setCaretPosition(0);
        this._textOriginal.setMargin(new Insets(2, 2, 2, 2));
        this._textOriginal.setOpaque(true);
        this._textOriginal.setEditorKit(new SyntaxEditorKit());
        mainTabbedPane.add("Original", new JScrollPane(this._textOriginal));
        mainTabbedPane.add("Formatted", scrollPane);
        this.getContentPane().add(mainTabbedPane);
    }

    private class JavaFilter
    extends FileFilter {
        private JavaFilter() {
        }

        public String getDescription() {
            return PreviewFrame.this.bundle.getString("LBL_JAVA_SOURCE_FILES");
        }

        public boolean accept(File f) {
            if (f == null) {
                return false;
            }
            if (f.isDirectory()) {
                return true;
            }
            return f.getName().endsWith(PreviewFrame.EXT_JAVA);
        }
    }

    private class FormatThread
    extends Thread {
        String text;

        public FormatThread(String text) {
            this.text = text;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object buf;
            Level ioLevel = null;
            Level parserLevel = null;
            Level parserJavadocLevel = null;
            Level printerLevel = null;
            Level printerJavadocLevel = null;
            ioLevel = Loggers.IO.getLevel();
            parserLevel = Loggers.PARSER.getLevel();
            parserJavadocLevel = Loggers.PARSER_JAVADOC.getLevel();
            printerLevel = Loggers.PRINTER.getLevel();
            printerJavadocLevel = Loggers.PRINTER_JAVADOC.getLevel();
            PreviewFrame.this._page.settings.snapshot();
            try {
                PreviewFrame.this._page.updateSettings();
                Loggers.IO.setLevel(Level.FATAL);
                Loggers.PARSER.setLevel(Level.FATAL);
                Loggers.PARSER_JAVADOC.setLevel(Level.FATAL);
                Loggers.PRINTER.setLevel(Level.WARN);
                Loggers.PRINTER_JAVADOC.setLevel(Level.FATAL);
                if (!PreviewFrame.this.customFile) {
                    if (PreviewFrame.this._page.getCategory().equals("header")) {
                        PreviewFrame.this._page.settings.putBoolean(ConventionKeys.FOOTER, false);
                    } else if (PreviewFrame.this._page.getCategory().equals("footer")) {
                        PreviewFrame.this._page.settings.putBoolean(ConventionKeys.HEADER, false);
                    } else {
                        PreviewFrame.this._page.settings.putBoolean(ConventionKeys.FOOTER, false);
                        PreviewFrame.this._page.settings.putBoolean(ConventionKeys.HEADER, false);
                        if (PreviewFrame.this._page.getCategory().equals("indentation")) {
                            PreviewFrame.this._page.settings.putBoolean(ConventionKeys.LINE_WRAP_BEFORE_EXTENDS, true);
                            PreviewFrame.this._page.settings.putBoolean(ConventionKeys.LINE_WRAP_BEFORE_IMPLEMENTS, true);
                            PreviewFrame.this._page.settings.putBoolean(ConventionKeys.LINE_WRAP_BEFORE_THROWS, true);
                            PreviewFrame.this._page.settings.putBoolean(ConventionKeys.LINE_WRAP_AFTER_PARAMS_METHOD_DEF, true);
                            PreviewFrame.this._page.settings.putBoolean(ConventionKeys.ALIGN_TERNARY_EXPRESSION, true);
                            PreviewFrame.this._page.settings.putBoolean(ConventionKeys.ALIGN_TERNARY_VALUES, true);
                        }
                    }
                    if (!PreviewFrame.this._page.getCategory().equals("javadoc")) {
                        // empty if block
                    }
                    if (!PreviewFrame.this._page.getPreviewFileName().equals("separationcomments")) {
                        // empty if block
                    }
                }
                PreviewFrame.this._textArea.getDocument().putProperty("tabSize", new Integer(PreviewFrame.this._page.settings.get(ConventionKeys.INDENT_SIZE, String.valueOf(4))));
                PreviewFrame.this._jalopy.setForce(true);
                if (this.text.length() > 0) {
                    PreviewFrame.this._jalopy.setInput(this.text, PreviewFrame.this._page.getCategory() + PreviewFrame.EXT_JAVA);
                    buf = new StringBuffer(this.text.length());
                    PreviewFrame.this._jalopy.setOutput((StringBuffer)buf);
                    PreviewFrame.this._jalopy.setInspect(true);
                    PreviewFrame.this._jalopy.format();
                    SwingUtilities.invokeLater(new Runnable(this, (StringBuffer)buf){
                        private final /* synthetic */ StringBuffer val$buf;
                        private final /* synthetic */ FormatThread this$1;
                        {
                            this.this$1 = this$1;
                            this.val$buf = val$buf;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            int offset = FormatThread.access$200((FormatThread)this.this$1)._textArea.getCaretPosition();
                            JEditorPane jEditorPane = FormatThread.access$200((FormatThread)this.this$1)._textArea;
                            synchronized (jEditorPane) {
                                FormatThread.access$200((FormatThread)this.this$1)._textArea.setText(this.val$buf.toString());
                                ((DefaultSyntaxDocument)FormatThread.access$200((FormatThread)this.this$1)._textArea.getDocument()).tokenizeLines();
                            }
                            if (FormatThread.access$200((FormatThread)this.this$1)._textArea.getDocument().getLength() > offset) {
                                FormatThread.access$200((FormatThread)this.this$1)._textArea.setCaretPosition(offset);
                            }
                        }
                    });
                } else {
                    PreviewFrame.this._textArea.setText(this.text);
                }
            }
            catch (Throwable ignored) {
                ignored.printStackTrace();
            }
            finally {
                PreviewFrame.this._page.settings.revert();
                if (EMPTY_STRING.equals(PreviewFrame.this._textArea.getText())) {
                    PreviewFrame.this._textArea.setText(this.text);
                }
                PreviewFrame.this._jalopy.reset();
                Loggers.IO.setLevel(ioLevel);
                Loggers.PARSER.setLevel(parserLevel);
                Loggers.PARSER_JAVADOC.setLevel(parserJavadocLevel);
                Loggers.PRINTER.setLevel(printerLevel);
                Loggers.PRINTER_JAVADOC.setLevel(printerJavadocLevel);
                buf = PreviewFrame.this._threads;
                synchronized (buf) {
                    PreviewFrame.this._threads.remove(this);
                }
            }
        }

        static /* synthetic */ PreviewFrame access$200(FormatThread x0) {
            return x0.PreviewFrame.this;
        }
    }

    private final class FileOpenAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent ev) {
            LocationDialog dialog = LocationDialog.create(PreviewFrame.this, PreviewFrame.this.bundle.getString("TLE_OPEN_JAVA_FILE"), "XXX", EMPTY_STRING);
            dialog.addFilter(new JavaFilter(), true);
            dialog.setVisible(true);
            switch (dialog.getOption()) {
                case 0: {
                    try {
                        String location = (String)dialog.getSelectedLocation();
                        if (location == null || location.trim().length() == 0) {
                            return;
                        }
                        File file = new File(location);
                        String contents = IoHelper.readTextFile(file);
                        PreviewFrame.this.setText(contents);
                        PreviewFrame.this.customFile = true;
                        PreviewFrame.this.ACTION_FILE_CLOSE.setEnabled(true);
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                    break;
                }
            }
        }
    }

    private final class TreeViewAction
    extends AbstractAction {
        private TreeViewAction() {
        }

        public void actionPerformed(ActionEvent ev) {
            AST root = PreviewFrame.this._jalopy.getRecognizer().getRoot();
            final JFrame frame = new JFrame("Java AST");
            frame.setVisible(true);
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    frame.setVisible(false);
                    frame.dispose();
                }
            });
            JTreeASTPanel panel = new JTreeASTPanel(new JTreeASTModel(this, root){
                private final /* synthetic */ TreeViewAction this$1;
                {
                    this.this$1 = this$1;
                    super(x0);
                }
            }, new TreeSelectionListener(this){
                private final /* synthetic */ TreeViewAction this$1;
                {
                    this.this$1 = this$1;
                }

                public void valueChanged(TreeSelectionEvent event) {
                    TreePath path = event.getPath();
                    System.out.println("Selected: ," + ((CommonASTWithHiddenTokens)path.getLastPathComponent()).getLine() + "," + ((CommonASTWithHiddenTokens)path.getLastPathComponent()).getColumn() + "\n\r" + ((CommonASTWithHiddenTokens)path.getLastPathComponent()).getHiddenBefore() + "\n\r" + ((CommonASTWithHiddenTokens)path.getLastPathComponent()).getHiddenAfter());
                    Object[] elements = path.getPath();
                    int i = 0;
                    while (i < elements.length) {
                        System.out.print("->" + elements[i].getClass());
                        ++i;
                    }
                    System.out.println();
                }
            });
            frame.getContentPane().add(panel);
        }
    }

    private final class FileCloseAction
    extends AbstractAction {
        public FileCloseAction() {
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent ev) {
            PreviewFrame.this.customFile = false;
            String filename = PreviewFrame.this.getCurrentPage().getPreviewFileName();
            PreviewFrame.this.setText(PreviewFrame.this.getCurrentPage().getContainer().loadPreview(filename));
            this.setEnabled(false);
        }
    }
}

