/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.push.server;

import com.icesoft.faces.webapp.http.common.Configuration;
import com.icesoft.net.messaging.MessageHandler;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.icefaces.push.server.BufferedContextEventsMessageHandler;
import org.icefaces.push.server.ContextEventMessageHandler;
import org.icefaces.push.server.Handler;
import org.icefaces.push.server.PushServerMessageService;
import org.icefaces.push.server.RequestManager;
import org.icefaces.push.server.UpdatedViews;
import org.icefaces.push.server.UpdatedViewsManager;
import org.icefaces.push.server.UpdatedViewsMessageHandler;

public class SessionManager
implements BufferedContextEventsMessageHandler.Callback,
ContextEventMessageHandler.Callback,
UpdatedViewsMessageHandler.Callback {
    private static final Log LOG = LogFactory.getLog((Class)SessionManager.class);
    private final Map sessionMap = new HashMap();
    private final Map freeMap = new HashMap();
    private final RequestManager requestManager;
    private final UpdatedViewsManager updatedViewsManager;
    private PushServerMessageService pushServerMessageService;

    public SessionManager(Configuration configuration, PushServerMessageService pushServerMessageService) {
        this.pushServerMessageService = pushServerMessageService;
        this.pushServerMessageService.getBufferedContextEventsMessageHandler().addCallback((MessageHandler.Callback)this);
        this.pushServerMessageService.getContextEventMessageHandler().addCallback((MessageHandler.Callback)this);
        this.pushServerMessageService.getUpdatedViewsMessageHandler().addCallback((MessageHandler.Callback)this);
        this.requestManager = new RequestManager();
        this.updatedViewsManager = new UpdatedViewsManager(configuration, pushServerMessageService, this);
    }

    public PushServerMessageService getPushServerMessageService() {
        return this.pushServerMessageService;
    }

    public RequestManager getRequestManager() {
        return this.requestManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getServletContextPath(String iceFacesId) {
        Map map = this.sessionMap;
        synchronized (map) {
            if (this.sessionMap.containsKey(iceFacesId)) {
                return ((Session)this.sessionMap.get(iceFacesId)).servletContextPath;
            }
        }
        return null;
    }

    public UpdatedViewsManager getUpdatedViewsManager() {
        return this.updatedViewsManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iceFacesIdDisposed(String servletContextPath, String iceFacesId) {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException exception) {
            // empty catch block
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("ICEfaces ID disposed: Servlet Context Path [" + servletContextPath + "], " + "ICEfaces ID [" + iceFacesId + "]"));
        }
        Map exception = this.freeMap;
        synchronized (exception) {
            this.freeMap.put(iceFacesId, new Record(iceFacesId, System.currentTimeMillis()));
        }
        Handler _handler = this.requestManager.pull(iceFacesId);
        if (_handler != null) {
            _handler.handle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iceFacesIdRetrieved(String servletContextPath, String iceFacesId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("ICEfaces ID retrieved: Servlet Context Path [" + servletContextPath + "], " + "ICEfaces ID [" + iceFacesId + "]"));
        }
        Map map = this.sessionMap;
        synchronized (map) {
            this.cleanUp(iceFacesId);
            if (!this.sessionMap.containsKey(iceFacesId)) {
                this.sessionMap.put(iceFacesId, new Session(servletContextPath, iceFacesId));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasViews(Set iceFacesIdSet) {
        boolean _hasViews = false;
        Map map = this.sessionMap;
        synchronized (map) {
            String[] _iceFacesIds = iceFacesIdSet.toArray(new String[iceFacesIdSet.size()]);
            for (int i = 0; i < _iceFacesIds.length; ++i) {
                if (!this.hasViews(_iceFacesIds[i])) continue;
                _hasViews = true;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Has Views [" + iceFacesIdSet + "]: " + _hasViews));
        }
        return _hasViews;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasViews(String iceFacesId) {
        boolean _hasViews;
        Map map = this.sessionMap;
        synchronized (map) {
            _hasViews = this.sessionMap.containsKey(iceFacesId) && !((Session)this.sessionMap.get(iceFacesId)).viewNumberSet.isEmpty();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Has Views [" + iceFacesId + "]: " + _hasViews));
        }
        return _hasViews;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid(Set iceFacesIdSet) {
        boolean _isValid = false;
        Map map = this.sessionMap;
        synchronized (map) {
            String[] _iceFacesIds = iceFacesIdSet.toArray(new String[iceFacesIdSet.size()]);
            for (int i = 0; i < _iceFacesIds.length; ++i) {
                if (!this.isValid(_iceFacesIds[i])) continue;
                _isValid = true;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Is valid [" + iceFacesIdSet + "]: " + _isValid));
        }
        return _isValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid(String iceFacesId) {
        boolean _isValid;
        Map map = this.sessionMap;
        synchronized (map) {
            Map map2 = this.freeMap;
            synchronized (map2) {
                _isValid = this.sessionMap.containsKey(iceFacesId) && !this.freeMap.containsKey(iceFacesId);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Is valid [" + iceFacesId + "]: " + _isValid));
        }
        return _isValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendUpdatedViews(UpdatedViews updatedViews) {
        Map map = this.sessionMap;
        synchronized (map) {
            if (this.isValid(updatedViews.getICEfacesID())) {
                this.updatedViewsManager.push(updatedViews);
                Handler _handler = this.requestManager.pull(updatedViews.getICEfacesID());
                if (_handler != null) {
                    _handler.handle();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void viewNumberDisposed(String servletContextPath, String iceFacesId, String viewNumber) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("View Number disposed: Servlet Context Path [" + servletContextPath + "], " + "ICEfaces ID [" + iceFacesId + "], " + "View Number [" + viewNumber + "]"));
        }
        Map map = this.sessionMap;
        synchronized (map) {
            Set _viewNumberSet;
            if (this.sessionMap.containsKey(iceFacesId) && (_viewNumberSet = ((Session)this.sessionMap.get(iceFacesId)).viewNumberSet).contains(viewNumber)) {
                Handler _handler;
                _viewNumberSet.remove(viewNumber);
                this.updatedViewsManager.remove(iceFacesId, viewNumber);
                if (!this.hasViews(iceFacesId) && (_handler = this.requestManager.pull(iceFacesId)) != null) {
                    _handler.handle();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void viewNumberRetrieved(String servletContextPath, String iceFacesId, String viewNumber) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("View Number retrieved: Servlet Context Path [" + servletContextPath + "], " + "ICEfaces ID [" + iceFacesId + "], " + "View Number [" + viewNumber + "]"));
        }
        Map map = this.sessionMap;
        synchronized (map) {
            Set _viewNumberSet;
            if (this.sessionMap.containsKey(iceFacesId) && !(_viewNumberSet = ((Session)this.sessionMap.get(iceFacesId)).viewNumberSet).contains(viewNumber)) {
                _viewNumberSet.add(viewNumber);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUp(String iceFacesId) {
        Map map = this.sessionMap;
        synchronized (map) {
            Map map2 = this.freeMap;
            synchronized (map2) {
                Iterator _records = this.freeMap.values().iterator();
                int _size = this.freeMap.size();
                long _currentTime = System.currentTimeMillis();
                for (int i = 0; i < _size; ++i) {
                    Record _record = (Record)_records.next();
                    if (iceFacesId.equals(_record.iceFacesId)) {
                        _records.remove();
                        continue;
                    }
                    if (_currentTime - _record.timestamp < 60000L) continue;
                    if (this.sessionMap.containsKey(iceFacesId)) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("ICEfaces ID cleaned up: ICEfaces ID [" + iceFacesId + "]"));
                        }
                        this.sessionMap.remove(iceFacesId);
                    }
                    this.updatedViewsManager.remove(iceFacesId);
                    _records.remove();
                }
            }
        }
    }

    private static class Session {
        private final Set viewNumberSet = new HashSet();
        private String servletContextPath;
        private String iceFacesId;

        private Session(String servletContextPath, String iceFacesId) {
            this.servletContextPath = servletContextPath;
            this.iceFacesId = iceFacesId;
        }
    }

    private static class Record {
        private final String iceFacesId;
        private final long timestamp;

        private Record(String iceFacesId, long timestamp) {
            this.iceFacesId = iceFacesId;
            this.timestamp = timestamp;
        }
    }
}

