/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.jcharts.axisChart.axis;

import java.awt.font.TextLayout;
import java.io.Serializable;
import java.lang.reflect.Field;
import org.krysalis.jcharts.axisChart.AxisChart;
import org.krysalis.jcharts.axisChart.axis.scale.ScaleCalculator;
import org.krysalis.jcharts.chartText.TextTagGroup;
import org.krysalis.jcharts.properties.AxisTypeProperties;
import org.krysalis.jcharts.properties.DataAxisProperties;
import org.krysalis.jcharts.properties.util.ChartFont;
import org.krysalis.jcharts.test.HTMLGenerator;
import org.krysalis.jcharts.test.HTMLTestable;

public abstract class Axis
implements HTMLTestable,
Serializable {
    private AxisChart axisChart;
    private float scalePixelWidth;
    private float pixelLength;
    private float origin;
    private float titleHeight;
    private float titleWidth;
    private float minimumWidthNeeded;
    private float minimumHeightNeeded;
    private TextTagGroup axisLabelsGroup;
    private TextTagGroup axisLabelsGroupRight;
    private int numberOfScaleItems;
    private float tickStart;
    private double oneUnitPixelSize;
    private float zeroLineCoordinate;
    private ScaleCalculator scaleCalculator;

    public Axis(AxisChart axisChart, int n) {
        this.axisChart = axisChart;
        this.numberOfScaleItems = n;
    }

    public final AxisChart getAxisChart() {
        return this.axisChart;
    }

    public int getNumberOfScaleItems() {
        return this.numberOfScaleItems;
    }

    public TextTagGroup getAxisLabelsGroup() {
        return this.axisLabelsGroup;
    }

    public void setAxisLabelsGroup(TextTagGroup textTagGroup) {
        this.axisLabelsGroup = textTagGroup;
    }

    public TextTagGroup getAxisLabelsGroupRight() {
        return this.axisLabelsGroupRight;
    }

    public void setAxisLabelsGroupRight(TextTagGroup textTagGroup) {
        this.axisLabelsGroupRight = textTagGroup;
    }

    public final float getTitleWidth() {
        return this.titleWidth;
    }

    public final float getTitleHeight() {
        return this.titleHeight;
    }

    public final float getPixelLength() {
        return this.pixelLength;
    }

    public final void setPixelLength(float f) {
        this.pixelLength = f;
    }

    public final float getOrigin() {
        return this.origin;
    }

    public final void setOrigin(float f) {
        this.origin = f;
    }

    public final float getMinimumWidthNeeded() {
        return this.minimumWidthNeeded;
    }

    public final void setMinimumWidthNeeded(float f) {
        this.minimumWidthNeeded = f;
    }

    public final float getMinimumHeightNeeded() {
        return this.minimumHeightNeeded;
    }

    public final void setMinimumHeightNeeded(float f) {
        this.minimumHeightNeeded = f;
    }

    public final float getScalePixelWidth() {
        return this.scalePixelWidth;
    }

    public final void setScalePixelWidth(float f) {
        this.scalePixelWidth = f;
    }

    public float getTickStart() {
        return this.tickStart;
    }

    public void setTickStart(float f) {
        this.tickStart = f;
    }

    public ScaleCalculator getScaleCalculator() {
        return this.scaleCalculator;
    }

    public void setScaleCalculator(ScaleCalculator scaleCalculator) {
        this.scaleCalculator = scaleCalculator;
    }

    public final void computeAxisTitleDimensions(String string, ChartFont chartFont) {
        TextLayout textLayout = new TextLayout(string, chartFont.getFont(), this.getAxisChart().getGraphics2D().getFontRenderContext());
        this.titleWidth = textLayout.getAdvance();
        this.titleHeight = textLayout.getAscent() + textLayout.getDescent();
    }

    public void toHTML(HTMLGenerator hTMLGenerator) {
        String string = this.getClass().getSuperclass().getName() + "->";
        Field[] fieldArray = this.getClass().getSuperclass().getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            try {
                hTMLGenerator.addField(string + fieldArray[i].getName(), fieldArray[i].get(this));
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
    }

    public void computeScalePixelWidth(AxisTypeProperties axisTypeProperties) {
        this.setScalePixelWidth(this.getPixelLength() / (float)this.getNumberOfScaleItems());
    }

    public void computeScalePixelWidthDataAxis(AxisTypeProperties axisTypeProperties) {
        if (axisTypeProperties instanceof DataAxisProperties) {
            this.setScalePixelWidth((this.getPixelLength() - 5.0f) / (float)(this.numberOfScaleItems - 1));
        } else {
            this.setScalePixelWidth(this.getPixelLength() / (float)(this.numberOfScaleItems - 1));
        }
    }

    public void setOneUnitPixelSize(double d) {
        this.oneUnitPixelSize = d;
    }

    public double getOneUnitPixelSize() {
        return this.oneUnitPixelSize;
    }

    public float getZeroLineCoordinate() {
        return this.zeroLineCoordinate;
    }

    public void setZeroLineCoordinate(float f) {
        this.zeroLineCoordinate = f;
    }

    public void computeOneUnitPixelSize(float f, double d) {
        this.oneUnitPixelSize = (double)f / d;
    }
}

