/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.outputresource;

import com.icesoft.faces.component.outputresource.OutputResource;
import com.icesoft.faces.context.FileResource;
import com.icesoft.faces.context.Resource;
import com.icesoft.faces.webapp.http.core.ResourceDispatcher;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.Map;
import javax.faces.context.FacesContext;

class RegisteredResource
implements Resource {
    private final Resource resource;
    private final String fileName;
    private String label;
    private Date lastModified;
    private String mimeType;
    private boolean isAttachment;
    private boolean isShared;
    private String contentDispositionFileName;

    public RegisteredResource(OutputResource outputResource, Resource resource, String fileName) {
        this.resource = resource;
        this.fileName = fileName;
        this.label = outputResource.getLabel();
        this.lastModified = outputResource.getLastModified();
        this.mimeType = outputResource.getMimeType();
        this.isAttachment = outputResource.isAttachment();
        this.isShared = outputResource.isShared();
        this.contentDispositionFileName = RegisteredResource.encodeContentDispositionFilename(fileName);
    }

    public String calculateDigest() {
        return this.resource.calculateDigest() + (this.isShared ? "" : String.valueOf(this.hashCode()));
    }

    public Date lastModified() {
        return this.lastModified;
    }

    public InputStream open() throws IOException {
        return this.resource.open();
    }

    public void withOptions(Resource.Options options) {
        ResourceOptions resourceOptions = new ResourceOptions();
        try {
            this.resource.withOptions((Resource.Options)resourceOptions);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (resourceOptions.fileName != null) {
            options.setFileName(resourceOptions.fileName);
        } else if (this.fileName != null) {
            options.setFileName(this.fileName);
        } else if (this.resource instanceof FileResource) {
            options.setFileName(((FileResource)this.resource).getFile().getName());
        } else if (this.label != null) {
            options.setFileName(this.label.replace(' ', '_'));
        }
        if (resourceOptions.lastModified != null) {
            options.setLastModified(resourceOptions.lastModified);
        } else if (this.lastModified != null) {
            options.setLastModified(this.lastModified);
        }
        if (resourceOptions.mimeType != null) {
            options.setMimeType(resourceOptions.mimeType);
        } else if (this.mimeType != null) {
            options.setMimeType(this.mimeType);
        }
        if (resourceOptions.isAttachment) {
            options.setAsAttachement();
        } else if (this.isAttachment) {
            options.setAsAttachement();
        }
        if (options instanceof ResourceDispatcher.ExtendedResourceOptions) {
            ((ResourceDispatcher.ExtendedResourceOptions)options).setContentDispositionFileName(this.contentDispositionFileName);
        }
    }

    private static String encodeContentDispositionFilename(String fileName) {
        if (fileName == null || fileName.trim().length() == 0) {
            return null;
        }
        String defaultFileName = "=\"" + fileName + "\"";
        String userAgent = null;
        Map headerMap = FacesContext.getCurrentInstance().getExternalContext().getRequestHeaderMap();
        userAgent = (String)headerMap.get("user-agent");
        if (userAgent == null || userAgent.trim().length() == 0) {
            return defaultFileName;
        }
        userAgent = userAgent.toLowerCase();
        try {
            if (userAgent.indexOf("msie") > -1) {
                return RegisteredResource.encodeForIE(fileName);
            }
            if (userAgent.indexOf("firefox") > -1 || userAgent.indexOf("opera") > -1) {
                return RegisteredResource.encodeForFirefox(fileName);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return defaultFileName;
    }

    private static String encodeForIE(String fileName) throws UnsupportedEncodingException {
        StringBuffer encodedFileName = new StringBuffer();
        encodedFileName.append("=\"");
        encodedFileName.append(URLEncoder.encode(fileName, "UTF-8").replaceAll("\\+", "%20"));
        encodedFileName.append("\"");
        return encodedFileName.toString();
    }

    private static String encodeForFirefox(String fileName) throws UnsupportedEncodingException {
        StringBuffer encodedFileName = new StringBuffer();
        encodedFileName.append("*=UTF-8''");
        encodedFileName.append(URLEncoder.encode(fileName, "UTF-8").replaceAll("\\+", "%20"));
        return encodedFileName.toString();
    }

    private class ResourceOptions
    implements Resource.Options {
        private Date lastModified;
        private String mimeType;
        private String fileName;
        private boolean isAttachment;

        private ResourceOptions() {
        }

        public void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }

        public void setLastModified(Date lastModified) {
            this.lastModified = lastModified;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public void setExpiresBy(Date date) {
        }

        public void setAsAttachement() {
            this.isAttachment = true;
        }
    }
}

