/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.push.server;

import com.icesoft.faces.webapp.http.common.Request;
import com.icesoft.faces.webapp.http.common.Server;
import com.icesoft.faces.webapp.http.servlet.SessionDispatcher;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.icefaces.push.server.SessionManager;

public abstract class SendUpdatedViewsServer
implements Server {
    private static final Log LOG = LogFactory.getLog((Class)SendUpdatedViewsServer.class);
    private final SessionManager sessionManager;
    private final SessionDispatcher.Monitor monitor;

    public SendUpdatedViewsServer(SessionManager sessionManager, SessionDispatcher.Monitor monitor) {
        this.sessionManager = sessionManager;
        this.monitor = monitor;
    }

    public void service(Request request) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Extracting ICEfaces ID(s)...");
        }
        HashSet<String> _iceFacesIdSet = new HashSet<String>();
        try {
            String[] _iceFacesIds = request.getParameterAsStrings("ice.session");
            for (int i = 0; i < _iceFacesIds.length; ++i) {
                if (this.sessionManager.isValid(_iceFacesIds[i])) {
                    _iceFacesIdSet.add(_iceFacesIds[i]);
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Invalid ICEfaces ID: " + _iceFacesIds[i] + ")"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("ICEfaces ID(s): " + _iceFacesIdSet));
        }
        this.monitor.touchSession();
        this.handle(request, _iceFacesIdSet);
    }

    public abstract void handle(Request var1, Set var2);

    public void shutdown() {
    }
}

