/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.schema;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axis2.schema.CompilerOptions;
import org.apache.axis2.schema.SchemaCompiler;
import org.apache.axis2.schema.i18n.SchemaCompilerMessages;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.w3c.dom.Document;

public class XSD2Java {
    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.out.println(SchemaCompilerMessages.getMessage("schema.xsdarg1"));
            System.out.println(SchemaCompilerMessages.getMessage("schema.xsdarg2"));
        } else {
            XSD2Java.compile(args[0], args[1]);
        }
    }

    private static void compile(String xsdName, String outputLocation) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder builder = documentBuilderFactory.newDocumentBuilder();
        Document doc = builder.parse(new File(xsdName));
        XmlSchemaCollection schemaCol = new XmlSchemaCollection();
        XmlSchema currentSchema = schemaCol.read(doc, null);
        File outputFolder = new File(outputLocation);
        if (outputFolder.exists()) {
            if (outputFolder.isFile()) {
                throw new IOException(SchemaCompilerMessages.getMessage("schema.locationNotFolder"));
            }
        } else {
            outputFolder.mkdirs();
        }
        CompilerOptions compilerOptions = new CompilerOptions();
        compilerOptions.setOutputLocation(outputFolder);
        compilerOptions.setGenerateAll(true);
        compilerOptions.setWrapClasses(false);
        compilerOptions.setWriteOutput(true);
        SchemaCompiler compiler = new SchemaCompiler(compilerOptions);
        compiler.compile(currentSchema);
    }
}

