/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.intercept.web;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.acegisecurity.ConfigAttributeDefinition;
import org.acegisecurity.intercept.web.AbstractFilterInvocationDefinitionSource;
import org.acegisecurity.intercept.web.FilterInvocationDefinitionMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;

public class PathBasedFilterInvocationDefinitionMap
extends AbstractFilterInvocationDefinitionSource
implements FilterInvocationDefinitionMap {
    private static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$intercept$web$PathBasedFilterInvocationDefinitionMap == null ? (class$org$acegisecurity$intercept$web$PathBasedFilterInvocationDefinitionMap = PathBasedFilterInvocationDefinitionMap.class$("org.acegisecurity.intercept.web.PathBasedFilterInvocationDefinitionMap")) : class$org$acegisecurity$intercept$web$PathBasedFilterInvocationDefinitionMap));
    private List requestMap = new Vector();
    private PathMatcher pathMatcher = new AntPathMatcher();
    private boolean convertUrlToLowercaseBeforeComparison = false;
    static /* synthetic */ Class class$org$acegisecurity$intercept$web$PathBasedFilterInvocationDefinitionMap;

    public void addSecureUrl(String antPath, ConfigAttributeDefinition attr) {
        this.requestMap.add(new EntryHolder(antPath, attr));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Added Ant path: " + antPath + "; attributes: " + attr));
        }
    }

    public Iterator getConfigAttributeDefinitions() {
        HashSet<ConfigAttributeDefinition> set = new HashSet<ConfigAttributeDefinition>();
        Iterator iter = this.requestMap.iterator();
        while (iter.hasNext()) {
            EntryHolder entryHolder = (EntryHolder)iter.next();
            set.add(entryHolder.getConfigAttributeDefinition());
        }
        return set.iterator();
    }

    public int getMapSize() {
        return this.requestMap.size();
    }

    public boolean isConvertUrlToLowercaseBeforeComparison() {
        return this.convertUrlToLowercaseBeforeComparison;
    }

    public ConfigAttributeDefinition lookupAttributes(String url) {
        int firstQuestionMarkIndex = url.lastIndexOf("?");
        if (firstQuestionMarkIndex != -1) {
            url = url.substring(0, firstQuestionMarkIndex);
        }
        if (this.convertUrlToLowercaseBeforeComparison) {
            url = url.toLowerCase();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Converted URL to lowercase, from: '" + url + "'; to: '" + url + "'"));
            }
        }
        Iterator iter = this.requestMap.iterator();
        while (iter.hasNext()) {
            EntryHolder entryHolder = (EntryHolder)iter.next();
            boolean matched = this.pathMatcher.match(entryHolder.getAntPath(), url);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Candidate is: '" + url + "'; pattern is " + entryHolder.getAntPath() + "; matched=" + matched));
            }
            if (!matched) continue;
            return entryHolder.getConfigAttributeDefinition();
        }
        return null;
    }

    public void setConvertUrlToLowercaseBeforeComparison(boolean convertUrlToLowercaseBeforeComparison) {
        this.convertUrlToLowercaseBeforeComparison = convertUrlToLowercaseBeforeComparison;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class EntryHolder {
        private ConfigAttributeDefinition configAttributeDefinition;
        private String antPath;

        public EntryHolder(String antPath, ConfigAttributeDefinition attr) {
            this.antPath = antPath;
            this.configAttributeDefinition = attr;
        }

        protected EntryHolder() {
            throw new IllegalArgumentException("Cannot use default constructor");
        }

        public String getAntPath() {
            return this.antPath;
        }

        public ConfigAttributeDefinition getConfigAttributeDefinition() {
            return this.configAttributeDefinition;
        }
    }
}

