/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.core;

import com.icesoft.faces.env.SpringWebFlowInstantiationServlet;
import com.icesoft.faces.webapp.http.core.JsfLifecycleExecutor;
import com.icesoft.faces.webapp.http.core.SwfLifecycleExecutor;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.webflow.executor.FlowExecutor;

public abstract class LifecycleExecutor {
    private static Log log = LogFactory.getLog((Class)LifecycleExecutor.class);
    private static String JSF_EXEC = "JSF Lifecyle Executor";
    private static String SWF_EXEC = "SWF Lifecyle Executor";

    public static LifecycleExecutor getLifecycleExecutor(FacesContext context) {
        LifecycleExecutor.init(context);
        Map appMap = context.getExternalContext().getApplicationMap();
        Object swfExecObj = appMap.get(SWF_EXEC);
        if (null != swfExecObj && !LifecycleExecutor.isExtensionMapped(context)) {
            return (LifecycleExecutor)swfExecObj;
        }
        return (LifecycleExecutor)appMap.get(JSF_EXEC);
    }

    protected LifecycleExecutor getJsfLifecycleExecutor(FacesContext context) {
        Map appMap = context.getExternalContext().getApplicationMap();
        return (LifecycleExecutor)appMap.get(JSF_EXEC);
    }

    public abstract void apply(FacesContext var1);

    private static void init(FacesContext context) {
        FlowExecutor flowExecutor;
        Map appMap;
        block4: {
            appMap = context.getExternalContext().getApplicationMap();
            Object obj = appMap.get(JSF_EXEC);
            if (null != obj) {
                return;
            }
            appMap.put(JSF_EXEC, new JsfLifecycleExecutor());
            flowExecutor = null;
            try {
                flowExecutor = SpringWebFlowInstantiationServlet.getFlowExecutor();
            }
            catch (Throwable t) {
                if (!log.isDebugEnabled()) break block4;
                log.debug((Object)"SpringWebFlow unavailable ");
            }
        }
        if (null != flowExecutor) {
            appMap.put(SWF_EXEC, new SwfLifecycleExecutor());
        }
    }

    static boolean isExtensionMapped(FacesContext facesContext) {
        int dotIndex;
        String requestURI;
        int slashIndex;
        Object request = facesContext.getExternalContext().getRequest();
        return request instanceof HttpServletRequest && (slashIndex = (requestURI = ((HttpServletRequest)request).getRequestURI()).lastIndexOf("/")) < (dotIndex = requestURI.lastIndexOf("."));
    }
}

