/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.core;

import com.icesoft.faces.webapp.http.common.Configuration;
import com.icesoft.faces.webapp.http.common.Request;
import com.icesoft.faces.webapp.http.common.Server;
import com.icesoft.faces.webapp.http.common.standard.EmptyResponse;
import com.icesoft.faces.webapp.http.core.SessionExpiredResponse;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RequestVerifier
implements Server {
    private static final Log log = LogFactory.getLog((Class)RequestVerifier.class);
    private Configuration configuration;
    private String sessionID;
    private Server server;

    public RequestVerifier(Configuration configuration, String sessionID, Server server) {
        this.configuration = configuration;
        this.sessionID = sessionID;
        this.server = server;
    }

    public void service(Request request) throws Exception {
        if ("GET".equalsIgnoreCase(request.getMethod())) {
            log.info((Object)"'POST' request expected. Dropping connection...");
            request.respondWith(EmptyResponse.Handler);
        } else if (request.containsParameter("ice.session") && !"".equals(request.getParameter("ice.session"))) {
            if (Arrays.asList(request.getParameterAsStrings("ice.session")).contains(this.sessionID)) {
                this.server.service(request);
            } else {
                log.debug((Object)"Missmatched 'ice.session' value. Session has expired.");
                if ("true".equalsIgnoreCase(this.configuration.getAttribute("sessionExpiredServerRedirect", "false"))) {
                    request.respondWith(SessionExpiredResponse.getRedirectingHandler(this.configuration.getAttribute("sessionExpiredRedirectURI")));
                } else {
                    request.respondWith(SessionExpiredResponse.Handler);
                }
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Request missing 'ice.session' required parameter. Dropping connection...");
            }
            request.respondWith(EmptyResponse.Handler);
        }
    }

    public void shutdown() {
        this.server.shutdown();
    }
}

