/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.core;

import com.icesoft.faces.webapp.command.Command;
import com.icesoft.faces.webapp.command.CommandQueue;
import com.icesoft.faces.webapp.command.NOOP;
import com.icesoft.faces.webapp.http.common.Configuration;
import com.icesoft.faces.webapp.http.common.Request;
import com.icesoft.faces.webapp.http.common.Server;
import com.icesoft.faces.webapp.http.common.standard.FixedXMLContentHandler;
import com.icesoft.faces.webapp.http.core.PageTest;
import com.icesoft.faces.webapp.http.core.ReloadResponse;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SendUpdates
implements Server {
    private static final Log LOG = LogFactory.getLog((Class)SendUpdates.class);
    private static final Command NOOP = new NOOP();
    private Map commandQueues;
    private PageTest pageTest;
    private static boolean debugDOMUpdate;

    public SendUpdates(Configuration configuration, Map commandQueues, PageTest pageTest) {
        this.commandQueues = commandQueues;
        this.pageTest = pageTest;
        debugDOMUpdate = configuration.getAttributeAsBoolean("debugDOMUpdate", false);
    }

    public void service(Request request) throws Exception {
        if (!this.pageTest.isLoaded()) {
            request.respondWith(new ReloadResponse(""));
        } else {
            request.respondWith(new Handler(this.commandQueues, request));
        }
    }

    public void shutdown() {
    }

    public static class Handler
    extends FixedXMLContentHandler {
        private final Request request;
        private Map commandQueues;

        public Handler(Map commandQueues, Request request) {
            this.commandQueues = commandQueues;
            this.request = request;
        }

        public void writeTo(Writer writer) throws IOException {
            String viewIdentifier = this.request.getParameter("ice.view");
            if (this.commandQueues.containsKey(viewIdentifier)) {
                CommandQueue queue = (CommandQueue)this.commandQueues.get(viewIdentifier);
                Command command = queue.take();
                if (debugDOMUpdate) {
                    System.out.println(command);
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)command);
                }
                command.serializeTo(writer);
            } else {
                NOOP.serializeTo(writer);
            }
        }
    }
}

