/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.clustering.ClusterManager;
import org.apache.axis2.clustering.LoadBalanceEventHandler;
import org.apache.axis2.clustering.Member;
import org.apache.axis2.clustering.configuration.ConfigurationManager;
import org.apache.axis2.clustering.configuration.ConfigurationManagerListener;
import org.apache.axis2.clustering.context.ContextManager;
import org.apache.axis2.clustering.context.ContextManagerListener;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.DescriptionBuilder;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.i18n.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClusterBuilder
extends DescriptionBuilder {
    private static final Log log = LogFactory.getLog(ClusterBuilder.class);

    public ClusterBuilder(AxisConfiguration axisConfig) {
        this.axisConfig = axisConfig;
    }

    public void buildCluster(OMElement clusterElement) throws DeploymentException {
        if (!this.isEnabled(clusterElement)) {
            log.info((Object)"Clustering has been disabled");
            return;
        }
        log.info((Object)"Clustering has been enabled");
        OMAttribute classNameAttr = clusterElement.getAttribute(new QName("class"));
        if (classNameAttr == null) {
            throw new DeploymentException(Messages.getMessage("classAttributeNotFound", "cluster"));
        }
        String className = classNameAttr.getAttributeValue();
        try {
            Class<?> clazz;
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException(Messages.getMessage("clusterImplNotFound", className));
            }
            ClusterManager clusterManager = (ClusterManager)clazz.newInstance();
            clusterManager.setConfigurationContext(this.configCtx);
            this.processParameters(clusterElement.getChildrenWithName(new QName("parameter")), clusterManager, null);
            this.loadApplicationDomains(clusterManager, clusterElement);
            this.loadWellKnownMembers(clusterManager, clusterElement);
            this.loadConfigManager(clusterElement, clusterManager);
            this.loadContextManager(clusterElement, clusterManager);
            this.axisConfig.setClusterManager(clusterManager);
        }
        catch (InstantiationException e) {
            throw new DeploymentException(Messages.getMessage("cannotLoadClusterImpl"));
        }
        catch (IllegalAccessException e) {
            throw new DeploymentException(e);
        }
    }

    private boolean isEnabled(OMElement element) {
        boolean enabled = true;
        OMAttribute enableAttr = element.getAttribute(new QName("enable"));
        if (enableAttr != null) {
            enabled = Boolean.parseBoolean(enableAttr.getAttributeValue().trim());
        }
        return enabled;
    }

    private void loadApplicationDomains(ClusterManager clusterManager, OMElement clusterElement) throws DeploymentException {
        OMElement lbEle = clusterElement.getFirstChildWithName(new QName("loadBalancer"));
        if (lbEle != null) {
            if (!this.isEnabled(lbEle)) {
                log.info((Object)"Running in application mode");
                return;
            }
            log.info((Object)"Running in load balance mode");
            Iterator iter = lbEle.getChildrenWithName(new QName("applicationDomain"));
            while (iter.hasNext()) {
                LoadBalanceEventHandler eventHandler;
                OMElement omElement = (OMElement)iter.next();
                String domainName = omElement.getAttributeValue(new QName("name")).trim();
                String handlerClass = omElement.getAttributeValue(new QName("handler")).trim();
                try {
                    eventHandler = (LoadBalanceEventHandler)Class.forName(handlerClass).newInstance();
                }
                catch (Exception e) {
                    String msg = "Could not instantiate LoadBalanceEventHandler " + handlerClass + " for domain " + domainName;
                    log.error((Object)msg, (Throwable)e);
                    throw new DeploymentException(msg, e);
                }
                clusterManager.addLoadBalanceEventHandler(eventHandler, domainName);
            }
        }
    }

    private void loadWellKnownMembers(ClusterManager clusterManager, OMElement clusterElement) {
        String membershipScheme;
        clusterManager.setMembers(new ArrayList<Member>());
        Parameter membershipSchemeParam = clusterManager.getParameter("membershipScheme");
        if (membershipSchemeParam != null && (membershipScheme = ((String)membershipSchemeParam.getValue()).trim()).equals("wka")) {
            ArrayList<Member> members = new ArrayList<Member>();
            OMElement membersEle = clusterElement.getFirstChildWithName(new QName("members"));
            if (membersEle != null) {
                Iterator iter = membersEle.getChildrenWithLocalName("member");
                while (iter.hasNext()) {
                    OMElement memberEle = (OMElement)iter.next();
                    String hostName = memberEle.getFirstChildWithName(new QName("hostName")).getText().trim();
                    String port = memberEle.getFirstChildWithName(new QName("port")).getText().trim();
                    members.add(new Member(this.replaceVariables(hostName), Integer.parseInt(this.replaceVariables(port))));
                }
            }
            clusterManager.setMembers(members);
        }
    }

    private String replaceVariables(String text) {
        int indexOfClosingBrace;
        int indexOfStartingChars = text.indexOf("${");
        if (indexOfStartingChars != -1 && (indexOfClosingBrace = text.indexOf("}")) != -1) {
            String var = text.substring(indexOfStartingChars + 2, indexOfClosingBrace);
            String propValue = System.getProperty(var);
            if (propValue == null) {
                propValue = System.getenv(var);
            }
            if (propValue != null) {
                text = text.substring(0, indexOfStartingChars) + propValue + text.substring(indexOfClosingBrace + 1);
            }
        }
        return text;
    }

    private void loadContextManager(OMElement clusterElement, ClusterManager clusterManager) throws DeploymentException, InstantiationException, IllegalAccessException {
        OMElement contextManagerEle = clusterElement.getFirstChildWithName(new QName("contextManager"));
        if (contextManagerEle != null) {
            Class<?> clazz;
            if (!this.isEnabled(contextManagerEle)) {
                log.info((Object)"Clustering context management has been disabled");
                return;
            }
            log.info((Object)"Clustering context management has been enabled");
            OMAttribute classNameAttr = contextManagerEle.getAttribute(new QName("class"));
            if (classNameAttr == null) {
                throw new DeploymentException(Messages.getMessage("classAttributeNotFound", "contextManager"));
            }
            String className = classNameAttr.getAttributeValue();
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException(Messages.getMessage("clusterImplNotFound", className));
            }
            ContextManager contextManager = (ContextManager)clazz.newInstance();
            clusterManager.setContextManager(contextManager);
            OMElement listenerEle = contextManagerEle.getFirstChildWithName(new QName("listener"));
            if (listenerEle != null) {
                classNameAttr = listenerEle.getAttribute(new QName("class"));
                if (classNameAttr == null) {
                    throw new DeploymentException(Messages.getMessage("classAttributeNotFound", "listener"));
                }
                className = classNameAttr.getAttributeValue();
                try {
                    clazz = Class.forName(className);
                }
                catch (ClassNotFoundException e) {
                    throw new DeploymentException(Messages.getMessage("clusterImplNotFound", className));
                }
            } else {
                throw new DeploymentException(Messages.getMessage("contextManagerListenerIsNull"));
            }
            ContextManagerListener listener = (ContextManagerListener)clazz.newInstance();
            contextManager.setContextManagerListener(listener);
            this.processParameters(contextManagerEle.getChildrenWithName(new QName("parameter")), contextManager, null);
            OMElement replicationEle = contextManagerEle.getFirstChildWithName(new QName("replication"));
            if (replicationEle != null) {
                OMElement defaultsEle = replicationEle.getFirstChildWithName(new QName("defaults"));
                if (defaultsEle != null) {
                    ArrayList<String> defaults = new ArrayList<String>();
                    Iterator iter = defaultsEle.getChildrenWithName(new QName("exclude"));
                    while (iter.hasNext()) {
                        OMElement excludeEle = (OMElement)iter.next();
                        OMAttribute nameAtt = excludeEle.getAttribute(new QName("name"));
                        defaults.add(nameAtt.getAttributeValue());
                    }
                    contextManager.setReplicationExcludePatterns("defaults", defaults);
                }
                Iterator iter = replicationEle.getChildrenWithName(new QName("context"));
                while (iter.hasNext()) {
                    OMElement contextEle = (OMElement)iter.next();
                    String ctxClassName = contextEle.getAttribute(new QName("class")).getAttributeValue();
                    ArrayList<String> excludes = new ArrayList<String>();
                    Iterator iter2 = contextEle.getChildrenWithName(new QName("exclude"));
                    while (iter2.hasNext()) {
                        OMElement excludeEle = (OMElement)iter2.next();
                        OMAttribute nameAtt = excludeEle.getAttribute(new QName("name"));
                        excludes.add(nameAtt.getAttributeValue());
                    }
                    contextManager.setReplicationExcludePatterns(ctxClassName, excludes);
                }
            }
        }
    }

    private void loadConfigManager(OMElement clusterElement, ClusterManager clusterManager) throws DeploymentException, InstantiationException, IllegalAccessException {
        OMElement configManagerEle = clusterElement.getFirstChildWithName(new QName("configurationManager"));
        if (configManagerEle != null) {
            Class<?> clazz;
            if (!this.isEnabled(configManagerEle)) {
                log.info((Object)"Clustering configuration management has been disabled");
                return;
            }
            log.info((Object)"Clustering configuration management has been enabled");
            OMAttribute classNameAttr = configManagerEle.getAttribute(new QName("class"));
            if (classNameAttr == null) {
                throw new DeploymentException(Messages.getMessage("classAttributeNotFound", "configurationManager"));
            }
            String className = classNameAttr.getAttributeValue();
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException(Messages.getMessage("clusterImplNotFound", className));
            }
            ConfigurationManager configurationManager = (ConfigurationManager)clazz.newInstance();
            clusterManager.setConfigurationManager(configurationManager);
            OMElement listenerEle = configManagerEle.getFirstChildWithName(new QName("listener"));
            if (listenerEle != null) {
                classNameAttr = listenerEle.getAttribute(new QName("class"));
                if (classNameAttr == null) {
                    throw new DeploymentException(Messages.getMessage("clusterImplNotFound", "listener"));
                }
                className = classNameAttr.getAttributeValue();
                try {
                    clazz = Class.forName(className);
                }
                catch (ClassNotFoundException e) {
                    throw new DeploymentException(Messages.getMessage("configurationManagerListenerIsNull"));
                }
            } else {
                throw new DeploymentException(Messages.getMessage("configurationManagerListenerIsNull"));
            }
            ConfigurationManagerListener listener = (ConfigurationManagerListener)clazz.newInstance();
            listener.setConfigurationContext(this.configCtx);
            configurationManager.setConfigurationManagerListener(listener);
            configurationManager.setConfigurationContext(this.configCtx);
            this.processParameters(configManagerEle.getChildrenWithName(new QName("parameter")), configurationManager, null);
        }
    }
}

